/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class RevoteCompositeTaskIdCmd
implements Command<Void> {
    private Collection<Long> taskIds;
    private List<TaskEntity> compositeTaskEntities;

    public RevoteCompositeTaskIdCmd(Collection<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public RevoteCompositeTaskIdCmd(Collection<Long> taskIds, List<TaskEntity> compositeTaskEntities) {
        this.taskIds = taskIds;
        this.compositeTaskEntities = compositeTaskEntities;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskIds == null || this.taskIds.isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter("compositetaskid", "in", this.taskIds);
        List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{filter});
        if (identityLinkEntities != null && !identityLinkEntities.isEmpty()) {
            ArrayList<IdentityLinkEntity> survives = new ArrayList<IdentityLinkEntity>();
            ArrayList<Long> compositeTaskIds = new ArrayList<Long>();
            if (this.compositeTaskEntities != null && this.compositeTaskEntities.size() > 0) {
                for (TaskEntity compositeTaskEntity : this.compositeTaskEntities) {
                    compositeTaskIds.add(compositeTaskEntity.getId());
                }
            }
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                Long l = identityLinkEntity.getTaskId();
                if (this.taskIds.contains(l) || compositeTaskIds.contains(l)) continue;
                survives.add(identityLinkEntity);
            }
            if (survives != null && !survives.isEmpty()) {
                String key;
                HashMap<String, Long> newCompositeTaskIds = new HashMap<String, Long>();
                for (IdentityLinkEntity identityLinkEntity : survives) {
                    if (!WfUtils.isNotEmpty(identityLinkEntity.getParenttaskid())) continue;
                    key = String.format("%s.%s", identityLinkEntity.getCompositeTaskId(), identityLinkEntity.getUserId());
                    newCompositeTaskIds.put(key, identityLinkEntity.getTaskId());
                }
                for (IdentityLinkEntity identityLinkEntity : survives) {
                    key = String.format("%s.%s", identityLinkEntity.getCompositeTaskId(), identityLinkEntity.getUserId());
                    Long newCompositeTaskId = (Long)newCompositeTaskIds.get(key);
                    if (WfUtils.isEmpty(newCompositeTaskId)) {
                        newCompositeTaskId = identityLinkEntity.getTaskId();
                        newCompositeTaskIds.put(key, newCompositeTaskId);
                    }
                    Boolean isDisplay = identityLinkEntity.isDisplay();
                    if (identityLinkEntity.getTaskId().equals(newCompositeTaskId)) {
                        identityLinkEntity.setCompositeTaskId(0L);
                        isDisplay = Boolean.TRUE;
                    } else {
                        identityLinkEntity.setCompositeTaskId(newCompositeTaskId);
                        isDisplay = Boolean.FALSE;
                    }
                    identityLinkEntity.setDisplay(isDisplay);
                    commandContext.getIdentityLinkEntityManager().update(identityLinkEntity);
                    HistoricIdentityLinkEntityManager hilkManager = commandContext.getHistoricIdentityLinkEntityManager();
                    HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)hilkManager.findById(identityLinkEntity.getId());
                    if (historicIdentityLinkEntity == null) continue;
                    historicIdentityLinkEntity.setCompositeTaskId(identityLinkEntity.getCompositeTaskId());
                    historicIdentityLinkEntity.setDisplay(isDisplay);
                    hilkManager.update(historicIdentityLinkEntity);
                }
                for (Map.Entry entry : newCompositeTaskIds.entrySet()) {
                    Long taskId = (Long)entry.getValue();
                    commandContext.getMessageService().createToDo(taskId);
                }
            }
        }
        return null;
    }
}

