/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.api.DefaultWorkflowElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.SetUpAgentTaskHandleContext;
import kd.bos.workflow.engine.impl.cmd.task.TashHandleParam;
import kd.bos.workflow.engine.impl.cmd.task.TaskHandleContext;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.variable.ValueFields;
import kd.bos.workflow.engine.task.TaskInfo;

public class SetUpTaskHandleContextCmd
extends SetUpAgentTaskHandleContext
implements Command<TaskHandleContext> {
    private static final long serialVersionUID = 4301977701081221479L;
    private TashHandleParam param = null;

    public SetUpTaskHandleContextCmd(TashHandleParam param) {
        this.param = param;
    }

    @Override
    public TaskHandleContext execute(CommandContext commandContext) {
        Object startAppIdObj;
        Process process;
        TaskHandleContext context = new TaskHandleContext();
        super.getAgentTaskHandleContextData(commandContext, this.param, context);
        TaskInfo taskInfo = context.getTask();
        boolean isGetCaption = super.isGetCaptionScene(this.param);
        if (taskInfo == null || isGetCaption) {
            return context;
        }
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(taskInfo.getProcessDefinitionId(), taskInfo.getProcessInstanceId());
        context.setBpmnModel(model);
        UserTask elem = model == null ? null : (UserTask)model.getFlowElement(taskInfo.getTaskDefinitionKey());
        context.setFlowElement(elem);
        boolean isOnlyView = this.onlyView(elem);
        if (isOnlyView) {
            context.setOnlyView(Boolean.TRUE);
        }
        if (context.getOnlyView().booleanValue()) {
            context.setBillView(Boolean.TRUE);
        } else {
            UserTask userTask;
            boolean isPartipant = context.getTaskParticipant();
            if (isPartipant) {
                context.setBillView(context.getOnlyView());
            } else if (model != null && context.getTaskCoordinate().booleanValue() && (userTask = (UserTask)model.getFlowElement(taskInfo.getTaskDefinitionKey())).getBillSetting() != null && userTask.getBillSetting().isFieldModified() && userTask.getAutoCoordinateModel() != null && userTask.getAutoCoordinateModel().isAutoCoordianteFieldModify()) {
                context.setBillView(Boolean.FALSE);
            }
        }
        if (elem != null && elem.isCompositeTasks()) {
            HashMap<Long, DefaultWorkflowElement> relateTaskInfos = new HashMap<Long, DefaultWorkflowElement>();
            List<HistoricTaskInstanceEntity> taskEntities = commandContext.getHistoricTaskInstanceEntityManager().findCompositeTasksByTaskId(taskInfo.getId(), taskInfo.getProcessInstanceId());
            if (taskEntities != null && !taskEntities.isEmpty()) {
                for (HistoricTaskInstanceEntity task : taskEntities) {
                    if (model == null) continue;
                    FlowElement flowElement = model.getFlowElement(task.getTaskDefinitionKey());
                    DefaultWorkflowElement defaultWorkflowElement = new DefaultWorkflowElement();
                    defaultWorkflowElement.setId(flowElement.getId());
                    defaultWorkflowElement.setName(flowElement.getName());
                    defaultWorkflowElement.setType(flowElement.getType());
                    defaultWorkflowElement.setNumber(flowElement.getNumber());
                    defaultWorkflowElement.setFinished(task.getEndTime() != null);
                    defaultWorkflowElement.setBizIdentifyKey(flowElement.getBizIdentifyKey());
                    if (flowElement instanceof UserTask && ((UserTask)flowElement).getBillSetting() != null) {
                        defaultWorkflowElement.setFormKey(((UserTask)flowElement).getBillSetting().getFormKey());
                        defaultWorkflowElement.setMobileFormKey(((UserTask)flowElement).getBillSetting().getMobilFormKey());
                    }
                    relateTaskInfos.put(task.getId(), defaultWorkflowElement);
                }
            }
            DefaultWorkflowElement defaultWorkflowElement = new DefaultWorkflowElement();
            defaultWorkflowElement.setId(elem.getId());
            defaultWorkflowElement.setName(elem.getName());
            defaultWorkflowElement.setType(elem.getType());
            defaultWorkflowElement.setNumber(elem.getNumber());
            defaultWorkflowElement.setBizIdentifyKey(elem.getBizIdentifyKey());
            if (elem instanceof UserTask && elem.getBillSetting() != null) {
                defaultWorkflowElement.setFormKey(elem.getBillSetting().getFormKey());
                defaultWorkflowElement.setMobileFormKey(elem.getBillSetting().getMobilFormKey());
            }
            if (taskInfo instanceof HistoricTaskInstanceEntity) {
                defaultWorkflowElement.setFinished(((HistoricTaskInstanceEntity)taskInfo).getEndTime() != null);
            }
            relateTaskInfos.put(taskInfo.getId(), defaultWorkflowElement);
            context.setRelateTaskInfos(relateTaskInfos);
        }
        Long procInstanceId = taskInfo.getProcessInstanceId();
        this.loadVariables(commandContext, context, procInstanceId);
        if (null != model && null != (process = model.getMainProcess())) {
            context.setDocumentation(process.getDocumentation());
        }
        if (null != taskInfo && WfUtils.isNotEmpty(taskInfo.getProcessInstanceId()) && WfUtils.isNotEmptyString(startAppIdObj = context.getVaraibleValue("appnumber"))) {
            context.setStartAppId(startAppIdObj.toString());
        }
        return context;
    }

    private void loadVariables(CommandContext commandContext, TaskHandleContext context, Long procInstanceId) {
        String defName = String.format("%s,%s", "appnumber", "pageParameter");
        String procVariableNames = (String)this.param.getCustomParam("procVariableNames");
        if (WfUtils.isNotEmpty(procVariableNames)) {
            defName = procVariableNames + "," + defName;
        }
        String[] names = defName.split(",");
        List<ValueFields> variables = null;
        if ("toHandle".equals(context.getType())) {
            variables = commandContext.getVariableInstanceEntityManager().findVariableInstancesByProcessInstanceId(procInstanceId, names);
        }
        if (variables == null || variables.isEmpty()) {
            variables = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByProcessInstanceId(procInstanceId, names);
        }
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        this.splitProcessInstanceVals(tmp, variables, Arrays.asList(names), procInstanceId);
        this.splitTaskInstanceVals(tmp, variables, Collections.singletonList("pageParameter"), context.getTaskId());
        context.setPageParameter((String)tmp.get("pageParameter"));
        context.setVariables(tmp);
    }

    private void splitTaskInstanceVals(Map<String, Object> tmp, List<ValueFields> variables, Collection<String> varName, Long taskId) {
        if (variables != null) {
            for (ValueFields val : variables) {
                if (val.getTaskId() == null || !val.getTaskId().equals(taskId) || !varName.contains(val.getName())) continue;
                tmp.put(val.getName(), val.getValue());
            }
        }
    }

    private void splitProcessInstanceVals(Map<String, Object> tmp, List<ValueFields> variables, Collection<String> varName, Long procInstanceId) {
        if (variables != null) {
            for (ValueFields val : variables) {
                if (val.getProcessInstanceId() == null || !val.getProcessInstanceId().equals(procInstanceId) || val.getTaskId() != null || !varName.contains(val.getName())) continue;
                tmp.put(val.getName(), val.getValue());
            }
        }
    }

    private boolean onlyView(UserTask elem) {
        if (null == elem) {
            return true;
        }
        String elementType = elem.getType();
        if (WfUtils.isEmpty(elementType)) {
            return true;
        }
        boolean isAuditFlow = "UserTask".equals(elementType) || "AuditTask".equals(elementType) || "YunzhijiaTask".equals(elementType);
        return !isAuditFlow;
    }
}

