/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.bpmn.behavior.CallActivityUtil;
import kd.bos.workflow.engine.impl.cmd.ActivateProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.management.ActivateProcessInstanceByProcessInstanceIdCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class SkipTaskAndContinueCmd
implements Command<Void> {
    private Long currentTaskId;
    private Long curUserId;
    private Map<String, Object> variables;
    private ExecutionEntity execution;
    private boolean isSuspendProcess;
    private Log log = LogFactory.getLog(this.getClass());

    public SkipTaskAndContinueCmd(ExecutionEntity execution, Long curUserId, Map<String, Object> variables) {
        this.execution = execution;
        this.currentTaskId = execution.getCurrentTaskId();
        this.curUserId = curUserId;
        this.variables = variables;
    }

    public SkipTaskAndContinueCmd(ExecutionEntity execution, Long curUserId, Map<String, Object> variables, boolean isSuspendProcess) {
        this.execution = execution;
        this.currentTaskId = execution.getCurrentTaskId();
        this.curUserId = curUserId;
        this.variables = variables;
        this.isSuspendProcess = isSuspendProcess;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        block33: {
            boolean cascade;
            List<TaskEntity> tasks;
            this.log.debug("SkipTaskAndContinueCmd");
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.currentTaskId);
            if (task == null && (tasks = commandContext.getTaskEntityManager().findTasksByExecutionId(this.execution.getId())) != null && tasks.size() > 0) {
                task = tasks.get(0);
            }
            if (this.leaveWhenAuditAbort(this.variables)) {
                taskHelper.planExecutionOperationAsync(commandContext, this.execution);
                return null;
            }
            this.variables = DynamicFlowUtil.extraCurNodeVariablesByDynType(this.execution, this.variables);
            Object type = this.variables.get("dynType");
            boolean bl = cascade = !this.isDynTypeFromParent(type);
            if (task == null) {
                DynamicFlowUtil.removeTransferedVariablesFromPrevNodeWhenGoingoutCurNode(this.execution);
                this.execution.setVariablesLocal(this.variables);
                String skipReason = (String)this.execution.getVariable("skipReason");
                String executionType = (String)this.execution.getVariable("executionType");
                commandContext.getHistoryManager().recordActivityExecutionType(this.execution, executionType, skipReason);
                FlowElement currentFlowElement = this.execution.getCurrentFlowElement();
                if (currentFlowElement instanceof CallActivity || currentFlowElement instanceof BillTask) {
                    if (this.isSubprocessFinished(commandContext)) {
                        if (currentFlowElement instanceof CallActivity) {
                            ExecutionEntity parent;
                            if (this.isSuspendProcess) {
                                new ActivateProcessInstanceCmd(this.execution.getProcessInstanceId()).execute(commandContext);
                            }
                            if ((parent = this.execution.getParent()) != null && !parent.isScope() && parent.isMultiInstanceRoot()) {
                                parent.setVariablesLocal(this.variables);
                            }
                            taskHelper.planExecutionOperationAsync(commandContext, this.execution);
                        } else if (this.isSuspendProcess) {
                            new ActivateProcessInstanceByProcessInstanceIdCmd(this.execution.getProcessInstanceId(), cascade).execute(commandContext);
                        } else {
                            taskHelper.planExecutionOperationAsync(commandContext, this.execution);
                        }
                        return null;
                    }
                    this.log.debug("subProcessNotFinished, executionId:" + this.execution.getId());
                    ExecutionEntity parent = this.execution.getParent();
                    if (parent != null && !parent.isScope()) {
                        parent.setVariablesLocal(this.variables);
                    }
                    CallActivityUtil.abandonCallActivityBySuperExecution(commandContext, this.execution, this.variables);
                    if (this.isSuspendProcess) {
                        new ActivateProcessInstanceByProcessInstanceIdCmd(this.execution.getProcessInstanceId(), cascade).execute(commandContext);
                    }
                    return null;
                }
                this.log.debug(this.execution.toString() + ":skip by comment");
                if (this.isSuspendProcess) {
                    new ActivateProcessInstanceByProcessInstanceIdCmd(this.execution.getProcessInstanceId(), cascade).execute(commandContext);
                } else {
                    taskHelper.planExecutionOperationAsync(commandContext, this.execution);
                }
                return null;
            }
            String callActivityDynType = CallActivityUtil.getCallActivityFinishedDynType(type);
            if (callActivityDynType != null) {
                this.execution.setVariablesLocal(this.variables);
            }
            try (DLock lock = DLock.create((String)String.format("wf/taskcomplete/%s", task.getId()), (String)String.format(ResManager.loadKDString((String)"\u8df3\u8f6c[%1$s]", (String)"SkipTaskAndContinueCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), task.getId())).fastMode();){
                boolean lockNotNeededOrSuccess = lock.tryLock(60000L);
                if (lockNotNeededOrSuccess) {
                    if (this.isSuspendProcess) {
                        if (!task.isDisplay() || this.existRunningDeadLetterJob(commandContext, this.execution.getProcessInstanceId())) {
                            task.setVariablesLocal(this.variables);
                            new ActivateProcessInstanceByProcessInstanceIdCmd(this.execution.getProcessInstanceId(), cascade).execute(commandContext);
                            String skipReason = (String)this.variables.get("skipReason");
                            String executionType = (String)this.variables.get("executionType");
                            commandContext.getHistoryManager().recordActivityExecutionType(this.execution, executionType, skipReason);
                        } else {
                            new ActivateProcessInstanceByProcessInstanceIdCmd(this.execution.getProcessInstanceId(), cascade).execute(commandContext);
                            task.setVariablesLocal(this.variables);
                            taskHelper.skipTask(task, this.curUserId, this.variables);
                        }
                    } else {
                        task.setVariablesLocal(this.variables);
                        taskHelper.skipTask(task, this.curUserId, this.variables);
                    }
                    break block33;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u88ab\u9501\u5b9a\uff0c\u53ef\u80fd\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowServiceImpl_51", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        return null;
    }

    private boolean leaveWhenAuditAbort(Map<String, Object> variables) {
        Long sourceProcInstId;
        String triggerKey;
        if (variables != null && variables.get("auditAbort_sourceProcessInstanceId") instanceof Long && variables.get(triggerKey = String.format("%s_%s", sourceProcInstId = (Long)variables.get("auditAbort_sourceProcessInstanceId"), "triggerExecutionId")) instanceof Long) {
            Long triggerExecutionId = (Long)variables.get(triggerKey);
            Object dynType = variables.get("dynType");
            return dynType == null && triggerExecutionId.equals(this.execution.getId()) && sourceProcInstId.equals(this.execution.getProcessInstanceId());
        }
        return false;
    }

    private boolean isSubprocessFinished(CommandContext commandContext) {
        List<ExecutionEntity> childExecutions = commandContext.getExecutionEntityManager().findChildExecutionsBySuperExecId(this.execution.getId());
        return childExecutions == null || childExecutions.isEmpty();
    }

    private boolean existRunningDeadLetterJob(CommandContext commandContext, Long processInstanceId) {
        return commandContext.getDeadLetterJobEntityManager().existRunningDeadLetterJob(processInstanceId);
    }

    private boolean isDynTypeFromParent(Object type) {
        return "abortByParentProcessJump".equals(type) || "abortByParentProcessAbort".equals(type) || "abortByParentProcessWithdraw".equals(type);
    }
}

