/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.SuspendActiveTaskCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.operation.SuspendOperationParam;

public class SuspendTaskCmd
implements Command<Map<String, Object>> {
    private List<Long> taskIds;
    private Long userId;
    private ILocaleString suspendReason;
    private boolean isSuspendTask = true;
    private static final String DESCRIPTION = "description";
    private static final String SUCCESS = "success";
    private static final String DATA = "data";

    public SuspendTaskCmd(List<Long> taskIds, Long userId, ILocaleString suspendReason, boolean isSuspendTask) {
        this.taskIds = taskIds;
        this.userId = userId;
        this.suspendReason = suspendReason;
        this.isSuspendTask = isSuspendTask;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SuspendOperationParam suspendOperationParam = new SuspendOperationParam();
            suspendOperationParam.setTaskIds(this.taskIds);
            suspendOperationParam.setOperaterId(this.userId);
            suspendOperationParam.setSuspendTask(this.isSuspendTask);
            suspendOperationParam.setSuspendReason(this.suspendReason);
            SuspendActiveTaskCmd suspendActiveTaskCmd = new SuspendActiveTaskCmd(suspendOperationParam);
            BatchOperateResult batchOperateResult = suspendActiveTaskCmd.execute(commandContext);
            result.put(DESCRIPTION, batchOperateResult.getValidateMsg());
            result.put(SUCCESS, batchOperateResult.isSuccess());
            if (!batchOperateResult.isSuccess()) {
                result.put(DATA, batchOperateResult.toString());
            }
        }
        catch (Exception e) {
            result.put(DESCRIPTION, WfUtils.getExceptionStacktrace(e));
            result.put(SUCCESS, false);
        }
        return result;
    }
}

