/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignValidate;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.exception.WFException;

public class TaskAddSignAfterByAdminCmd
extends TaskAddSignValidate
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long procInstId;
    private String activityId;
    private AddSignInfo addSignInfo = new AddSignInfo();

    public TaskAddSignAfterByAdminCmd(Long procInstId, String activityId, AddSignInfo addSignInfo) {
        this.procInstId = procInstId;
        this.activityId = activityId;
        this.addSignInfo = addSignInfo;
    }

    @Override
    public String execute(CommandContext commandContext) {
        String result = this.validate(commandContext, this.procInstId, this.activityId, this.addSignInfo);
        if (WfUtils.isNotEmpty(result)) {
            throw new WFException(result);
        }
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)this.procInstId);
        QFilter qActivityId = new QFilter("activityid", "=", (Object)this.activityId);
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)0);
        QFilter qType = new QFilter("type", "=", (Object)"addsignafter");
        QFilter[] qFilters = new QFilter[]{qActivityId, qActInstId, qType, qInstanceId};
        List dynResources = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (dynResources != null && dynResources.size() > 0) {
            throw new WFException(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u5df2\u7ecf\u52a0\u7b7e\u8fc7\u4e00\u6b21\uff0c\u4e0d\u80fd\u518d\u6b21\u52a0\u7b7e\u3002", (String)"TaskAddSignAfterByAdminCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(this.procInstId);
        bpmnModel.getMainProcess().getFlowElementList();
        FlowElement flowElement = bpmnModel.getFlowElement(this.activityId);
        this.saveOperationLog(commandContext);
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.procInstId);
        execution.setVariable("addsigninfo", SerializationUtils.toJsonString((Object)this.addSignInfo));
        DynProcessProcessorHelper.createDynProcess(execution, (FlowNode)flowElement, "addsignafter", new HashMap<String, Object>());
        return "addsignsucces";
    }

    private String validate(CommandContext commandContext, Long processInstanceId, String activityId, AddSignInfo addSignInfo) {
        BpmnModel bpmnModel;
        String result = super.validateByProcinstId(commandContext, processInstanceId, activityId, addSignInfo.getAddSignType());
        if (WfUtils.isNotEmpty(result)) {
            return result;
        }
        List userIds = addSignInfo.getUserIds();
        if (CollectionUtil.isNotEmpty(userIds)) {
            StringBuilder sb = new StringBuilder();
            DynamicObjectCollection userCols = QueryServiceHelper.query((String)"bos_user", (String)"id,enable,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds)});
            for (Long userId : userIds) {
                boolean exist = false;
                for (DynamicObject userCol : userCols) {
                    if (!userId.equals(userCol.getLong("id"))) continue;
                    exist = true;
                    if (userCol.getBoolean("enable")) continue;
                    sb.append(userId).append('(').append(userCol.getString("name")).append(')').append(WFMultiLangConstants.getNotEnableName()).append(',');
                    break;
                }
                if (exist) continue;
                sb.append(userId).append(' ').append(WFMultiLangConstants.getNotExistName()).append(',');
            }
            if (sb.length() > 1) {
                return sb.substring(0, sb.length() - 1);
            }
        }
        if ((bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(processInstanceId)).getMainProcess().getFlowElement(activityId) == null) {
            return String.format("%s %s", activityId, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u6b63\u786e\u3002", (String)"TaskAddSignAfterByAdminCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return result;
    }

    private LocaleString getAddSignMsg(Map<String, String> addSingMsg) {
        LocaleString localeString = new LocaleString();
        for (Map.Entry<String, String> entry : addSingMsg.entrySet()) {
            localeString.put(entry.getKey(), (Object)this.getAddSignMsgStr(entry.getValue()));
        }
        return localeString;
    }

    private String getAddSignMsgStr(String addSignMsgStr) {
        if (WfUtils.isEmpty(addSignMsgStr)) {
            return null;
        }
        return addSignMsgStr.substring(addSignMsgStr.indexOf(58) + 1, addSignMsgStr.length());
    }

    private void saveOperationLog(CommandContext commandContext) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        operationLog.setType("addsign");
        Long userId = RequestContext.get().getCurrUserId();
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(this.procInstId);
        FlowElement flowElement = bpmnModel.getFlowElement(this.activityId);
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(this.procInstId);
        ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, flowElement.getId() + ".name", flowElement.getName());
        operationLog.setActivityName(nodeName);
        operationLog.setActivityId(this.activityId);
        operationLog.setProcInstId(this.procInstId);
        operationLog.setNOpinion((ILocaleString)this.getAddSignMsg(this.addSignInfo.getAddSingMsg()));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u7ba1\u7406\u5458\u540e\u52a0\u7b7e", "TaskAddSignAfterByAdminCmd_0", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

