/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignValidate;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;

public class TaskAddSignAfterCmd
extends TaskAddSignValidate
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long processInstanceId;
    private Long taskId;
    private AddSignInfo addSignInfo = new AddSignInfo();

    public TaskAddSignAfterCmd(Long processInstanceId, Long taskId, AddSignInfo addSignInfo) {
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
        this.addSignInfo = addSignInfo;
    }

    @Override
    public String execute(CommandContext commandContext) {
        String result = this.validate(commandContext, this.processInstanceId, this.taskId, this.addSignInfo.getAddSignType(), this.addSignInfo.getOwnerId());
        if (WfUtils.isNotEmpty(result)) {
            return result;
        }
        this.saveOperationLog(commandContext, this.taskId);
        ExecutionEntity execution = this.getExecutionEntity(commandContext, this.taskId);
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)execution.getProcessInstanceId());
        QFilter qActityId = new QFilter("activityid", "=", (Object)execution.getActivityId());
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)execution.getCurrentActInstId());
        QFilter qType = new QFilter("type", "=", (Object)"addsignafter");
        QFilter[] qFilters = new QFilter[]{qActityId, qActInstId, qType, qInstanceId};
        List dynamicResourceEntities = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (dynamicResourceEntities != null && !dynamicResourceEntities.isEmpty()) {
            DynProcessProcessorHelper.clearDynProcess(execution, "addsignafter");
        }
        execution.setVariable("addsigninfo", SerializationUtils.toJsonString((Object)this.addSignInfo));
        DynProcessProcessorHelper.createDynProcess(execution, (FlowNode)execution.getCurrentFlowElement(), "addsignafter", new HashMap<String, Object>());
        String key = String.format("%s_%s", execution.getCurrentActivityId(), "rejectToForkInnerAndSkip");
        execution.getProcessInstance().removeVariable(key);
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("currentNodeId", execution.getActivityId());
            jsonMap.put("addSignMsg", this.addSignInfo.getAddSingMsg().toString());
            new EventTriggerCmd("wf.AfterAddAssignEvent", execution, jsonMap).execute(commandContext);
        }
        return "addsignsucces";
    }

    private LocaleString getAddSignMsg(Map<String, String> addSingMsg) {
        LocaleString localeString = new LocaleString();
        for (Map.Entry<String, String> entry : addSingMsg.entrySet()) {
            localeString.put(entry.getKey(), (Object)this.getAddSignMsgStr(entry.getValue()));
        }
        return localeString;
    }

    private String getAddSignMsgStr(String addSignMsgStr) {
        if (WfUtils.isEmpty(addSignMsgStr)) {
            return null;
        }
        return addSignMsgStr.substring(addSignMsgStr.indexOf(58) + 1, addSignMsgStr.length());
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("addsign");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNOpinion((ILocaleString)this.getAddSignMsg(this.addSignInfo.getAddSingMsg()));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u540e\u52a0\u7b7e", "TaskAddSignAfterCmd_0", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

