/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.SkipTaskAndContinueCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignValidate;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.WFMessageServiceHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class TaskAddSignBeforeCmd
extends TaskAddSignValidate
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long processInstanceId;
    private Long taskId;
    private AddSignInfo addSignInfo = new AddSignInfo();

    public TaskAddSignBeforeCmd(Long processInstanceId, Long taskId, AddSignInfo addSignInfo) {
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
        this.addSignInfo = addSignInfo;
    }

    @Override
    public String execute(CommandContext commandContext) {
        Object rejectBackToNode;
        boolean isRejectBackToNode;
        String result = this.validate(commandContext, this.processInstanceId, this.taskId, this.addSignInfo.getAddSignType(), this.addSignInfo.getOwnerId());
        if (WfUtils.isNotEmpty(result)) {
            return result;
        }
        this.saveOperationLog(commandContext, this.taskId);
        ExecutionEntity execution = this.getExecutionEntity(commandContext, this.taskId);
        String lastUserNode = (String)execution.getVariableLocal("lastUserDealNode");
        if (WfUtils.isNotEmpty(lastUserNode) && "start".equals(lastUserNode)) {
            execution.setVariableLocal("lastUserDealNode", "jump");
        }
        boolean bl = isRejectBackToNode = (rejectBackToNode = execution.getVariable("rejectBackToNode")) != null && "true".equals(rejectBackToNode);
        if (isRejectBackToNode) {
            execution.setVariable("rejectBackToNode", "false");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("addsigninfo", SerializationUtils.toJsonString((Object)this.addSignInfo));
        variables.put("dynType", "addsignbefore");
        Long curUserId = Long.valueOf(RequestContext.get().getUserId());
        new SkipTaskAndContinueCmd(execution, curUserId, variables, false).execute(commandContext);
        this.sendMessageToAddSingers(this.addSignInfo, execution, commandContext);
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("currentNodeId", execution.getActivityId());
            jsonMap.put("addSignMsg", this.addSignInfo.getAddSingMsg().toString());
            new EventTriggerCmd("wf.AfterAddBeforeAssignEvent", execution, jsonMap).execute(commandContext);
        }
        return "addsignsucces";
    }

    private void sendMessageToAddSingers(AddSignInfo addSignInfo, ExecutionEntity execution, CommandContext commandContext) {
        boolean sendable = WfConfigurationUtil.needPreAddSignMsg();
        if (!sendable) {
            return;
        }
        ArrayList userIds = addSignInfo.getUserIds();
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        if ("seq".equals(addSignInfo.getAddSignDealType())) {
            ArrayList newUserIds = new ArrayList();
            newUserIds.add(userIds.get(0));
            userIds = newUserIds;
        }
        LocaleString addSignMsg = this.getAddSignMsg(addSignInfo.getAddSingMsg());
        ILocaleString entraBillName = execution.getEntraBillName();
        String currentUserId = RequestContext.get().getUserId();
        ILocaleString currentUserName = WfUtils.findUserName(Long.valueOf(currentUserId));
        ILocaleString contentValue = WfUtils.getPromptWordLocaleString("\u52a0\u7b7e\uff1a%s", "TaskAddSignBeforeCmd_3", "bos-wf-engine");
        ILocaleString content = WfMultiLangUtils.getMultiLangValue(contentValue, entraBillName);
        ILocaleString preContentDetail = WfUtils.getPromptWordLocaleString("\u52a0\u7b7e\u4eba\uff1a%1$s \u52a0\u7b7e\u8bf4\u660e\uff1a%2$s", "TaskAddSignBeforeCmd_4", "bos-wf-engine");
        ILocaleString contentDetail = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{preContentDetail, currentUserName, addSignMsg});
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setUserIds(userIds);
        messageInfo.setMessageTitle(content);
        messageInfo.setMessageContent(contentDetail);
        messageInfo.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "TaskAddSignBeforeCmd_1", "bos-wf-engine"));
        messageInfo.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("message"));
        messageInfo.setPubaccNumber("flowassist");
        messageInfo.setTplScene(MessageTypeEnum.ADDSIGN.getNumber());
        messageInfo.setEntityNumber("wf_task");
        messageInfo.setBizDataId(this.taskId);
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        messageInfo.getParams().put("bizEntityObject", DynamicObjectJsonSerializer.convertDynamicObjectToJson(taskEntity.getDynamicObject()));
        messageInfo.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "MessageScheduleHelper_1", "bos-wf-engine"));
        MessageContext messageContext = MessageServiceUtil.buildMessageContext(this.taskId);
        WFMessageServiceHelper.sendMessageToAdmins(messageContext, messageInfo);
    }

    private LocaleString getAddSignMsg(Map<String, String> addSingMsg) {
        LocaleString localeString = new LocaleString();
        for (Map.Entry<String, String> entry : addSingMsg.entrySet()) {
            localeString.put(entry.getKey(), (Object)this.getAddSignMsgStr(entry.getValue()));
        }
        return localeString;
    }

    private String getAddSignMsgStr(String addSignMsgStr) {
        if (WfUtils.isEmpty(addSignMsgStr)) {
            return null;
        }
        return addSignMsgStr.substring(addSignMsgStr.indexOf(58) + 1, addSignMsgStr.length());
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("addsign");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNOpinion((ILocaleString)this.getAddSignMsg(this.addSignInfo.getAddSingMsg()));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u524d\u52a0\u7b7e", "TaskAddSignBeforeCmd_5", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

