/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignValidate;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.exception.WFException;

public class TaskAddSignClearByAdminCmd
extends TaskAddSignValidate
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long procInstId;
    private String activityId;

    public TaskAddSignClearByAdminCmd(Long procInstId, String activityId) {
        this.procInstId = procInstId;
        this.activityId = activityId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        this.validateBeforeDelete(commandContext);
        this.saveOperationLog(commandContext);
        return DynProcessProcessorHelper.clearDynProcess(this.procInstId, this.activityId, "addsignafter");
    }

    private void validateBeforeDelete(CommandContext commandContext) {
        HistoricProcessInstanceEntity hiProInstEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.procInstId);
        if (hiProInstEntity == null) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"TaskAddSignClearByAdminCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), this.procInstId));
        }
        Process bpmnModel = ProcessDefinitionUtil.getProcessByProcInstId(this.procInstId);
        FlowElement element = bpmnModel.getFlowElement(this.activityId);
        if (element == null) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u8282\u70b9ID\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"TaskAddSignClearByAdminCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.activityId));
        }
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)this.procInstId);
        QFilter qActityId = new QFilter("activityid", "=", (Object)this.activityId);
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)0);
        QFilter qType = new QFilter("type", "=", (Object)"addsignafter");
        QFilter[] qFilters = new QFilter[]{qActInstId, qActityId, qType, qInstanceId};
        List dynamicResourceEntities = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (dynamicResourceEntities == null || dynamicResourceEntities.isEmpty()) {
            throw new WFException("noresource");
        }
        ArrayList<String> activities = new ArrayList<String>();
        for (DynamicResourceEntity dynamicResourceEntity : dynamicResourceEntities) {
            BpmnModel dynBpmnModel;
            List<FlowElement> flowElementList;
            ILocaleString content = dynamicResourceEntity.getContent();
            if (content == null || content.getLocaleValue() == null || CollectionUtil.isEmpty(flowElementList = (dynBpmnModel = ProcessDefinitionUtil.getBpmnModel(content.getLocaleValue())).getMainProcess().getFlowElementList())) continue;
            for (FlowElement flowElement : flowElementList) {
                UserTask userTask;
                if (!(flowElement instanceof UserTask) || !(userTask = (UserTask)flowElement).isAddSign() || activities.contains(userTask.getId())) continue;
                activities.add(userTask.getId());
            }
        }
        QFilter qActivities = new QFilter("activityid", "in", activities);
        boolean exist = commandContext.getHistoricActivityInstanceEntityManager().exist(new QFilter[]{qActivities, qInstanceId});
        if (exist) {
            throw new WFException(ResManager.loadKDString((String)"\u52a0\u7b7e\u540e\u6709\u4efb\u52a1\u6d41\u8f6c\uff0c\u4e0d\u80fd\u5220\u9664\u540e\u52a0\u7b7e\u7684\u5185\u5bb9", (String)"TaskAddSignClearByAdminCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
    }

    private void saveOperationLog(CommandContext commandContext) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        operationLog.setType("addSignClear");
        Long userId = RequestContext.get().getCurrUserId();
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(this.procInstId);
        FlowElement flowElement = bpmnModel.getFlowElement(this.activityId);
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas(this.procInstId);
        ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, flowElement.getId() + ".name", flowElement.getName());
        operationLog.setActivityName(nodeName);
        operationLog.setActivityId(this.activityId);
        operationLog.setProcInstId(this.procInstId);
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u7ba1\u7406\u5458\u6e05\u9664\u540e\u52a0\u7b7e", "TaskAddSignClearByAdminCmd_2", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

