/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignValidate;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;

public class TaskAddSignClearCmd
extends TaskAddSignValidate
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private String type;

    public TaskAddSignClearCmd(Long taskId, String type) {
        this.taskId = taskId;
        this.type = type;
    }

    @Override
    public String execute(CommandContext commandContext) {
        this.saveOperationLog(commandContext, this.taskId);
        ExecutionEntity execution = this.getExecutionEntity(commandContext, this.taskId);
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)execution.getProcessInstanceId());
        QFilter qActivityId = new QFilter("activityid", "=", (Object)execution.getActivityId());
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)execution.getCurrentActInstId());
        QFilter qType = new QFilter("type", "=", (Object)this.type);
        QFilter[] qFilters = new QFilter[]{qActivityId, qActInstId, qType, qInstanceId};
        List dynamicResourceEntities = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (dynamicResourceEntities != null && dynamicResourceEntities.isEmpty()) {
            return "noresource";
        }
        return DynProcessProcessorHelper.clearDynProcess(execution, this.type);
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("withdraw");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u6e05\u9664\u52a0\u7b7e", "TaskAddSignClearCmd_0", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

