/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.CirculateTaskCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;

public class TaskCirculationCmd
implements Command<Map>,
Serializable {
    private static Log logger = LogFactory.getLog(TaskCirculationCmd.class);
    private Long taskId;
    private List<Long> userIds;
    private ILocaleString circulationMsg;
    private Long senderUserId;
    private Boolean isAutoCirculate = Boolean.FALSE;
    private static final int MAX_CIRCULATEMSG = 2000;
    private static final String ISSUCCESS = "issuccess";
    private static final String MESSAGE = "message";

    public TaskCirculationCmd(Long taskId, List<Long> userIds, ILocaleString circulationMsg, Long senderUserId) {
        this.taskId = taskId;
        this.userIds = userIds;
        this.circulationMsg = circulationMsg;
        this.senderUserId = senderUserId;
        if (senderUserId == 0L) {
            this.isAutoCirculate = Boolean.TRUE;
        }
    }

    public TaskCirculationCmd(Long taskId, List<Long> userIds, ILocaleString circulationMsg, Long senderUserId, Boolean isAutoCirculate) {
        this(taskId, userIds, circulationMsg, senderUserId);
        this.isAutoCirculate = isAutoCirculate;
    }

    @Override
    public Map execute(CommandContext commandContext) {
        HashMap<String, Object> executeResult = new HashMap<String, Object>();
        try {
            ILocaleString circulationMsgRepair;
            if (this.circulationMsg != null && (circulationMsgRepair = WfUtils.subILocaleString(this.circulationMsg, 2000)) != null) {
                this.circulationMsg = circulationMsgRepair;
            }
            ArrayList<Long> taskIds = new ArrayList<Long>();
            taskIds.add(this.taskId);
            CirculateOperationParam circulateOperationParam = new CirculateOperationParam();
            circulateOperationParam.setCirculateMsg(this.circulationMsg);
            circulateOperationParam.setCirculateUserIds(this.userIds);
            circulateOperationParam.setOperaterId(this.senderUserId);
            circulateOperationParam.setTaskIds(taskIds);
            CirculateTaskCmd circulateTaskCmd = new CirculateTaskCmd(circulateOperationParam, this.isAutoCirculate);
            BatchOperateResult batchOperateResult = circulateTaskCmd.execute(commandContext);
            executeResult.put(ISSUCCESS, batchOperateResult.isSuccess());
            if (!batchOperateResult.isSuccess()) {
                executeResult.put(MESSAGE, batchOperateResult.getValidateMsg());
            }
        }
        catch (Exception e) {
            executeResult.put(ISSUCCESS, false);
            executeResult.put(MESSAGE, e.getMessage());
            logger.error("circulate task[%s] is error[%s]", (Object)this.taskId, (Object)WfUtils.getExceptionStacktrace(e));
        }
        return executeResult;
    }
}

