/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetIdentityLinkEntitiesByTaskIdUserIdTypeCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricAttachmentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.task.TaskCoordinateScene;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import org.apache.commons.lang.StringUtils;

public class TaskCoordinateReplyCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private transient ILocaleString taskCoordinateOpinion;
    private transient String signature;
    private List<HistoricAttachmentEntity> taskCoordinateAttachmentInfos;
    private Long userId = Long.valueOf(RequestContext.get().getUserId());
    private Date currentDate = WfUtils.now();
    private transient ILocaleString userName = WfUtils.findUserName(this.userId);
    private transient Map<String, Object> attch;
    private String richTextMessage = null;
    private static final String ZH_CN = Locale.SIMPLIFIED_CHINESE.toString();
    private static final String ZH_TW = Locale.TRADITIONAL_CHINESE.toString();
    private static final String EN_US = Locale.US.toString();
    private final boolean isApi;

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, List<HistoricAttachmentEntity> taskCoordinateAttachmentInfos) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.taskCoordinateAttachmentInfos = taskCoordinateAttachmentInfos;
        this.isApi = Boolean.TRUE;
    }

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, List<HistoricAttachmentEntity> taskCoordinateAttachmentInfos, String signature) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.taskCoordinateAttachmentInfos = taskCoordinateAttachmentInfos;
        this.signature = signature;
        this.isApi = Boolean.FALSE;
    }

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, Map<String, Object> attch) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.attch = attch;
        this.isApi = Boolean.TRUE;
    }

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, Map<String, Object> attch, String signature) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.attch = attch;
        this.signature = signature;
        this.isApi = Boolean.FALSE;
    }

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, Map<String, Object> attch, Long userId) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.attch = attch;
        this.userId = userId;
        this.isApi = Boolean.TRUE;
    }

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, String richTextMessage, Map<String, Object> attch) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.attch = attch;
        this.richTextMessage = richTextMessage;
        this.isApi = Boolean.TRUE;
    }

    public TaskCoordinateReplyCmd(Long taskId, ILocaleString taskCoordinateOpinion, String richTextMessage, Map<String, Object> attch, String signature) {
        this.taskId = taskId;
        this.taskCoordinateOpinion = taskCoordinateOpinion;
        this.attch = attch;
        this.richTextMessage = richTextMessage;
        this.signature = signature;
        this.isApi = Boolean.FALSE;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q2 = new QFilter("taskid", "=", (Object)this.taskId);
        QFilter q3 = new QFilter("userid", "=", (Object)this.userId);
        boolean isExist = QueryServiceHelper.exists((String)"wf_participant", (QFilter[])new QFilter[]{q1, q2, q3});
        if (!isExist) {
            throw new KDException(new ErrorCode("wf_task_coordinatereply", TaskErrorCodeEnum.USER_NOT_COORDINATE_REPLY.getDesc()), new Object[0]);
        }
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (taskEntity != null) {
            if (this.isApi && WfUtils.isNullObject(this.signature)) {
                this.signature = SignatureUtils.getDefaultSignatureIfAllow(taskEntity, this.userId);
            }
            this.saveData(commandContext, taskEntity);
            this.dealWithMobInfo(commandContext, taskEntity);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("opinion", this.taskCoordinateOpinion);
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeAfterTaskListeners(taskEntity, "afterCoordReply", param);
            HashMap<String, Object> eventMap = new HashMap<String, Object>();
            commandContext.getTaskHelper().gatherAsyncCompensationData(taskEntity);
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                eventMap.put("busKey", taskEntity.getBusinessKey());
                eventMap.put("billNo", taskEntity.getBillNo());
                eventMap.put("entityNum", taskEntity.getEntityNumber());
                eventMap.put("taskCoordinateOpinion", this.taskCoordinateOpinion);
                eventMap.put("userId", this.userId);
                eventMap.put("taskId", this.taskId);
                new EventTriggerCmd(TaskEventTypeEnum.TASK_COORNATE_REPLY_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
            }
        }
        return null;
    }

    private void saveData(CommandContext commandContext, TaskEntity taskEntity) {
        this.deleteLastCoordinateRecored(commandContext);
        List<CommentEntity> commentEntities = this.saveHiCommentAndDeleteParticipant(commandContext, taskEntity);
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.updateTaskHandleLogForTasks(commandContext, this.taskId, RequestContext.get().getClient(), this.userId);
        this.saveHiAttachment(commandContext, taskEntity, commentEntities);
        this.updateHiParticipant(commandContext);
        commandContext.getRuleTaskRelationEntityManager().deleteEntitiesByTaskIdAndTypeAndUserId(this.taskId, "coordinate", String.valueOf(this.userId));
        this.dispatchTaskCoordinateListener(taskEntity);
    }

    private void dispatchTaskCoordinateListener(TaskEntity taskEntity) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            ArrayList<Long> coordinateUserIds = new ArrayList<Long>();
            coordinateUserIds.add(this.userId);
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createCoordinateTaskEvent(ActivitiEventType.TASK_COORDINATE, taskEntity, null, coordinateUserIds, this.taskCoordinateOpinion, TaskCoordinateScene.TASKCOORDINATEREPLY));
        }
    }

    private void deleteLastCoordinateRecored(CommandContext commandContext) {
        QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q2 = new QFilter("taskid", "=", (Object)this.taskId);
        QFilter q3 = new QFilter("userid", "=", (Object)this.userId);
        QFilter q4 = new QFilter("endtime", "is not null", (Object)"");
        commandContext.getCommentEntityManager().deleteByFilters(new QFilter[]{q2, q3, q1});
        commandContext.getHistoricAttachmentEntityManager().deleteByFilters(new QFilter[]{q2, q3});
        commandContext.getHistoricIdentityLinkEntityManager().deleteByFilters(new QFilter[]{q2, q3, q1, q4});
    }

    private List<CommentEntity> saveHiCommentAndDeleteParticipant(CommandContext commandContext, TaskEntity taskEntity) {
        ArrayList<CommentEntity> commentEntities = null;
        Object identityLinkEntities = new GetIdentityLinkEntitiesByTaskIdUserIdTypeCmd(this.taskId, this.userId, "coordinate").execute(Context.getCommandContext());
        if (null != identityLinkEntities && !identityLinkEntities.isEmpty()) {
            commentEntities = new ArrayList<CommentEntity>(identityLinkEntities.size());
            CommentEntity entity = null;
            String multiKey = BpmnModelUtil.getActivityNameMultiKey(taskEntity.getTaskDefinitionKey());
            ILocaleString activityName = BpmnModelUtil.getMultiLangFieldValue(taskEntity.getProcessInstanceId(), multiKey, String.valueOf(taskEntity.getName()));
            CommentEntityManager entityManager = commandContext.getCommentEntityManager();
            IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
            HistoricTaskInstanceEntityManager hitaskEntityManager = commandContext.getHistoricTaskInstanceEntityManager();
            HistoricTaskInstanceEntity hitask = (HistoricTaskInstanceEntity)hitaskEntityManager.findById(taskEntity.getId());
            Iterator iterator = identityLinkEntities.iterator();
            while (iterator.hasNext()) {
                IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)iterator.next();
                entity = (CommentEntity)entityManager.create();
                entity.setType("coordinate");
                entity.setTime(this.currentDate);
                entity.setUserId(this.userId);
                entity.setTaskId(this.taskId);
                entity.setProcessInstanceId(taskEntity.getProcessInstanceId());
                entity.setProcessType(taskEntity.getProcessType());
                entity.setActivityId(taskEntity.getTaskDefinitionKey());
                entity.setGroupId(identityLinkEntity.getParenttaskid() != null ? identityLinkEntity.getParenttaskid().toString() : this.taskId.toString());
                entity.setBusinessKey(taskEntity.getBusinessKey());
                entity.setEntityNumber(taskEntity.getEntityNumber());
                entity.setBillType(taskEntity.getBillType());
                entity.setIsPublic(identityLinkEntity.getIsPublic());
                entity.setMessage(this.taskCoordinateOpinion);
                if (WfUtils.isNotEmpty(this.signature)) {
                    entity.setSignature(this.signature);
                }
                if (WfUtils.isNotEmpty(this.richTextMessage)) {
                    entity.setRichTextMessage(this.richTextMessage);
                }
                entity.setCoordInviteOpinion(identityLinkEntity.getTransferOpinion());
                if (this.userName != null && !WfUtils.isEmpty(this.userName.toString())) {
                    entity.setAssignee(this.userName);
                }
                ILocaleString userNameFormate = identityLinkEntity.getUserNameFormatter();
                entity.setUserNameFormatter(userNameFormate);
                entity.setOwnerId(identityLinkEntity.getOwnerId());
                entity.setActivityName(activityName);
                entity.setStep(commandContext.getCommentEntityManager().calculateStep(taskEntity.getProcessInstanceId()));
                if (WfUtils.isNotEmpty(identityLinkEntity.getCurrentSubject())) {
                    entity.setCurrentSubject(identityLinkEntity.getCurrentSubject());
                }
                entity.setTerminalWay(RequestContext.get().getClient());
                entity.setSource(taskEntity.getSource());
                entity.setSourceName(taskEntity.getSourceName());
                entity.setBillNo(taskEntity.getBillNo());
                entity.setEntityName(taskEntity.getEntityName());
                entity.setSenderNameFormat(WfMultiLangUtils.subString(taskEntity.getSenderNameFormat(), 0, 255));
                entity.setStarterId(taskEntity.getStarterId());
                entity.setProcessingPage(taskEntity.getProcessingPage());
                entity.setProcessingMobilePage(taskEntity.getProcessingMobilePage());
                entity.setHandleState("handled");
                entity.setCategory(StringUtils.substring((String)taskEntity.getCategory(), (int)0, (int)50));
                entity.setSenderName(WfMultiLangUtils.subString(taskEntity.getSenderName(), 0, 400));
                entity.setCreateDate(taskEntity.getCreateDate());
                entity.setExecutionType(taskEntity.getExecutionType());
                entity.setDisplay(taskEntity.isDisplay());
                entity.setEndType(taskEntity.getEndType());
                entity.setBillType(taskEntity.getBillType());
                entity.setStartName(WfMultiLangUtils.subString(taskEntity.getStartName(), 0, 255));
                entity.setStartNameFormat(WfMultiLangUtils.subString(taskEntity.getStartNameFormat(), 0, 255));
                entity.setBusinessDate(taskEntity.getBusinessDate());
                entity.setBusinessFormat(taskEntity.getBusinessFormat());
                entity.setBusinessNumber(taskEntity.getBusinessNumber());
                entity.setBusinessStr1(StringUtils.substring((String)taskEntity.getBusinessStr1(), (int)0, (int)255));
                entity.setBusinessStr2(StringUtils.substring((String)taskEntity.getBusinessStr2(), (int)0, (int)255));
                entity.setBusinessDate2(taskEntity.getBusinessDate2());
                entity.setBusinessNumber2(taskEntity.getBusinessNumber2());
                entity.setBusinessMulStr1(WfUtils.subILocaleString(taskEntity.getBusinessMulStr1(), 255));
                entity.setBusinessMulStr2(WfUtils.subILocaleString(taskEntity.getBusinessMulStr2(), 255));
                TaskExtendFieldUtil.setExtendTaskBusinessField(entity.getDynamicObject(), taskEntity.getDynamicObject());
                entity.setPresentAssignee((ILocaleString)(hitask != null ? hitask.getPresentAssignee() : new LocaleString()));
                entityManager.insert(entity);
                ILocaleString note = WfUtils.getPromptWordLocaleString("\u534f\u529e\u56de\u590d", "TaskCoordinateReplyCmd_2", "bos-wf-engine");
                WfOperationLogUtil.recordOperationLogFromComment(commandContext, entity, note, null);
                commentEntities.add(entity);
                identityLinkEntityManager.delete(identityLinkEntity);
            }
        }
        return commentEntities;
    }

    private void saveHiAttachment(CommandContext commandContext, TaskEntity taskEntity, List<CommentEntity> commentEntities) {
        if (null != commentEntities && !commentEntities.isEmpty() && this.isAttachmentInfosOrAttchEmpty()) {
            HistoricAttachmentEntityManager entityManager = commandContext.getHistoricAttachmentEntityManager();
            HistoricAttachmentEntity entity = null;
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            for (CommentEntity commentEntity : commentEntities) {
                if (WfUtils.isNotEmptyForCollection(this.taskCoordinateAttachmentInfos)) {
                    for (HistoricAttachmentEntity attachmentInfo : this.taskCoordinateAttachmentInfos) {
                        entity = (HistoricAttachmentEntity)entityManager.create();
                        entity.setUserId(this.userId);
                        entity.setName(attachmentInfo.getName());
                        entity.setTaskId(taskEntity.getId());
                        entity.setProcessInstanceId(taskEntity.getProcessInstanceId());
                        entity.setUrlId(attachmentInfo.getUrlId());
                        entity.setContentId(commentEntity.getId());
                        entity.setType("coordinate");
                        entityManager.insert(entity);
                    }
                    continue;
                }
                if (!WfUtils.isNotEmptyForMap(this.attch)) continue;
                taskHelper.addHiAttachment(commentEntity, this.attch);
            }
        }
    }

    private boolean isAttachmentInfosOrAttchEmpty() {
        return null != this.taskCoordinateAttachmentInfos && !this.taskCoordinateAttachmentInfos.isEmpty() || WfUtils.isNotEmptyForMap(this.attch);
    }

    private void updateHiParticipant(CommandContext commandContext) {
        HistoricIdentityLinkEntityManager manager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> entities = manager.findHistoricIdentityLinksByTaskUserGroupAndType(this.taskId, this.userId, "coordinate");
        for (HistoricIdentityLinkEntity entity : entities) {
            entity.setEndTime(this.currentDate);
            entity.setDurationInMillis(this.currentDate.getTime() - entity.getCreateDate().getTime());
            manager.update(entity);
        }
    }

    private void dealWithMobInfo(CommandContext commandContext, TaskEntity taskEntity) {
        this.sendTextMessage(commandContext, taskEntity.getBillNo(), taskEntity.getProcessInstanceId(), taskEntity.getTaskDefinitionKey());
        this.deleteToDo(commandContext);
    }

    private void sendTextMessage(CommandContext commandContext, String billNo, Long proInstId, String actId) {
        if (!WfConfigurationUtil.needCoordinateReplyMsg()) {
            return;
        }
        List<Long> ownerIds = this.getOwnerIds(commandContext);
        if (!(ownerIds.isEmpty() || ownerIds.size() == 1 && ownerIds.get(0) == 1L)) {
            DynamicObject taskObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.taskId, (String)"wf_task");
            if (taskObject == null) {
                throw new WFTaskException(WFErrorCode.taskNotExist());
            }
            ILocaleString billName = (ILocaleString)taskObject.get("entityname");
            ILocaleString titleValue = WfUtils.getPromptWordLocaleString("%1$s\u5b8c\u6210\uff1a%2$s", "TaskCoordinateReplyCmd_6", "bos-wf-engine");
            ILocaleString title = WfMultiLangUtils.getMultiLangValue(titleValue, WfConfigurationUtil.getCoordinateNameFromConfig(), billName);
            ILocaleString localeValue = WfUtils.getPromptWordLocaleString("\u60a8\u9080\u8bf7%1$s\u7684\u5355\u636e\uff1a%2$s\uff0c\u5df2\u88ab%3$s%4$s\u5b8c\u6210\u3002", "TaskCoordinateReplyCmd_4", "bos-wf-engine");
            MessageContext ctx = MessageServiceUtil.buildMessageContext(this.taskId);
            MessageInfo info = MessageServiceUtil.buildMessageInfo(proInstId, actId);
            info.setMessageTitle(title);
            info.setMessageContent(WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{localeValue, WfConfigurationUtil.getCoordinateNameFromConfig(), new LocaleString(billNo), this.userName, WfConfigurationUtil.getCoordinateNameFromConfig()}));
            info.setUserIds(ownerIds);
            String contentUrl = this.getContentUrl(commandContext, this.taskId);
            info.setContentUrl(contentUrl);
            info.setMobContentUrl(contentUrl);
            info.setBizDataId(this.taskId);
            info.setTplScene(MessageTypeEnum.COORDINATEREPLY.getNumber());
            LocaleString subject = this.getCoordinateSubject(commandContext);
            if (WfUtils.isNotEmpty((ILocaleString)subject)) {
                info.putParam("parsesubject", SerializationUtils.toJsonString((Object)subject));
            }
            commandContext.getMessageService().sendMessage(ctx, info);
        }
    }

    private LocaleString getCoordinateSubject(CommandContext commandContext) {
        List<IdentityLinkEntity> entities = commandContext.getIdentityLinkEntityManager().findIdentityLinkByTaskUserAndType(this.taskId, this.userId, "coordinate");
        if (entities != null && !entities.isEmpty()) {
            return WfMultiLangUtils.changeILocaleStringToLocaleString(entities.get(0).getCurrentSubject());
        }
        return null;
    }

    private String getContentUrl(CommandContext commandContext, Long taskId) {
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        String formId = task.getProcessingPage();
        String mobileFormId = task.getProcessingMobilePage();
        String pCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getPCCaptionLocale(task));
        String mCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getMBCaptionLocale(task));
        Long activityId = commandContext.getHistoricActivityInstanceEntityManager().findActivityIdByTask(taskId);
        return MessageServiceUtil.buildWebPageUrl(formId, mobileFormId, activityId, task.getBusinessKey(), Boolean.FALSE, pCaption, mCaption);
    }

    private List<Long> getOwnerIds(CommandContext commandContext) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        List<IdentityLinkEntity> entities = commandContext.getIdentityLinkEntityManager().findIdentityLinkByTaskUserAndType(this.taskId, this.userId, "coordinate");
        if (null != entities && !entities.isEmpty()) {
            for (IdentityLinkEntity entity : entities) {
                userIds.add(entity.getOwnerId());
            }
        }
        return userIds;
    }

    private void deleteToDo(CommandContext commandContext) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(this.userId);
        commandContext.getMessageService().dealCoordinateRecordToDo(this.taskId, userIds);
    }
}

