/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetIdentityLinkEntitiesByTaskIdUserIdTypeCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.task.TaskCoordinateScene;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;

public class TaskCoordinateRequestCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PARENTTASKID = "parenttaskid";
    private Long taskId;
    private List<Long> userIds;
    private transient ILocaleString coordinateMsg;
    private Long ownerId;
    private Boolean isTaskCoodinate;
    private Long origAutoCoorUserId;
    private Boolean isPublic;
    private Date currentDate = WfUtils.now();
    private Boolean isAuto = Boolean.FALSE;
    private transient Map<String, Object> dynInfo;
    private Boolean worksBatchTransfer = Boolean.FALSE;
    public static final String COORDINATETASK = "coordinateTask";

    public TaskCoordinateRequestCmd(Long taskId, Boolean isTaskCoodinate, List<Long> userIds, ILocaleString coordinateMsg, Long ownerId, Boolean isPublic, Boolean isAuto) {
        this(taskId, isTaskCoodinate, userIds, coordinateMsg, ownerId, isPublic);
        this.isAuto = isAuto;
    }

    public TaskCoordinateRequestCmd(Long taskId, Boolean isTaskCoodinate, Long origAutoCoorUserId, List<Long> userIds, ILocaleString coordinateMsg, Long ownerId, Boolean isPublic, Boolean isAuto, Boolean worksBatchTransfer) {
        this(taskId, isTaskCoodinate, userIds, coordinateMsg, ownerId, isPublic);
        this.origAutoCoorUserId = origAutoCoorUserId;
        this.isAuto = isAuto;
        this.worksBatchTransfer = worksBatchTransfer;
    }

    public TaskCoordinateRequestCmd(Long taskId, Boolean isTaskCoodinate, List<Long> userIds, ILocaleString coordinateMsg, Long ownerId, Boolean isPublic) {
        this.taskId = taskId;
        this.userIds = userIds;
        this.coordinateMsg = coordinateMsg;
        this.ownerId = ownerId;
        this.isTaskCoodinate = isTaskCoodinate;
        this.isPublic = isPublic;
    }

    public TaskCoordinateRequestCmd(Long taskId, Boolean isTaskCoodinate, List<Long> userIds, ILocaleString coordinateMsg, Long ownerId, Boolean isPublic, Map<String, Object> dynInfo) {
        this(taskId, isTaskCoodinate, userIds, coordinateMsg, ownerId, isPublic);
        this.dynInfo = dynInfo;
    }

    public TaskCoordinateRequestCmd(Long taskId, Boolean isTaskCoodinate, Boolean worksBatchTransfer, List<Long> userIds, ILocaleString coordinateMsg, Long ownerId, Boolean isPublic) {
        this(taskId, isTaskCoodinate, userIds, coordinateMsg, ownerId, isPublic);
        this.worksBatchTransfer = worksBatchTransfer;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (!this.userIds.isEmpty()) {
            Object identityLinkEntityManager;
            Object identityLinkEntities;
            Long taskOwnerId = null;
            this.checkCoordinateUser();
            TaskEntity task = null;
            if (WfUtils.isNotEmpty(this.taskId)) {
                task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            }
            if (!this.isTaskCoodinate.booleanValue() && !this.isAuto.booleanValue()) {
                new ResumeDelegateTasksCmd(this.taskId, COORDINATETASK).execute(commandContext);
            }
            if (this.isTaskCoodinate.booleanValue()) {
                Long userId = this.ownerId;
                if (this.isAuto.booleanValue()) {
                    userId = this.origAutoCoorUserId;
                }
                if ((identityLinkEntities = new GetIdentityLinkEntitiesByTaskIdUserIdTypeCmd(this.taskId, userId, "coordinate").execute(commandContext)) != null && !identityLinkEntities.isEmpty()) {
                    identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
                    ArrayList<Long> deleteUserIds = new ArrayList<Long>(identityLinkEntities.size());
                    Iterator iterator = identityLinkEntities.iterator();
                    while (iterator.hasNext()) {
                        IdentityLinkEntity identityLinkEntitie = (IdentityLinkEntity)iterator.next();
                        this.isPublic = identityLinkEntitie.getIsPublic();
                        taskOwnerId = identityLinkEntitie.getOwnerId();
                        identityLinkEntityManager.delete(identityLinkEntitie.getId());
                        deleteUserIds.add(identityLinkEntitie.getUserId());
                    }
                    ArrayList<Long> coordinateUserIds = new ArrayList<Long>();
                    coordinateUserIds.add(userId);
                    this.dispatchTaskCoordinateLisnter(TaskCoordinateScene.TASKCOORDINATETRANFER, coordinateUserIds);
                }
            } else if (!this.isAuto.booleanValue()) {
                HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager;
                List<HistoricIdentityLinkEntity> historicIdentityLinkEntitys;
                taskOwnerId = this.ownerId;
                IdentityLinkEntityManager identityLinkEntityManager2 = commandContext.getIdentityLinkEntityManager();
                identityLinkEntities = identityLinkEntityManager2.findIdentityLinksByTaskId(this.taskId);
                this.checkIsParticipantOperate((List<IdentityLinkEntity>)identityLinkEntities);
                this.dispatchTaskCoordinateLisnter(TaskCoordinateScene.TASKCOORDINATEREQUEST, null);
                if (identityLinkEntities != null && !identityLinkEntities.isEmpty()) {
                    Object identityLinkEntitie;
                    identityLinkEntityManager = identityLinkEntities.iterator();
                    while (identityLinkEntityManager.hasNext()) {
                        identityLinkEntitie = (IdentityLinkEntity)identityLinkEntityManager.next();
                        if (!WfUtils.isNotEmpty(identityLinkEntitie.getDelegateId()) || !this.ownerId.equals(identityLinkEntitie.getUserId())) continue;
                        taskOwnerId = identityLinkEntitie.getOwnerId();
                        break;
                    }
                    ArrayList<Long> deleteUserIds = new ArrayList<Long>();
                    identityLinkEntitie = identityLinkEntities.iterator();
                    while (identityLinkEntitie.hasNext()) {
                        IdentityLinkEntity identityLinkEntitie2 = (IdentityLinkEntity)identityLinkEntitie.next();
                        if (this.ownerId.equals(identityLinkEntitie2.getUserId()) || taskOwnerId.equals(identityLinkEntitie2.getUserId()) || !"participant".equals(identityLinkEntitie2.getType())) continue;
                        identityLinkEntityManager2.delete(identityLinkEntitie2.getId());
                        deleteUserIds.add(identityLinkEntitie2.getUserId());
                    }
                    if (!deleteUserIds.isEmpty()) {
                        commandContext.getMessageService().deleteToDo(this.taskId, deleteUserIds);
                    }
                }
                if ((historicIdentityLinkEntitys = (historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager()).findHistoricIdentityLinksByTaskId(this.taskId)) != null && !historicIdentityLinkEntitys.isEmpty()) {
                    for (HistoricIdentityLinkEntity historicIdentityLinkEntity : historicIdentityLinkEntitys) {
                        if (this.ownerId.equals(historicIdentityLinkEntity.getUserId()) || taskOwnerId.equals(historicIdentityLinkEntity.getUserId()) || !"participant".equals(historicIdentityLinkEntity.getType()) || historicIdentityLinkEntity.getEndTime() != null) continue;
                        historicIdentityLinkEntityManager.delete(historicIdentityLinkEntity.getId());
                    }
                }
                TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
                ArrayList<Long> taskIdList = new ArrayList<Long>(1);
                taskIdList.add(this.taskId);
                List<TaskEntity> taskEntityList = taskEntityManager.findByTaskIds((List<Long>)taskIdList);
                if (taskEntityList != null && !taskEntityList.isEmpty()) {
                    TaskEntity taskEntity = taskEntityList.get(0);
                    List identityLinks = task.getIdentityLinks().stream().filter(e -> "participant".equals(e.getType())).collect(Collectors.toList());
                    ArrayList<ILocaleString> identityLinkNames = new ArrayList<ILocaleString>(identityLinks.size());
                    ArrayList<ILocaleString> identityLinkNameFormats = new ArrayList<ILocaleString>(identityLinks.size());
                    ArrayList<ILocaleString> trusteeIdentityLinkNames = new ArrayList<ILocaleString>(identityLinks.size());
                    ArrayList<ILocaleString> trusteeIdentityLinkFormats = new ArrayList<ILocaleString>(identityLinks.size());
                    for (IdentityLinkEntity identityLink : identityLinks) {
                        if (identityLink.isDeleted()) continue;
                        identityLinkNames.add(identityLink.getUserName());
                        identityLinkNameFormats.add(identityLink.getUserNameFormatter());
                        if (!WfUtils.isNotEmpty(identityLink.getDelegateId()) || !taskOwnerId.equals(identityLink.getOwnerId())) continue;
                        trusteeIdentityLinkNames.add(identityLink.getUserName());
                        trusteeIdentityLinkFormats.add(identityLink.getUserNameFormatter());
                    }
                    taskEntity.setParticipantName(WfMultiLangUtils.getFormatMergeValue(identityLinkNames));
                    if (WfConfigurationUtil.isDisplaySetting()) {
                        taskEntity.setParticipantName(WfMultiLangUtils.getFormatMergeValue(identityLinkNameFormats));
                    }
                    taskEntityManager.update(taskEntity);
                    List<IdentityLinkEntity> mandatorIdentityLinkEntitys = identityLinkEntityManager2.findIdentityLinkByTaskUserAndType(task.getId(), taskOwnerId, "participant");
                    if (mandatorIdentityLinkEntitys != null && !mandatorIdentityLinkEntitys.isEmpty()) {
                        IdentityLinkEntity mandatorIdentityLinkEntity = mandatorIdentityLinkEntitys.get(0);
                        mandatorIdentityLinkEntity.setTrustName(WfMultiLangUtils.getFormatMergeValue(trusteeIdentityLinkNames));
                        mandatorIdentityLinkEntity.setTrustNameFormat(WfMultiLangUtils.getFormatMergeValue(trusteeIdentityLinkFormats));
                        identityLinkEntityManager2.update(mandatorIdentityLinkEntity);
                        HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)historicIdentityLinkEntityManager.findById(mandatorIdentityLinkEntity.getId());
                        historicIdentityLinkEntity.setTrustName(WfMultiLangUtils.getFormatMergeValue(trusteeIdentityLinkNames));
                        historicIdentityLinkEntity.setTrustNameFormat(WfMultiLangUtils.getFormatMergeValue(trusteeIdentityLinkFormats));
                        historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
                    }
                    if ("YunzhijiaTask".equals(task.getCategory())) {
                        LocaleString wholeUerName = new LocaleString();
                        LocaleString wholeUerNameFormat = new LocaleString();
                        ILocaleString delegate = WFMultiLangConstants.getDelegateLocaleString();
                        if (mandatorIdentityLinkEntitys != null && !mandatorIdentityLinkEntitys.isEmpty()) {
                            IdentityLinkEntity mandatorIdentityLinkEntity = mandatorIdentityLinkEntitys.get(0);
                            ILocaleString trustName = mandatorIdentityLinkEntity.getTrustName();
                            ILocaleString trustNameFormat = mandatorIdentityLinkEntity.getTrustNameFormat();
                            ILocaleString userName = mandatorIdentityLinkEntity.getUserName();
                            ILocaleString userNameFormatter = mandatorIdentityLinkEntity.getUserNameFormatter();
                            if (WfUtils.isNotEmpty(trustName) && WfUtils.isNotEmpty(trustNameFormat)) {
                                for (Lang supportLang : WfMultiLangUtils.getSupportLangs()) {
                                    wholeUerName.put((Object)supportLang.toString(), (Object)String.format((String)delegate.get((Object)supportLang.toString()), userName.get((Object)supportLang.toString()), trustName.get((Object)supportLang.toString())));
                                    wholeUerNameFormat.put((Object)supportLang.toString(), (Object)String.format((String)delegate.get((Object)supportLang.toString()), userNameFormatter.get((Object)supportLang.toString()), trustNameFormat.get((Object)supportLang.toString())));
                                }
                            } else {
                                wholeUerName = mandatorIdentityLinkEntity.getUserName();
                                wholeUerNameFormat = mandatorIdentityLinkEntity.getUserNameFormatter();
                            }
                        }
                        QFilter qFilter1 = new QFilter(PARENTTASKID, "=", (Object)task.getParentTaskId());
                        QFilter qFilter2 = new QFilter("userid", "!=", (Object)taskOwnerId);
                        QFilter qFilter3 = new QFilter("type", "=", (Object)"participant");
                        QFilter qFilter4 = new QFilter("delegateid", "=", (Object)0L);
                        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4};
                        List parentTaskParticipants = identityLinkEntityManager2.findByQueryFilters(qFilters);
                        ArrayList<ILocaleString> parentTaskParticipantName = new ArrayList<ILocaleString>(10);
                        ArrayList<ILocaleString> parentTaskParticipantNameFormat = new ArrayList<ILocaleString>(10);
                        for (IdentityLinkEntity parentTaskParticipant : parentTaskParticipants) {
                            ILocaleString userName = parentTaskParticipant.getUserName();
                            ILocaleString userNameFormatter = parentTaskParticipant.getUserNameFormatter();
                            if (WfUtils.isNotEmpty(parentTaskParticipant.getTrustName())) {
                                LocaleString name = new LocaleString();
                                for (Lang supportLang : WfMultiLangUtils.getSupportLangs()) {
                                    name.put((Object)supportLang.toString(), (Object)String.format((String)delegate.get((Object)supportLang.toString()), userName.get((Object)supportLang.toString()), parentTaskParticipant.getTrustName().get((Object)supportLang.toString())));
                                }
                                parentTaskParticipantName.add((ILocaleString)name);
                            } else {
                                parentTaskParticipantName.add(parentTaskParticipant.getUserName());
                            }
                            if (WfUtils.isNotEmpty(parentTaskParticipant.getTrustNameFormat())) {
                                LocaleString nameFormat = new LocaleString();
                                for (Lang supportLang : WfMultiLangUtils.getSupportLangs()) {
                                    nameFormat.put((Object)supportLang.toString(), (Object)String.format((String)delegate.get((Object)supportLang.toString()), userNameFormatter.get((Object)supportLang.toString()), parentTaskParticipant.getTrustNameFormat().get((Object)supportLang.toString())));
                                }
                                parentTaskParticipantNameFormat.add((ILocaleString)nameFormat);
                                continue;
                            }
                            parentTaskParticipantNameFormat.add(userNameFormatter);
                        }
                        parentTaskParticipantName.add((ILocaleString)wholeUerName);
                        parentTaskParticipantNameFormat.add((ILocaleString)wholeUerNameFormat);
                        TaskEntity parentTask = task.getParentTaskInstance();
                        parentTask.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)WfMultiLangUtils.getFormatMergeValue(parentTaskParticipantName)));
                        parentTask.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)WfMultiLangUtils.getFormatMergeValue(parentTaskParticipantNameFormat)));
                    }
                }
            } else if (this.isAuto.booleanValue()) {
                taskOwnerId = this.ownerId;
                this.dispatchTaskCoordinateLisnter(TaskCoordinateScene.TASKCOORDINATEREQUEST, null);
            }
            Integer priority = 0;
            if (WfUtils.isNotEmptyForMap(this.dynInfo)) {
                Object level = this.dynInfo.get("priority");
                priority = TaskHelper.getPriorityValueByTaskLevel(level, this.taskId);
            }
            LocaleString coordinateSubject = this.calcCoordinateSubject();
            TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            Map<Long, ILocaleString> assigneesFormat = ParticipantHelper.getParticipantDisplayInfo(taskEntity, this.userIds);
            ILocaleString ownerFormat = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.ownerId)).get(this.ownerId);
            for (Long userId : this.userIds) {
                TaskHandleLogEntity entity = this.getTaskHandleLogEntity(taskEntity, commandContext, userId, this.ownerId, coordinateSubject, assigneesFormat, ownerFormat);
                this.saveTaskCoordinateInfo(commandContext, entity, this.ownerId, priority, (ILocaleString)coordinateSubject);
            }
            if (WfUtils.isNotEmpty((ILocaleString)coordinateSubject) && WfUtils.isNotEmpty(coordinateSubject.getLocaleValue())) {
                coordinateSubject.setItem("GLang", (Object)coordinateSubject.getLocaleValue());
            }
            commandContext.getMessageService().createCoordinateToDo(this.taskId, this.userIds, coordinateSubject);
            this.sendTextMessage(commandContext, this.taskId, this.userIds, this.ownerId, (ILocaleString)coordinateSubject);
            if (this.isTaskCoodinate.booleanValue()) {
                TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
                taskHelper.gatherAsyncCompensationData(task);
                ArrayList<Long> ownerIds = new ArrayList<Long>(1);
                Long userId = RequestContext.get().getCurrUserId();
                if (this.isAuto.booleanValue()) {
                    userId = this.origAutoCoorUserId;
                }
                ownerIds.add(userId);
                commandContext.getMessageService().deleteToDo(this.taskId, ownerIds, false);
                HistoricIdentityLinkEntityManager manager = commandContext.getHistoricIdentityLinkEntityManager();
                List<HistoricIdentityLinkEntity> entities = manager.findHistoricIdentityLinksByTaskUserGroupAndType(this.taskId, userId, "coordinate");
                for (HistoricIdentityLinkEntity entity : entities) {
                    entity.setEndTime(this.currentDate);
                    entity.setDurationInMillis(this.currentDate.getTime() - entity.getCreateDate().getTime());
                    entity.setPriority(priority);
                    manager.update(entity);
                }
            }
            if (task != null) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("opinion", this.coordinateMsg);
                param.put("targetUserId", this.userIds);
                param.put("ownerId", this.ownerId);
                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeAfterTaskListeners(task, "afterCoordReq", param);
                if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                    HashMap<String, Object> eventMap = new HashMap<String, Object>();
                    eventMap.put("busKey", task.getBusinessKey());
                    eventMap.put("billNo", task.getBillNo());
                    eventMap.put("entityNum", task.getEntityNumber());
                    eventMap.put("ownerId", this.ownerId);
                    eventMap.put("userIds", this.userIds);
                    eventMap.put("taskId", this.taskId);
                    eventMap.put("coordinateMsg", this.coordinateMsg);
                    new EventTriggerCmd(TaskEventTypeEnum.TASK_COORDINATE_REQ_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
                }
            }
            this.updateHiTaskPresentAssignee();
            if (this.isTaskCoodinate.booleanValue()) {
                return ResManager.loadKDString((String)"\u534f\u529e\u8f6c\u4ea4\u6210\u529f\u3002", (String)"TaskCoordinateRequestCmd_13", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u534f\u529e\u6210\u529f\u3002", (String)"TaskCoordinateRequestCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        throw new WFTaskException(WFErrorCode.participantExistForCoordinateError());
    }

    private void checkIsParticipantOperate(List<IdentityLinkEntity> identityLinks) {
        if (CollectionUtil.isNotEmpty(identityLinks)) {
            Long currUserId = RequestContext.get().getCurrUserId();
            if (!WfUtils.isEmpty(this.ownerId)) {
                currUserId = this.ownerId;
            }
            boolean exist = false;
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (!currUserId.equals(identityLink.getUserId()) || !"participant".equals(identityLink.getType())) continue;
                exist = true;
            }
            if (!exist) {
                throw new WFTaskException(WFErrorCode.coordinateRequestNotContainsParticipantError());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocaleString calcCoordinateSubject() {
        LocaleString coordinateSubject = new LocaleString();
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.taskId);
        if (task != null) {
            try {
                task.setTransientVariable("taskcoordinateuserid", this.userIds.toString());
                task.setTransientVariable("taskcoordinatemsg", this.coordinateMsg);
                task.setTransientVariable("taskscene", "coordinate");
                ILocaleString taskSubject = TaskBehaviorUtil.getTaskSubject((UserTask)ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey()), task, task.getBusinessKey(), task.getEntityNumber());
                if (WfUtils.isNotEmpty(taskSubject)) {
                    for (Map.Entry entry : taskSubject.entrySet()) {
                        coordinateSubject.put((String)entry.getKey(), entry.getValue());
                    }
                }
            }
            finally {
                task.removeTransientVariable("taskcoordinateuserid");
                task.removeTransientVariable("taskcoordinatemsg");
                task.removeTransientVariable("taskscene");
            }
        }
        return coordinateSubject;
    }

    private void updateHiTaskPresentAssignee() {
        if (WfUtils.isNotEmpty(this.taskId)) {
            TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.taskId);
            BPMNUtil.updateHitaskInstPresentAssignee(task.getExecution(), null);
        }
    }

    private void dispatchTaskCoordinateLisnter(TaskCoordinateScene scene, List<Long> coordinateUserIds) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            TaskEntity taskEntity = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(this.taskId);
            if (scene == TaskCoordinateScene.TASKCOORDINATEREQUEST) {
                ArrayList<Long> coordinateInitiatorIds = new ArrayList<Long>();
                if (!this.isAuto.booleanValue()) {
                    coordinateInitiatorIds.add(this.ownerId);
                }
                eventDispatcher.dispatchEvent(ActivitiEventBuilder.createCoordinateTaskEvent(ActivitiEventType.TASK_COORDINATE, taskEntity, coordinateInitiatorIds, this.userIds, null, scene));
            } else if (scene == TaskCoordinateScene.TASKCOORDINATETRANFER) {
                if (this.worksBatchTransfer.booleanValue()) {
                    taskEntity.setTransientVariable("isWorksBatchTransfer", Boolean.TRUE);
                }
                eventDispatcher.dispatchEvent(ActivitiEventBuilder.createCoordinateTransferTaskEvent(ActivitiEventType.TASK_COORDINATE, taskEntity, coordinateUserIds, this.userIds, null, scene));
                taskEntity.removeTransientVariable("isWorksBatchTransfer");
            }
        }
    }

    private void sendTextMessage(CommandContext commandContext, Long taskId, List<Long> userIds, Long ownerId, ILocaleString coordinateSubject) {
        if (!WfConfigurationUtil.needCoordinateReqMsg()) {
            return;
        }
        if (!userIds.isEmpty()) {
            HistoricTaskInstanceEntity taskObject;
            ILocaleString currentUserName = WfUtils.findUserName(ownerId);
            if (ownerId == WfConstanst.ADMIN) {
                currentUserName = WFMultiLangConstants.getSystem();
            }
            if ((taskObject = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId)) == null) {
                throw new WFTaskException(WFErrorCode.taskNotExist());
            }
            ILocaleString billName = taskObject.getEntityName();
            ILocaleString localeValue = WfUtils.getPromptWordLocaleString("\u534f\u529e\uff1a%s", "TaskCoordinateRequestCmd_6", "bos-wf-engine");
            ILocaleString title = WfMultiLangUtils.getMultiLangValue(localeValue, billName);
            ILocaleString contentValue = WfUtils.getPromptWordLocaleString("\u9080\u8bf7\u4eba\uff1a%1$s<br>\u610f\u89c1\uff1a%2$s", "TaskCoordinateRequestCmd_8", "bos-wf-engine");
            ILocaleString content = WfMultiLangUtils.getMultiLangValue(contentValue, currentUserName, this.coordinateMsg);
            MessageContext ctx = MessageServiceUtil.buildMessageContext(taskId);
            MessageInfo info = new MessageInfo();
            info.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("message"));
            info.setMessageTitle(title);
            info.setMessageContent(content);
            info.setUserIds(userIds);
            String contentUrl = this.getContentUrl(commandContext, taskId);
            info.setContentUrl(contentUrl);
            info.setMobContentUrl(contentUrl);
            info.setTplScene(MessageTypeEnum.COORDINATE.getNumber());
            if (WfUtils.isNotEmpty(coordinateSubject)) {
                info.putParam("parsesubject", SerializationUtils.toJsonString((Object)coordinateSubject));
            }
            commandContext.getMessageService().sendMessage(ctx, info);
        }
    }

    private String getContentUrl(CommandContext commandContext, Long taskId) {
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        String formId = task.getProcessingPage();
        String mobileFormId = task.getProcessingMobilePage();
        String pCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getPCCaptionLocale(task));
        String mCaption = SerializationUtils.toJsonString((Object)MessageServiceUtil.getMBCaptionLocale(task));
        Long activityId = commandContext.getHistoricActivityInstanceEntityManager().findActivityIdByTask(taskId);
        return MessageServiceUtil.buildWebPageUrl(formId, mobileFormId, activityId, task.getBusinessKey(), Boolean.FALSE, pCaption, mCaption);
    }

    private TaskHandleLogEntity getTaskHandleLogEntity(TaskEntity taskEntity, CommandContext commandContext, Long assigneeId, Long taskOwnerId, LocaleString coordinateSubject, Map<Long, ILocaleString> assigneesFormat, ILocaleString ownerFormat) {
        TaskHandleLogEntityImpl taskHandleLogEntity = new TaskHandleLogEntityImpl();
        taskHandleLogEntity.setAssigneeid(assigneeId);
        taskHandleLogEntity.setAssignee(WfUtils.findUserName(assigneeId));
        ILocaleString assigneeFormat = assigneesFormat.get(assigneeId);
        taskHandleLogEntity.setAssigneeFormat(assigneeFormat);
        taskHandleLogEntity.setOpinion(this.coordinateMsg);
        if (this.isTaskCoodinate.booleanValue()) {
            taskHandleLogEntity.setScenes(COORDINATETASK);
            long currUserId = RequestContext.get().getCurrUserId();
            taskHandleLogEntity.setOwnerId(currUserId);
            taskHandleLogEntity.setOwnerFormat(ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(currUserId)).get(currUserId));
            taskHandleLogEntity.setType("transfer");
            if (this.worksBatchTransfer.booleanValue()) {
                taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u79fb\u4ea4\u534f\u529e\u4efb\u52a1", "TaskCoordinateRequestCmd_11", "bos-wf-engine"));
                taskHandleLogEntity.setOpinion(null);
            } else {
                taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u534f\u529e\u8f6c\u4ea4", "TaskCoordinateRequestCmd_10", "bos-wf-engine"));
            }
            List<HistoricIdentityLinkEntity> historicIdentityLinks = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskIdUserId(this.taskId, taskOwnerId);
            if (historicIdentityLinks != null && !historicIdentityLinks.isEmpty()) {
                taskHandleLogEntity.setDelegateId(historicIdentityLinks.get(0).getDelegateId());
            }
        } else {
            taskHandleLogEntity.setOwnerId(taskOwnerId);
            taskHandleLogEntity.setOwnerFormat(ownerFormat);
            taskHandleLogEntity.setType("coordinate");
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u534f\u529e\u8bf7\u6c42", "TaskCoordinateRequestCmd_9", "bos-wf-engine"));
            List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
            List filteredLinks = identityLinks.stream().filter(identityLink -> taskOwnerId.equals(identityLink.getUserId())).collect(Collectors.toList());
            if (filteredLinks != null && !filteredLinks.isEmpty()) {
                taskHandleLogEntity.setDelegateId(((IdentityLinkEntity)filteredLinks.get(0)).getDelegateId());
            }
        }
        taskHandleLogEntity.setTaskId(this.taskId);
        taskHandleLogEntity.setSubscribe(false);
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
        if (null != task) {
            taskHandleLogEntity.setProcessDefinitionId(task.getProcessDefinitionId());
            taskHandleLogEntity.setProcessInstanceId(task.getProcessInstanceId());
            taskHandleLogEntity.setBusinessKey(task.getBusinessKey());
            taskHandleLogEntity.setBillNo(task.getBillNo());
            taskHandleLogEntity.setActivityId(task.getTaskDefinitionKey());
            taskHandleLogEntity.setActivityName(task.getName());
        }
        if (WfUtils.isNotEmpty((ILocaleString)coordinateSubject)) {
            taskHandleLogEntity.setCurrentSubject((ILocaleString)coordinateSubject);
        }
        taskHandleLogEntity.setTerminalWay(RequestContext.get().getClient());
        return taskHandleLogEntity;
    }

    private void saveTaskCoordinateInfo(CommandContext commandContext, TaskHandleLogEntity taskHandleLogEntity, Long taskOwnerId, Integer priority, ILocaleString currentSubject) {
        Object level;
        Long userId = taskHandleLogEntity.getAssigneeid();
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        taskHandleLogEntityManager.insert(taskHandleLogEntity);
        WfOperationLogUtil.recordOperationLogFromTaskHandle(commandContext, taskHandleLogEntity, null, null);
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(this.taskId, 0L, "participant");
        if (identityLinkEntitys == null || identityLinkEntitys.isEmpty()) {
            QFilter q1 = new QFilter(PARENTTASKID, "=", (Object)this.taskId);
            QFilter q2 = new QFilter("type", "=", (Object)"participant");
            identityLinkEntitys = identityLinkEntityManager.findByQueryFilters(new QFilter[]{q1, q2});
        }
        if (CollectionUtil.isNotEmpty(identityLinkEntitys)) {
            IdentityLinkEntity identityLinkEntityOwner = identityLinkEntitys.get(0);
            IdentityLinkEntityImpl identityLinkEntity = new IdentityLinkEntityImpl();
            identityLinkEntity.setOwnerId(taskOwnerId);
            identityLinkEntity.setTransferOpinion(this.coordinateMsg);
            identityLinkEntity.setUserId(userId);
            identityLinkEntity.setUserName(WfUtils.findUserName(userId));
            ILocaleString userNameFormatter = ParticipantHelper.getParticipantDisplayInfo((TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId), Collections.singletonList(userId)).get(userId);
            identityLinkEntity.setUserNameFormatter(userNameFormatter);
            identityLinkEntity.setType("coordinate");
            identityLinkEntity.setTaskId(this.taskId);
            identityLinkEntity.setParenttaskid(identityLinkEntityOwner.getParenttaskid());
            identityLinkEntity.setProcessDefId(identityLinkEntityOwner.getProcessDefId());
            identityLinkEntity.setProcessInstanceId(identityLinkEntityOwner.getProcessInstanceId());
            identityLinkEntity.setIsPublic(this.isTaskCoodinate != false ? this.isPublic : this.isPublic == false);
            identityLinkEntity.setPriority(priority);
            List filteredLinks = identityLinkEntitys.stream().filter(identityLink -> taskOwnerId.equals(identityLink.getUserId())).collect(Collectors.toList());
            if (filteredLinks != null && !filteredLinks.isEmpty()) {
                identityLinkEntity.setDelegateId(((IdentityLinkEntity)filteredLinks.get(0)).getDelegateId());
            } else {
                List<HistoricIdentityLinkEntity> historicIdentityLinks = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskIdUserId(this.taskId, taskOwnerId);
                if (historicIdentityLinks != null && !historicIdentityLinks.isEmpty()) {
                    taskHandleLogEntity.setDelegateId(historicIdentityLinks.get(0).getDelegateId());
                }
            }
            if (WfUtils.isNotEmpty(currentSubject)) {
                identityLinkEntity.setCurrentSubject(currentSubject);
            }
            identityLinkEntityManager.insert(identityLinkEntity);
        }
        TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, this.taskId, userId, "coordinate", currentSubject);
        IdentityLinkEntity owerIdentityLinkEntity = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
            if (!taskOwnerId.equals(identityLinkEntity.getUserId())) continue;
            owerIdentityLinkEntity = identityLinkEntity;
            break;
        }
        if (owerIdentityLinkEntity != null && WfUtils.isNotEmpty(owerIdentityLinkEntity.getDelegateId())) {
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, this.taskId, userId, "delegate", currentSubject);
        }
        if (this.isTaskCoodinate.booleanValue()) {
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, this.taskId, userId, "pass");
        } else {
            TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, this.taskId, userId, "pass");
        }
        if (WfUtils.isNotEmptyString(priority) && 0 != priority && WfUtils.isNotEmptyString(level = this.dynInfo.get("priority"))) {
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, this.taskId, userId, level.toString());
        }
    }

    private void checkCoordinateUser() {
        if (CollectionUtil.isEmpty(this.userIds)) {
            this.participantIsNullForCoordinateError();
        }
        Map<Long, String> participants = null;
        ArrayList<Long> newUserIds = new ArrayList<Long>(this.userIds);
        for (Long userId : this.userIds) {
            if (WfUtils.isEmpty(userId)) {
                this.participantIsNullForCoordinateError();
            }
            if (participants == null) {
                participants = CoordinateRecordUtil.getParticipantsByTaskId(this.taskId);
            }
            if (!participants.containsKey(userId)) continue;
            if (this.worksBatchTransfer.booleanValue()) {
                throw new WFTaskException(WFErrorCode.participantExistForWorksTransferError());
            }
            if (this.isAuto.booleanValue()) {
                newUserIds.remove(userId);
                continue;
            }
            throw new WFTaskException(WFErrorCode.participantExistForCoordinateError());
        }
        if (CollectionUtil.isEmpty(newUserIds)) {
            this.participantIsNullForCoordinateError();
        }
        this.userIds = newUserIds;
    }

    private void participantIsNullForCoordinateError() {
        throw new WFTaskException(WFErrorCode.participantIsNullForCoordinateError());
    }
}

