/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TaskCoordinateRequestWithdrawCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private List<Long> coordinaterIds;
    private Long currentUserId;

    public TaskCoordinateRequestWithdrawCmd(Long taskId, List<Long> coordinaterIds) {
        this.taskId = taskId;
        this.coordinaterIds = CollectionUtils.isEmpty(coordinaterIds) ? new ArrayList() : coordinaterIds;
        this.currentUserId = Long.valueOf(RequestContext.get().getUserId());
    }

    public TaskCoordinateRequestWithdrawCmd(Long taskId, List<Long> coordinaterIds, Long currentUserId) {
        this.taskId = taskId;
        this.coordinaterIds = CollectionUtils.isEmpty(coordinaterIds) ? new ArrayList() : coordinaterIds;
        this.currentUserId = currentUserId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> checkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(this.taskId, this.currentUserId, "participant");
        if (WfUtils.isEmptyForCollection(checkEntitys)) {
            return String.format(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f%s\u53d1\u8d77\u4eba\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"TaskCoordinateRequestWithdrawCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName());
        }
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskOwnerAndType(this.taskId, this.currentUserId, "coordinate");
        if (WfUtils.isEmptyForCollection(identityLinkEntitys)) {
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            identityLinkEntitys = task != null && WfUtils.isNotEmpty(task.getParentTaskId()) ? identityLinkEntityManager.findIdentityLinkByTaskOwnerAndType(task.getParentTaskId(), 0L, "coordinate") : identityLinkEntityManager.findIdentityLinkByTaskOwnerAndType(this.taskId, 0L, "coordinate");
        }
        HashSet<Long> ids = new HashSet<Long>();
        if (CollectionUtil.isNotEmpty(identityLinkEntitys)) {
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
                ids.add(identityLinkEntity.getUserId());
            }
        }
        if (ids.isEmpty() || !ids.containsAll(this.coordinaterIds)) {
            return String.format(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u4e2d\u6709\u975e%1$s\u4eba\u5458\u6216%2$s\u4eba\u5df2\u7ecf\u5904\u7406%3$s\u4efb\u52a1\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"TaskCoordinateRequestWithdrawCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName());
        }
        Boolean coorIsEmpty = CollectionUtil.isEmpty(this.coordinaterIds);
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
            if (!"coordinate".equals(identityLinkEntity.getType()) || !coorIsEmpty.booleanValue() && (coorIsEmpty.booleanValue() || !this.coordinaterIds.contains(identityLinkEntity.getUserId()))) continue;
            identityLinkEntityManager.delete(identityLinkEntity);
        }
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        QFilter q1 = new QFilter("taskId", "=", (Object)this.taskId);
        QFilter q2 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q3 = new QFilter("userId", "in", this.coordinaterIds);
        if (coorIsEmpty.booleanValue()) {
            historicIdentityLinkEntityManager.deleteByFilters(new QFilter[]{q1, q2});
        } else {
            historicIdentityLinkEntityManager.deleteByFilters(new QFilter[]{q1, q2, q3});
        }
        RuleTaskRelationEntityManager ruleTaskRelationEntityManager = commandContext.getRuleTaskRelationEntityManager();
        if (coorIsEmpty.booleanValue()) {
            Iterator<Object> iterator = ids.iterator();
            while (iterator.hasNext()) {
                ruleTaskRelationEntityManager.deleteEntitiesByTaskIdAndTypeAndUserId(this.taskId, "coordinate", String.valueOf(iterator.next()));
            }
        } else {
            for (Long userId : this.coordinaterIds) {
                ruleTaskRelationEntityManager.deleteEntitiesByTaskIdAndTypeAndUserId(this.taskId, "coordinate", String.valueOf(userId));
            }
        }
        if (coorIsEmpty.booleanValue()) {
            commandContext.getMessageService().deleteToDo(this.taskId, ids.stream().collect(Collectors.toList()));
        } else {
            commandContext.getMessageService().deleteToDo(this.taskId, this.coordinaterIds);
        }
        if (WfUtils.isNotEmpty(this.taskId)) {
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            this.saveOperationLog(commandContext, this.taskId);
            if (task != null) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("targetUserId", coorIsEmpty != false ? ids.stream().collect(Collectors.toList()) : this.coordinaterIds);
                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeAfterTaskListeners(task, "afterCoordCancel", param);
                if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                    HashMap<String, Object> eventMap = new HashMap<String, Object>();
                    eventMap.put("busKey", task.getBusinessKey());
                    eventMap.put("billNo", task.getBillNo());
                    eventMap.put("entityNum", task.getEntityNumber());
                    eventMap.put("ownerId", this.currentUserId);
                    eventMap.put("coordinateUserIds", ids);
                    eventMap.put("taskId", this.taskId);
                    new EventTriggerCmd(TaskEventTypeEnum.TASK_COORDINATE_REQ_WITHDRAW_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
                }
            }
        }
        return ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f\u3002", (String)"TaskCoordinateRequestWithdrawCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("coordinateCancel");
        operationLog.setOwnerId(this.currentUserId);
        operationLog.setOwner(WfUtils.findUserName(this.currentUserId));
        if (!CollectionUtil.isEmpty(this.coordinaterIds)) {
            StringBuilder sb = new StringBuilder();
            for (Long userId : this.coordinaterIds) {
                sb.append(',').append(userId);
            }
            String assigneeIds = sb.substring(1);
            LocaleString assignees = new LocaleString(WfUtils.getUsersName(this.coordinaterIds));
            operationLog.setAssigneeId(assigneeIds);
            operationLog.setAssignee((ILocaleString)assignees);
        }
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u64a4\u56de\u534f\u529e\u8bf7\u6c42", "TaskCoordinateRequestWithdrawCmd_0", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

