/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.task.TaskCoordinateScene;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskUtils;

@Deprecated
public class TaskCoordinateWithdrawCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
    private static final String TASKIDFIELD = "taskid";
    private static final String USERID = "userid";
    private static final String ISPUBLIC = "ispublic";

    public TaskCoordinateWithdrawCmd(Long taskId) {
        this.taskId = taskId;
    }

    public TaskCoordinateWithdrawCmd(Long taskId, Long userId) {
        this.taskId = taskId;
        this.currentUserId = userId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        this.saveOperationLog(commandContext, this.taskId);
        this.withdrawParticipant(commandContext);
        this.dispatchTaskCoordinateListener(taskEntity);
        this.dealWithMobInfo(commandContext, taskEntity);
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            eventMap.put("busKey", taskEntity.getBusinessKey());
            eventMap.put("billNo", taskEntity.getBillNo());
            eventMap.put("entityNum", taskEntity.getEntityNumber());
            eventMap.put("ownerId", this.currentUserId);
            eventMap.put("taskId", this.taskId);
            new EventTriggerCmd(TaskEventTypeEnum.COORNARTE_TASK_REPLY_WITHDRAW_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
        }
        return ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f\u3002", (String)"TaskCoordinateWithdrawCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    private void dispatchTaskCoordinateListener(TaskEntity taskEntity) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            ArrayList<Long> coordinateUserIds = new ArrayList<Long>();
            coordinateUserIds.add(this.currentUserId);
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createCoordinateTaskEvent(ActivitiEventType.TASK_COORDINATE, taskEntity, null, coordinateUserIds, null, TaskCoordinateScene.TASKCOORDINATEWITHDRAW));
        }
    }

    private void deleteData() {
        QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q2 = new QFilter(TASKIDFIELD, "=", (Object)this.taskId);
        QFilter q3 = new QFilter(USERID, "=", (Object)this.currentUserId);
        CommentEntityManager commentEntityManager = Context.getCommandContext().getCommentEntityManager();
        commentEntityManager.deleteByFilters(new QFilter[]{q2, q1, q3});
        DeleteServiceHelper.delete((String)"wf_hiattachment", (QFilter[])new QFilter[]{q2, q3});
        DeleteServiceHelper.delete((String)"wf_hiparticipant", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    private void withdrawParticipant(CommandContext commandContext) {
        DynamicObject hicomment = this.getHicomment(this.taskId, this.currentUserId);
        List<HistoricIdentityLinkEntity> hiEntities = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskUserGroupAndType(this.taskId, this.currentUserId, "coordinate");
        if (null != hiEntities && !hiEntities.isEmpty()) {
            this.deleteData();
            HistoricIdentityLinkEntity hiEntity = hiEntities.get(0);
            DynamicObject participant = BusinessDataServiceHelper.newDynamicObject((String)"wf_participant");
            participant.set("type", (Object)hiEntity.getType());
            participant.set(USERID, (Object)hiEntity.getUserId());
            participant.set(TASKIDFIELD, (Object)hiEntity.getTaskId());
            participant.set("processinstanceid", (Object)hiEntity.getProcessInstanceId());
            participant.set("processdefid", (Object)hiEntity.getProcessDefId());
            participant.set("ownerid", (Object)hiEntity.getOwnerId());
            participant.set("transferopinion", (Object)hiEntity.getTransferOpinion());
            participant.set("createdate", (Object)hiEntity.getCreateDate());
            participant.set("modifydate", (Object)hiEntity.getModifyDate());
            participant.set("parenttaskid", (Object)hiEntity.getParenttaskid());
            participant.set("priority", (Object)hiEntity.getPriority());
            participant.set("username", (Object)hiEntity.getUserName());
            participant.set("usernameformatter", (Object)hiEntity.getUserNameFormatter());
            participant.set(ISPUBLIC, hicomment.get(ISPUBLIC));
            participant.set("compositetaskid", (Object)hiEntity.getCompositeTaskId());
            participant.set("currentsubject", (Object)hiEntity.getCurrenSubject());
            IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
            IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)identityLinkEntityManager.create(participant);
            identityLinkEntityManager.insert(identityLinkEntity);
            DynamicObject hiParticipant = BusinessDataServiceHelper.newDynamicObject((String)"wf_hiparticipant");
            hiParticipant.set("type", (Object)hiEntity.getType());
            hiParticipant.set(USERID, (Object)hiEntity.getUserId());
            hiParticipant.set(TASKIDFIELD, (Object)hiEntity.getTaskId());
            hiParticipant.set("parenttaskid", (Object)hiEntity.getParenttaskid());
            hiParticipant.set("processinstanceid", (Object)hiEntity.getProcessInstanceId());
            hiParticipant.set("processdefid", (Object)hiEntity.getProcessDefId());
            hiParticipant.set("ownerid", (Object)hiEntity.getOwnerId());
            hiParticipant.set("transferopinion", (Object)hiEntity.getTransferOpinion());
            hiParticipant.set("createdate", (Object)hiEntity.getCreateDate());
            hiParticipant.set("modifydate", (Object)hiEntity.getModifyDate());
            hiParticipant.set("subscribesign", (Object)hiEntity.getSubscribesign());
            hiParticipant.set("priority", (Object)hiEntity.getPriority());
            hiParticipant.set("username", (Object)hiEntity.getUserName());
            hiParticipant.set("usernameformatter", (Object)hiEntity.getUserNameFormatter());
            hiParticipant.set("compositetaskid", (Object)hiEntity.getCompositeTaskId());
            hiParticipant.set("currentsubject", (Object)hiEntity.getCurrenSubject());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hiParticipant});
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, this.taskId, hiEntity.getUserId(), "coordinate", hiEntity.getCurrenSubject());
        }
    }

    private DynamicObject getHicomment(Long taskId, Long userId) {
        QFilter q1 = new QFilter(TASKIDFIELD, "=", (Object)taskId);
        QFilter q2 = new QFilter(USERID, "=", (Object)userId);
        QFilter q3 = new QFilter("type", "=", (Object)"coordinate");
        return BusinessDataServiceHelper.loadSingle((String)"wf_hicomment", (String)ISPUBLIC, (QFilter[])new QFilter[]{q1, q3, q2});
    }

    private void dealWithMobInfo(CommandContext commandContext, TaskEntity taskEntity) {
        List<HistoricIdentityLinkEntity> hiEntities = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskUserGroupAndType(this.taskId, this.currentUserId, "coordinate");
        LocaleString coordinateSubject = new LocaleString();
        if (hiEntities != null && !hiEntities.isEmpty()) {
            ILocaleString currenSubject = hiEntities.get(0).getCurrenSubject();
            coordinateSubject = WfMultiLangUtils.changeILocaleStringToLocaleString(currenSubject);
        }
        this.sendTextMessage(commandContext, taskEntity.getBillNo(), taskEntity.getProcessInstanceId(), taskEntity.getTaskDefinitionKey(), coordinateSubject);
        this.createToDo(commandContext, coordinateSubject);
    }

    private void sendTextMessage(CommandContext commandContext, String billNo, Long proInstId, String actId, LocaleString coordinateSubject) {
        List<Long> ownerIds = this.getOwnerIds(commandContext);
        if (!ownerIds.isEmpty()) {
            Object userName = UserServiceHelper.getUserInfoByID((long)this.currentUserId).get("name");
            ILocaleString localeValue = WfUtils.getPromptWordLocaleString("\u60a8\u8bf7\u6c42%1$s\u7684\u5355\u636e\uff1a%2$s\uff0c\u5df2\u88ab%3$s\u64a4\u56de%4$s\u3002", "TaskCoordinateWithdrawCmd_4", "bos-wf-engine");
            MessageContext ctx = MessageServiceUtil.buildMessageContext(this.taskId);
            MessageInfo info = MessageServiceUtil.buildMessageInfo(proInstId, actId);
            info.setMessageContent(WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{localeValue, WfConfigurationUtil.getCoordinateNameFromConfig(), new LocaleString(billNo), new LocaleString((String)userName), WfConfigurationUtil.getCoordinateNameFromConfig()}));
            info.setUserIds(ownerIds);
            if (WfUtils.isNotEmpty((ILocaleString)coordinateSubject)) {
                info.putParam("parsesubject", SerializationUtils.toJsonString((Object)coordinateSubject));
            }
            commandContext.getMessageService().sendMessage(ctx, info);
        }
    }

    private List<Long> getOwnerIds(CommandContext commandContext) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        List<HistoricIdentityLinkEntity> entities = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskUserGroupAndType(this.taskId, this.currentUserId, "coordinate");
        if (null != entities && !entities.isEmpty()) {
            for (HistoricIdentityLinkEntity entity : entities) {
                userIds.add(entity.getOwnerId());
            }
        }
        return userIds;
    }

    private void createToDo(CommandContext commandContext, LocaleString coordinateSubject) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(this.currentUserId);
        commandContext.getMessageService().createCoordinateToDo(this.taskId, userIds, coordinateSubject);
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("coordinateCancel");
        operationLog.setOwnerId(this.currentUserId);
        operationLog.setOwner(WfUtils.findUserName(this.currentUserId));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u64a4\u56de\u534f\u529e", "TaskCoordinateWithdrawCmd_7", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

