/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.impl.cmd.task.TaskCoordinateWithdrawCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class TaskCoordinateWithdrawNewCmd
extends TaskCoordinateWithdrawCmd {
    private Long historicTaskId;
    private Long userId;

    public TaskCoordinateWithdrawNewCmd(Long historicTaskId, Long userId) {
        super(historicTaskId, userId);
        this.historicTaskId = historicTaskId;
        this.userId = userId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        QFilter f1 = new QFilter("taskid", "=", (Object)this.historicTaskId);
        QFilter f2 = new QFilter("userid", "=", (Object)this.userId);
        QFilter f3 = new QFilter("type", "=", (Object)"coordinate");
        QFilter f4 = new QFilter("endtime", "is not null", null);
        boolean exists = QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])new QFilter[]{f1, f2, f3, f4});
        if (!exists) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{TaskErrorCodeEnum.USER_ISNOT_TASK_ASSIGNEE.getDesc()});
        }
        boolean isCoordianteRecored = CoordinateRecordUtil.isCoordinateRecord(this.historicTaskId, this.userId);
        if (isCoordianteRecored) {
            boolean exist = QueryServiceHelper.exists((String)"wf_task", (Object)this.historicTaskId);
            if (!exist) {
                if (CoordinateRecordUtil.isHiparticipant(this.historicTaskId, String.valueOf(this.userId), "participant")) {
                    try {
                        ProcessEngines.getDefaultProcessEngine().getTaskService().withdrawTask(this.historicTaskId, null);
                    }
                    catch (KDException e) {
                        throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{e.toString()});
                    }
                } else {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"taskCoordinateReplyWithdraw_1", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0])});
                }
            }
            if (exist = CoordinateRecordUtil.coordinateRecoredIsExist(this.historicTaskId)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"\u8fd8\u6709\u672a\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u65e0\u9700\u64a4\u56de\uff0c\u5b8c\u6210\u540e\u76f4\u63a5\u8986\u76d6\u3002", (String)"taskCoordinateReplyWithdraw_2", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0])});
            }
            boolean isParticipant = CoordinateRecordUtil.isParticipant(this.historicTaskId, String.valueOf(this.userId), "participant");
            if (isParticipant) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u7ecf\u662f\u4efb\u52a1\u7684\u5ba1\u6279\u4eba\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"taskCoordinateReplyWithdraw_3", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0])});
            }
            Boolean isTransfered = CoordinateRecordUtil.isTransfered(this.historicTaskId, String.valueOf(this.userId));
            if (isTransfered.booleanValue()) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u7ecf\u5c06\u4efb\u52a1\u8f6c\u7ed9\u5176\u4ed6\u4eba\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"taskCoordinateReplyWithdraw_4", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0])});
            }
            boolean isHiparticipant = CoordinateRecordUtil.isHiparticipant(this.historicTaskId, String.valueOf(this.userId), "coordinate");
            if (!isHiparticipant) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"\u53ef\u80fd\u4efb\u52a1\u6709\u8f6c\u7ed9\u60a8\u53c8\u88ab\u64a4\u56de\u7684\u76f8\u5173\u64cd\u4f5c\uff0c\u4efb\u52a1\u4e0d\u80fd\u64a4\u56de\u3002", (String)"taskCoordinateReplyWithdraw_5", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0])});
            }
        } else {
            throw new WFException(TaskErrorCodeEnum.TASK_NOT_COORDINATE.getDesc());
        }
        return super.execute(commandContext);
    }
}

