/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class TaskGetRejectInnerNodesCmd
implements Command<List<Map<String, Object>>> {
    protected Log logger = LogFactory.getLog(TaskGetRejectInnerNodesCmd.class);
    private Long procinstId;
    private String activityId;

    public TaskGetRejectInnerNodesCmd(Long procinstId, String activityId) {
        this.procinstId = procinstId;
        this.activityId = activityId;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.procinstId) || WfUtils.isEmpty(this.activityId)) {
            this.logger.debug("args is null" + this.procinstId + this.activityId);
            return null;
        }
        ExecutionEntity procinst = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.procinstId);
        if (procinst == null) {
            this.logger.debug(String.format("no process instance for id[%s]", this.procinstId));
            return null;
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        BpmnModel model = new GetConfigSchemeBpmnModelCmd(procinst.getSchemeId()).execute(commandContext);
        try {
            Map<String, NodeForkJoinModel> nodeModels = model.getMainProcess().getForkJoinModels();
            NodeForkJoinModel cNodeModel = nodeModels.get(this.activityId);
            if (cNodeModel != null) {
                List<FlowElement> preNodes = BpmnModelUtil.getPreviousNodes(model, this.activityId);
                String structure = cNodeModel.getForkStructure();
                this.logger.debug(String.format("structure[%s]", structure));
                int pathCount = structure.split("\\$").length;
                for (FlowElement ele : preNodes) {
                    String eleId;
                    NodeForkJoinModel itemModel;
                    if (ele instanceof Gateway || ele instanceof CallActivity || ele instanceof WaitTask || ele instanceof StartEvent || ele instanceof NotifyTask || (itemModel = nodeModels.get(eleId = ele.getId())) == null || itemModel.isJoinNode()) continue;
                    String itemStructure = itemModel.getForkStructure();
                    this.logger.debug(String.format("itemStructure[%s]", itemStructure));
                    int itemPathCount = itemStructure.split("\\$").length;
                    if (!structure.equals(itemStructure) && (!itemStructure.contains(structure) || itemPathCount - pathCount != 1) && (!structure.contains(itemStructure) || pathCount - itemPathCount != 1)) continue;
                    HashMap<String, Object> retItem = new HashMap<String, Object>();
                    if (ele instanceof UserTask) {
                        retItem.put("extAttrGroup", BpmnModelUtil.extendAttributeGroupConverterToWF(ele));
                    }
                    retItem.put("id", ele.getId());
                    retItem.put("name", ele.getName());
                    ret.add(retItem);
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("getrejectNode error " + this.activityId + " : " + WfUtils.getExceptionStacktrace(e));
        }
        this.logger.debug(WfUtils.listToString(ret, ","));
        return ret;
    }
}

