/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class TaskHandleContext
extends AgentTaskHandleContext {
    private BpmnModel bpmnModel = null;
    private UserTask flowElement;
    protected Map<String, Object> varaibles = new HashMap<String, Object>();

    public BpmnModel getBpmnModel() {
        return this.bpmnModel;
    }

    public void setBpmnModel(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public UserTask getFlowElement() {
        return this.flowElement;
    }

    public void setFlowElement(UserTask flowElement) {
        this.flowElement = flowElement;
    }

    @Override
    public String getFormKey() {
        if (WfUtils.isEmpty(this.formKey)) {
            this.setUpFormKey();
        }
        return this.formKey;
    }

    @Override
    public String getMobileFormKey() {
        if (WfUtils.isEmpty(this.mobileFormKey)) {
            this.setUpFormKey();
        }
        return this.mobileFormKey;
    }

    private void setUpFormKey() {
        WorkflowService wfService;
        BillSubjectModelEntity billSubjectModelEntity;
        String entityNumber = null;
        if (this.flowElement != null && this.flowElement.getBillSetting() != null && !"BillTask".equals(this.flowElement.getType())) {
            entityNumber = this.flowElement.getEntityNumber();
            this.formKey = this.flowElement.getBillSetting().getFormKey();
            this.mobileFormKey = this.flowElement.getBillSetting().getMobilFormKey();
        } else if (this.task == null) {
            this.formKey = null;
            this.mobileFormKey = null;
        } else {
            entityNumber = this.task.getEntityNumber();
            this.formKey = this.task.getFormKey();
            this.mobileFormKey = this.task.getMobileFormKey();
        }
        if (WfUtils.isEmpty(entityNumber)) {
            return;
        }
        String confCenterFormKey = WfConfigurationUtil.getApprovalFormKey(entityNumber);
        if (WfUtils.isNotEmpty(confCenterFormKey)) {
            this.formKey = confCenterFormKey;
        }
        boolean isNotExistForFormKey = this.notExistForFormKey();
        boolean isNotExistForMobileFormKey = this.notExistForMobileFormKey(entityNumber);
        if (!isNotExistForFormKey && !isNotExistForMobileFormKey) {
            return;
        }
        if ((isNotExistForFormKey || isNotExistForMobileFormKey) && null != (billSubjectModelEntity = (wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService().findBillSubjectByEntityNumber(entityNumber))) {
            if (isNotExistForFormKey) {
                this.formKey = billSubjectModelEntity.getFormKey();
            }
            if (isNotExistForMobileFormKey) {
                this.mobileFormKey = billSubjectModelEntity.getMobileFormKey();
            }
        }
        if (isNotExistForFormKey = this.notExistForFormKey()) {
            this.formKey = entityNumber;
        }
        if (isNotExistForMobileFormKey = this.notExistForMobileFormKey(entityNumber)) {
            this.mobileFormKey = entityNumber + "_mob";
        }
    }

    public void setVariables(Map<String, Object> variables) {
        this.varaibles = variables;
    }

    public Map<String, Object> getVaraibles() {
        return this.varaibles;
    }

    public Object getVaraibleValue(String key) {
        return this.varaibles.get(key);
    }

    private boolean notExistForFormKey() {
        return WfUtils.isEmpty(this.formKey) || !BillPagePluginUtil.isExistForFormId(this.formKey);
    }

    private boolean notExistForMobileFormKey(String entityNumber) {
        if (WfUtils.isEmpty(this.mobileFormKey)) {
            return true;
        }
        if (this.mobileFormKey.endsWith("$")) {
            String billSummaryNumber = this.mobileFormKey.substring(0, this.mobileFormKey.length() - 1);
            QFilter qfilter = new QFilter("number", "=", (Object)billSummaryNumber);
            return !QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{qfilter});
        }
        if (this.mobileFormKey.contains("billSummary")) {
            return false;
        }
        String mobileFormKeyQ = this.mobileFormKey;
        if (this.mobileFormKey.endsWith("&mfm")) {
            mobileFormKeyQ = this.mobileFormKey.split("&mfm")[0];
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Boolean exist = wfService.getManagementService().isExistEnableDynamicFormMapping(entityNumber, mobileFormKeyQ);
            if (null == exist || !exist.booleanValue()) {
                return true;
            }
        }
        return !BillPagePluginUtil.isExistForFormId(mobileFormKeyQ);
    }
}

