/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class TaskListCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int userId;
    protected String isdisplay;
    protected String showType;
    protected Long taskid;
    private static final String FNAME = "fname";
    private static final String FENTITYNAME = "fentityName";
    private static final String FSUBJECT = "fsubject";
    private static final String FSENDERNAME = "fsendername";

    public TaskListCmd(int userId, String isdisplay, String showType) {
        this.userId = userId;
        this.isdisplay = isdisplay;
        this.showType = showType;
    }

    public TaskListCmd(Long taskid, String showType) {
        this.taskid = taskid;
        this.showType = showType;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        List<Object> list = new ArrayList();
        if ("queryTaskListData".equals(this.showType)) {
            list = this.queryTaskListData(commandContext);
        } else if ("showBillInfo".equals(this.showType)) {
            list = this.showBillInfo(commandContext);
        }
        return list;
    }

    private List<Map<String, Object>> queryTaskListData(CommandContext commandContext) {
        ArrayList<Map<String, Object>> taskListInfo = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = null;
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_task";
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FNAME, FNAME, "name");
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FENTITYNAME, FENTITYNAME, "entityname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FSUBJECT, FSUBJECT, "subject");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FSENDERNAME, FSENDERNAME, "sendername");
        String sql = "select a.fid,a.fsenderid,a.fcreatetime,a.fprocessingpage,a.fbusinesskey,a.fprocinstid," + nameSQL + "," + entityNameSQL + "," + subjectSQL + "," + senderNameSQL + " from t_wf_task a INNER JOIN t_wf_task_l b on a.fid=b.fid  INNER JOIN t_wf_participant c on a.fid=c.ftaskid  where c.fuserid = ? and a.FISDISPLAY = ?  order by a.fcreatetime desc ";
        Object[] params = new Object[]{this.userId, this.isdisplay};
        try (DataSet ds = DB.queryDataSet((String)"WfTaskListPlugin.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                map = new HashMap<String, Object>();
                Row row = (Row)iter.next();
                map.put("taskid", row.get("fid"));
                map.put("billtype", row.get(FENTITYNAME));
                map.put("subject", row.get(FSUBJECT));
                map.put("name", row.get(FNAME));
                map.put("businesskey", row.get("fbusinesskey"));
                map.put("processingpage", row.get("fprocessingpage"));
                map.put("truename", row.get(FSENDERNAME));
                map.put("procinstid", row.get("fprocinstid"));
                map.put("createtime", row.get("fcreatetime"));
                taskListInfo.add(map);
            }
        }
        return taskListInfo;
    }

    private List<Map<String, Object>> showBillInfo(CommandContext commandContext) {
        ArrayList<Map<String, Object>> billInfo = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = null;
        String sql = "select t_wf_task.fentitynumber,t_wf_task.fbusinesskey,t_wf_task.fformkey from t_wf_task  where t_wf_task.fid = ? ";
        Object[] params = new Object[]{this.taskid};
        try (DataSet ds = DB.queryDataSet((String)"WfTaskListPlugin.wf_task.showBill", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                map = new HashMap<String, Object>();
                Row row = (Row)iter.next();
                map.put("entitynumber", row.get("fentitynumber"));
                map.put("businesskey", row.get("fbusinesskey"));
                map.put("formkey", row.get("fformkey"));
                billInfo.add(map);
            }
        }
        return billInfo;
    }
}

