/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.BatchCompleteTask;
import kd.bos.workflow.engine.impl.cmd.task.JudgeForkTaskCanRejectCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class TaskRejectToInnerNodeCmd
implements Command<Void> {
    protected Log logger = LogFactory.getLog(TaskRejectToInnerNodeCmd.class);
    private Long taskId;
    private Long userId;
    private String decOptionNumber;
    private String auditMessage;
    private List<String> innerNodeIds;
    private Map<String, Object> variables;
    private boolean skipPath;

    public TaskRejectToInnerNodeCmd(Long taskId, Long userId, String decOptionNumber, String auditMessage, List<String> innerNodeIds, boolean skipPath, Map<String, Object> variables) {
        this.taskId = taskId;
        this.userId = userId;
        this.decOptionNumber = decOptionNumber;
        this.auditMessage = auditMessage;
        this.innerNodeIds = innerNodeIds;
        this.variables = variables;
        this.skipPath = skipPath;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.taskId) || WfUtils.isEmpty(this.userId) || WfUtils.isEmpty(this.decOptionNumber) || this.innerNodeIds == null || this.innerNodeIds.isEmpty()) {
            this.logger.warn(String.format("args:%s-%s", this.innerNodeIds == null ? "" : WfUtils.listToString(this.innerNodeIds, ","), this.variables == null ? "" : SerializationUtils.toJsonString(this.variables)));
            throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskRejectToInnerNodeCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0]));
        }
        this.variables = this.variables == null ? new HashMap() : this.variables;
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            this.logger.warn(String.format("task[%s] not exist!", this.taskId));
            throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s\u4e0d\u5b58\u5728\u3002", (String)"TaskRejectToInnerNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskId));
        }
        String taskDefKey = task.getTaskDefinitionKey();
        if (new JudgeForkTaskCanRejectCmd(task.getProcessInstanceId(), taskDefKey).execute(commandContext).booleanValue()) {
            this.logger.info(String.format("other nodes within the current branch have been rejected, so the current node can't be rejected. taskId:%s,userId:%s", this.taskId, this.userId));
            throw new WFException(WFErrorCode.completedTaskError(), ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u5206\u652f\u5185\u90e8\u8282\u70b9\uff0c\u5df2\u7ecf\u6709\u5176\u4ed6\u5206\u652f\u8282\u70b9\u9a73\u56de\uff0c\u6682\u65f6\u4e0d\u80fd\u9a73\u56de\u3002", (String)"ApprovalPagePluginNew_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(task.getProcessInstanceId());
        UserTask ut = (UserTask)process.getFlowElement(taskDefKey);
        String auditType = null;
        for (DecisionOption op : ut.getDecisionOptions()) {
            if (!this.decOptionNumber.equals(op.getNumber())) continue;
            auditType = op.getAuditType();
            this.variables.put("auditName", new LocaleString(op.getName()));
            this.variables.put("auditType", op.getAuditType());
        }
        if (WfUtils.isEmpty(auditType)) {
            throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u51b3\u7b56\u9879\u3002", (String)"TaskRejectToInnerNodeCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), this.decOptionNumber));
        }
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel currentNodeModel = models.get(taskDefKey);
        StringBuilder nextNodeId = new StringBuilder();
        String dynType = "rejectToForkInner";
        if (currentNodeModel != null) {
            String srcStructure = currentNodeModel.getForkStructure() + "$";
            String frokNodeId = null;
            HashSet<String> structures = new HashSet<String>(this.innerNodeIds.size());
            for (String innerNodeId : this.innerNodeIds) {
                NodeForkJoinModel targetNodeModel = models.get(innerNodeId);
                if (targetNodeModel == null) {
                    throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u4efb\u52a1%1$s\u9a73\u56de\u5230\u5206\u652f\u5185\u90e8\u65f6\uff0c\u627e\u4e0d\u5230%2$s\u7684\u62c6\u5206\u914d\u7f6e\u4fe1\u606f\u3002", (String)"TaskRejectToInnerNodeCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskId, innerNodeId));
                }
                String targetStructure = targetNodeModel.getForkStructure();
                if (structures.contains(targetStructure)) {
                    throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u76f8\u540c\u5206\u652f\u5df2\u6709\u8282\u70b9\u3002", (String)"TaskRejectToInnerNodeCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskId, innerNodeId));
                }
                structures.add(targetStructure);
                if (srcStructure.contains(targetStructure + "$")) {
                    if (this.innerNodeIds.size() > 1) {
                        throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u62c6\u5206\u8282\u70b9\u7684\u5185\u90e8\u8282\u70b9\u3002", (String)"TaskRejectToInnerNodeCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskId, innerNodeId));
                    }
                    if ("reject".equals(auditType)) {
                        nextNodeId.append(innerNodeId).append(',');
                        dynType = "dynReject";
                        break;
                    }
                } else if (!"reject".equals(auditType)) {
                    throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u5206\u652f\u5185\u90e8\u8282\u70b9\u53ea\u80fd\u9a73\u56de\u3002", (String)"TaskRejectToInnerNodeCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskId, innerNodeId));
                }
                if (!targetStructure.contains(srcStructure)) {
                    throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u8282\u70b9[%s]\u975e\u5185\u90e8\u8282\u70b9\u3002", (String)"TaskRejectToInnerNodeCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), innerNodeId));
                }
                String tmpForkNodeId = targetNodeModel.getLatestForkNode();
                if (WfUtils.isEmpty(frokNodeId)) {
                    frokNodeId = tmpForkNodeId;
                } else if (frokNodeId != null && !frokNodeId.equals(tmpForkNodeId)) {
                    throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u62c6\u5206\u8282\u70b9\u7684\u5185\u90e8\u8282\u70b9\u3002", (String)"TaskRejectToInnerNodeCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.listToString(this.innerNodeIds, ",")));
                }
                nextNodeId.append(innerNodeId).append(',');
            }
        }
        if (dynType.equals("rejectToForkInner") && !"AuditTask".equals(task.getCategory())) {
            throw new WFException(WFErrorCode.completedTaskError(), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u975e\u5ba1\u6279\u8282\u70b9\uff0c\u4e0d\u652f\u6301\u9a73\u56de\u5230\u5206\u652f\u3002", (String)"TaskRejectToInnerNodeCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), task.getCategory()));
        }
        if (nextNodeId.length() > 0) {
            String nextNodeIds = nextNodeId.substring(0, nextNodeId.length() - 1);
            this.variables.put("nextNodeId", nextNodeIds);
            this.variables.put("dynType", dynType);
            if ("rejectToForkInner".equals(dynType) && this.skipPath) {
                this.variables.put(String.format("%s-%s", nextNodeIds, "rejectToForkInnerAndSkip"), taskDefKey);
            }
        }
        this.variables.put("auditNumber", this.decOptionNumber);
        this.variables.put("auditMessage", this.auditMessage);
        new BatchCompleteTask(new Long[]{this.taskId}, this.userId, false, this.variables).execute(commandContext);
        return null;
    }
}

