/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.WFMessageServiceHelper;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskRemindEventParams;
import kd.bos.workflow.engine.task.TaskUtils;

public class TaskRemindersCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final String BOS_WF_ENGINE = "bos-wf-engine";
    private static final long serialVersionUID = 1L;
    private static final String REMINDER = "reminder";
    protected Long executionId;
    protected ILocaleString reminderMsg;
    protected Long taskId;
    protected Long userId;
    protected String type;
    public static final String TYPEQUERY = "query";
    public static final String TYPESUBMIT = "submit";
    public static final String ALLUSERNAME = "allUserName";
    public static final String ALLUSERIDLIST = "allUserIdList";
    public static final String PROCINSTID = "procInstId";
    public static final String VALIDUSERNAME = "validUserName";
    private static final String DISPLAYTASK = "displayTask";
    private List<TaskRemindEventParams> taskRemindEventParams = new ArrayList<TaskRemindEventParams>();
    private Log logger = LogFactory.getLog(this.getClass());

    public TaskRemindersCmd(Long executionId, ILocaleString reminderMsg, String type) {
        this.executionId = executionId;
        this.reminderMsg = reminderMsg;
        this.type = type;
    }

    public TaskRemindersCmd(Long executionId, ILocaleString reminderMsg, String type, Long taskId) {
        this.executionId = executionId;
        this.reminderMsg = reminderMsg;
        this.type = type;
        this.taskId = taskId;
    }

    public TaskRemindersCmd(Long executionId, ILocaleString reminderMsg, String type, String userId) {
        this.executionId = executionId;
        this.reminderMsg = reminderMsg;
        this.type = type;
        this.userId = Long.valueOf(userId);
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        Map<String, Object> assignInfos = this.findAssignInfosById(commandContext);
        Map<String, Object> returnInfo = null;
        if (TYPESUBMIT.equals(this.type)) {
            this.saveOperationLog(commandContext, assignInfos);
            returnInfo = this.sendTextMessageOneByOne(commandContext, assignInfos);
        } else if (TYPEQUERY.equals(this.type)) {
            returnInfo = assignInfos;
            String allUserName = "";
            if (null != assignInfos.get(ALLUSERNAME)) {
                allUserName = assignInfos.get(ALLUSERNAME).toString();
            }
            List allUserIdList = (List)assignInfos.get(ALLUSERIDLIST);
            String message = null;
            if (WfUtils.isEmptyString(allUserName)) {
                message = !((Boolean)returnInfo.get(DISPLAYTASK)).booleanValue() ? String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5728\u6d88\u606f\u4e2d\u5fc3\u7684\u5f85\u529e\u4e2d\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TaskRemindersCmd_6", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName()) : String.format(ResManager.loadKDString((String)"\u65e0\u5904\u7406\u4eba\u6216\u8005\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"TaskRemindersCmd_1", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
            } else if (0 == allUserIdList.size()) {
                message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5904\u7406\u4eba\u662f\u81ea\u5df1\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"TaskRemindersCmd_2", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
            }
            returnInfo.put("message", message);
        }
        return returnInfo;
    }

    private Map<String, Object> findAssignInfosById(CommandContext commandContext) {
        String currentUserIdObj = RequestContext.get().getUserId();
        Long currentUserId = WfUtils.isNotEmpty(currentUserIdObj) ? Long.valueOf(Long.parseLong(currentUserIdObj)) : null;
        HashMap<String, Object> assignInfo = new HashMap<String, Object>();
        HashMap<String, Object> assignInfoDetail = null;
        Map userInfo = null;
        Long procinstid = null;
        Long procdefid = null;
        String taskdefid = null;
        String entityname = null;
        String businesskey = null;
        Long starterid = null;
        ArrayList<Long> userIdList = null;
        List<Long> taskIdList = null;
        Long userId = null;
        Object userName = null;
        Object userNumber = null;
        String userIdShow = null;
        String entityNum = null;
        String billNo = null;
        StringBuilder userNameShow = new StringBuilder();
        StringBuilder allUserName = new StringBuilder();
        StringBuilder validUserName = new StringBuilder();
        ArrayList<Long> allUserIdList = new ArrayList<Long>();
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_task", "a", "b", "fentityName", "fentityName", "entityname");
        String sql = "SELECT c.fuserid,a.fprocinstid,a.ftaskdefid ,a.fprocdefid,a.fid ," + entityNameSQL + ",a.fbusinesskey ,a.fentitynumber,a.fbillno,a.fstarterid ,a.FISDISPLAY FROM t_wf_task a INNER JOIN t_wf_task_l b on a.FID=b.FID INNER JOIN t_wf_participant c ON a.fid = c.ftaskid where a.fprocinstid=? and c.FTYPE = ? and b.FLOCALEID = ? ORDER BY a.FPROCINSTID";
        String algoKey = "ApprovalPageListPlugin.t_wf_task.findAssignIdsById";
        Object[] params = new Object[]{this.executionId, "participant", RequestContext.get().getLang().toString()};
        this.logger.debug("\u50ac\u529e\u53c2\u6570--sql\uff1a" + sql);
        this.logger.debug("\u50ac\u529e\u53c2\u6570--executionId\uff1a" + this.executionId);
        HashSet<Long> userIdSet = new HashSet<Long>();
        boolean isNotSamePerson = false;
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            boolean displayTask = true;
            for (Row row : ds) {
                if (null == row) continue;
                if (displayTask) {
                    displayTask = "1".equals(row.get("FISDISPLAY"));
                }
                if (!displayTask) continue;
                userNameShow = new StringBuilder();
                taskdefid = row.get("ftaskdefid").toString();
                assignInfoDetail = (HashMap<String, Object>)assignInfo.get(taskdefid);
                if (null == assignInfoDetail || assignInfoDetail.isEmpty()) {
                    assignInfoDetail = new HashMap<String, Object>();
                    userIdList = new ArrayList<Long>();
                    taskIdList = new ArrayList();
                    userIdShow = null;
                } else {
                    userIdList = (ArrayList<Long>)assignInfoDetail.get("userIdList");
                    taskIdList = (List)assignInfoDetail.get("taskIdList");
                    userNameShow.append(assignInfoDetail.get("returnDataUserName"));
                    userIdShow = (String)assignInfoDetail.get("returnDataUserId");
                }
                if (null != row.get("fuserid")) {
                    userId = row.getLong("fuserid");
                    if (null == userIdShow && WfUtils.isNotEmpty(userId)) {
                        userIdShow = userId.toString();
                    }
                    userInfo = UserServiceHelper.getUserInfoByID((long)userId);
                    userName = userInfo.get("name");
                    userNumber = userInfo.get("number");
                    if (!WfUtils.isEmpty(userId)) {
                        userNameShow.append((Object)userName).append(",");
                        isNotSamePerson = userIdSet.add(userId);
                        if (isNotSamePerson) {
                            if (WfUtils.isEmptyString(userName) && null != userNumber) {
                                allUserName.append(ResManager.loadKDString((String)"\u5de5\u53f7_", (String)"TaskRemindersCmd_3", (String)BOS_WF_ENGINE, (Object[])new Object[0])).append((Object)userNumber).append(",");
                            } else {
                                allUserName.append((Object)userName).append(",");
                            }
                        }
                    }
                    if (null != currentUserId && !currentUserId.equals(userId)) {
                        if (isNotSamePerson) {
                            if (WfUtils.isEmptyString(userName)) {
                                validUserName.append(ResManager.loadKDString((String)"\u5de5\u53f7_", (String)"TaskRemindersCmd_3", (String)BOS_WF_ENGINE, (Object[])new Object[0])).append((Object)userNumber).append(",");
                            } else {
                                validUserName.append((Object)userName).append(",");
                            }
                        }
                        if (null == userIdList) {
                            userIdList = new ArrayList();
                        }
                        if (null == taskIdList) {
                            taskIdList = new ArrayList();
                        }
                        userIdList.add(userId);
                        if (null != row.get("fid")) {
                            taskIdList.add(Long.parseLong(row.get("fid").toString()));
                        }
                        allUserIdList.add(userId);
                    }
                }
                if (null == procinstid || !procinstid.equals(row.get("fprocinstid"))) {
                    procinstid = Long.parseLong(row.get("fprocinstid").toString());
                }
                if (null == procdefid || !procdefid.equals(row.get("fprocdefid"))) {
                    procdefid = Long.parseLong(row.get("fprocdefid").toString());
                }
                if (null == entityname || !entityname.equals(row.get("fentityname"))) {
                    entityname = row.get("fentityname").toString();
                }
                if (null == businesskey || !businesskey.equals(row.get("fbusinesskey"))) {
                    businesskey = row.get("fbusinesskey").toString();
                }
                if (null == starterid || !starterid.equals(row.get("fstarterid"))) {
                    starterid = (Long)row.get("fstarterid");
                }
                if (null == entityNum || !entityNum.equals(row.get("fentitynumber"))) {
                    entityNum = row.get("fentitynumber").toString();
                }
                if (null == billNo || !billNo.equals(row.get("fbillno"))) {
                    billNo = row.get("fbillno").toString();
                }
                if (null == assignInfoDetail) {
                    assignInfoDetail = new HashMap();
                }
                assignInfoDetail.put("taskdefinitionkey", taskdefid);
                assignInfoDetail.put("userIdList", userIdList);
                assignInfoDetail.put("taskIdList", taskIdList);
                assignInfoDetail.put("returnDataUserName", userNameShow);
                assignInfoDetail.put("returnDataUserId", userIdShow);
                assignInfoDetail.put("processInstanceId", procinstid);
                assignInfoDetail.put("processDefinitionId", procdefid);
                assignInfoDetail.put("entityname", entityname);
                assignInfoDetail.put("businesskey", businesskey);
                assignInfoDetail.put("starterid", starterid);
                assignInfo.put(taskdefid, assignInfoDetail);
                assignInfo.put(PROCINSTID, procinstid);
                TaskRemindEventParams taskRemindEventParam = new TaskRemindEventParams();
                taskRemindEventParam.setTaskId(Long.valueOf(Long.parseLong(row.get("fid").toString())));
                taskRemindEventParam.setBillNo(billNo);
                taskRemindEventParam.setBusinessKey(businesskey);
                taskRemindEventParam.setEntityNumber(entityNum);
                taskRemindEventParam.setReminderUserIds(userIdList);
                this.taskRemindEventParams.add(taskRemindEventParam);
            }
            assignInfo.put(ALLUSERNAME, allUserName.toString());
            assignInfo.put(ALLUSERIDLIST, allUserIdList);
            assignInfo.put(VALIDUSERNAME, validUserName.toString());
            assignInfo.put(DISPLAYTASK, displayTask);
        }
        this.logger.debug("\u50ac\u529e\u67e5\u8be2\u7ed3\u679c--assignInfo\uff1a" + assignInfo);
        return assignInfo;
    }

    private Map<String, Object> sendTextMessageOneByOne(CommandContext commandContext, Map<String, Object> assignInfos) {
        HashMap<String, Object> returnInfo = new HashMap<String, Object>();
        String showMsg = null;
        if (WfUtils.isEmpty(this.reminderMsg)) {
            showMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u610f\u89c1\u3002", (String)"TaskRemindersCmd_7", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
            returnInfo.put("showMsg", showMsg);
            return returnInfo;
        }
        if (!WfUtils.isEmptyString(assignInfos.get(ALLUSERNAME))) {
            List allUserIdList = (List)assignInfos.get(ALLUSERIDLIST);
            if (0 != allUserIdList.size()) {
                String validUserName = assignInfos.get(VALIDUSERNAME).toString();
                showMsg = String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f%1$s\u81f3%2$s\u3002", (String)"TaskRemindersCmd_4", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName(), validUserName.substring(0, validUserName.length() - 1));
                assignInfos.remove(ALLUSERNAME);
                assignInfos.remove(ALLUSERIDLIST);
                assignInfos.remove(VALIDUSERNAME);
                assignInfos.remove(PROCINSTID);
                assignInfos.remove(DISPLAYTASK);
                Long senderUserId = Long.parseLong(RequestContext.get().getUserId());
                if (!WfUtils.isEmpty(this.userId)) {
                    senderUserId = this.userId;
                }
                Map assignInfo = null;
                if (WfUtils.isNotEmptyForMap(assignInfos)) {
                    Set<Map.Entry<String, Object>> entrySet = assignInfos.entrySet();
                    if (null != entrySet) {
                        for (Map.Entry<String, Object> entry : entrySet) {
                            assignInfo = (Map)entry.getValue();
                            List userIdList = (List)assignInfo.get("userIdList");
                            List taskIdList = (List)assignInfo.get("taskIdList");
                            this.logger.debug("\u50ac\u529euserIds:" + userIdList.toString() + "; taskIdList: " + taskIdList);
                            if (0 == taskIdList.size()) continue;
                            int taskIdListSize = taskIdList.size();
                            Long taskId = null;
                            for (int i = 0; i < taskIdListSize; ++i) {
                                taskId = (Long)taskIdList.get(i);
                                this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.TaskRemindersCmd.sendTextMessageOneByOne beginSendLinkMessage :" + i + " time;");
                                WFMessageServiceHelper.sendLinkMessageForReminders(taskId, this.reminderMsg, Collections.singletonList(userIdList.get(i)), senderUserId);
                                this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.TaskRemindersCmd.sendTextMessageOneByOne endSendLinkMessage and beginSaveRTRelation :" + i + " time;taskId : " + taskId + "; userId : " + userIdList.get(i));
                                TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, (Long)userIdList.get(i), REMINDER);
                            }
                        }
                    }
                    if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                        HashMap<String, Object> eventMap = new HashMap<String, Object>();
                        eventMap.put("taskRemindEventParams", this.taskRemindEventParams);
                        eventMap.put("reminderMsg", this.reminderMsg);
                        eventMap.put("senderUserId", senderUserId);
                        new EventTriggerCmd(TaskEventTypeEnum.TASK_REMINDER_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
                    }
                }
            } else {
                showMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5904\u7406\u4eba\u662f\u81ea\u5df1\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"TaskRemindersCmd_2", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
            }
        } else {
            showMsg = (Boolean)assignInfos.get(DISPLAYTASK) == false ? ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u4e0d\u80fd\u8fdb\u884c\u50ac\u529e\u3002", (String)"TaskRemindersCmd_8", (String)BOS_WF_ENGINE, (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u65e0\u5904\u7406\u4eba\u6216\u8005\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"TaskRemindersCmd_1", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
        }
        returnInfo.put("showMsg", showMsg);
        return returnInfo;
    }

    private void saveOperationLog(CommandContext commandContext, Map<String, Object> assignInfos) {
        Object procInstIdStr;
        List allUserIdList = (List)assignInfos.get(ALLUSERIDLIST);
        if (!allUserIdList.isEmpty() && null != (procInstIdStr = assignInfos.get(PROCINSTID))) {
            Long procInstId = Long.parseLong(procInstIdStr.toString());
            OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
            Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
            operationLog.setCreateDate(date);
            operationLog.setProcInstId(procInstId);
            if (WfUtils.isNotEmpty(this.taskId)) {
                operationLog.setTaskId(this.taskId);
            }
            operationLog.setType("reminders");
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            operationLog.setOwnerId(userId);
            operationLog.setOwner(WfUtils.findUserName(userId));
            StringBuilder sb = new StringBuilder();
            for (Long id : allUserIdList) {
                sb.append(",").append(id);
            }
            operationLog.setAssigneeId(sb.substring(1));
            Object allUserName = assignInfos.get(ALLUSERNAME);
            if (WfUtils.isNotEmptyString(allUserName)) {
                String userNames = allUserName.toString();
                if (userNames.endsWith(",")) {
                    userNames = userNames.substring(0, userNames.length() - 1);
                }
                operationLog.setAssignee((ILocaleString)new LocaleString(userNames));
            }
            operationLog.setNOpinion(this.reminderMsg);
            WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
        }
    }
}

