/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.WFMessageServiceHelper;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskRemindEventParams;
import kd.bos.workflow.engine.task.TaskUtils;

public class TaskRemindersForBatchCmd
implements Command<BatchOperateResult>,
Serializable {
    private static final long serialVersionUID = -2813537963229165111L;
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String BOS_WF_ENGINE = "bos-wf-engine";
    private List<TaskRemindEventParams> taskRemindEventParams = new ArrayList<TaskRemindEventParams>();
    private Long[] processInstanceIds;
    private ILocaleString reminderMsg;
    private Long currentUserId;
    protected String processInstanceIdsForQuery;

    public TaskRemindersForBatchCmd(Long[] processInstanceIds, ILocaleString reminderMsg) {
        this.processInstanceIds = processInstanceIds;
        this.reminderMsg = reminderMsg;
    }

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        BatchOperateResult operateResult = null;
        int failedCount = null == this.processInstanceIds ? 0 : this.processInstanceIds.length;
        String validateMsg = this.getValidateMsg();
        if (WfUtils.isNotEmpty(validateMsg)) {
            operateResult = new BatchOperateResult();
            operateResult.setValidateMsg(validateMsg);
            operateResult.setFailedCount(failedCount);
            return operateResult;
        }
        List<Map<String, Object>> taskRemindersInfos = this.getTaskRemindersInfo();
        if (null == taskRemindersInfos || taskRemindersInfos.isEmpty()) {
            operateResult = new BatchOperateResult();
            validateMsg = String.format(ResManager.loadKDString((String)"\u65e0\u5904\u7406\u4eba\u6216\u8005\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"TaskRemindersCmd_1", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
            operateResult.setValidateMsg(validateMsg);
            operateResult.setFailedCount(failedCount);
            return operateResult;
        }
        return this.doTaskRemindersForBatch(commandContext, taskRemindersInfos);
    }

    private String getValidateMsg() {
        if (WfUtils.isEmpty(this.reminderMsg)) {
            return String.format(ResManager.loadKDString((String)"\u50ac\u529e\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskRemindersForBatchCmd_0", (String)BOS_WF_ENGINE, (Object[])new Object[0]), new Object[0]);
        }
        if (null == this.processInstanceIds || 0 == this.processInstanceIds.length) {
            return String.format(ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u5b9e\u4f8bID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskRemindersForBatchCmd_1", (String)BOS_WF_ENGINE, (Object[])new Object[0]), new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Long processInstanceId : this.processInstanceIds) {
            if (!WfUtils.isNotEmpty(processInstanceId)) continue;
            sb.append(processInstanceId).append(",");
        }
        if (0 == sb.length()) {
            return String.format(ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u5b9e\u4f8bID\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskRemindersForBatchCmd_2", (String)BOS_WF_ENGINE, (Object[])new Object[0]), new Object[0]);
        }
        this.processInstanceIdsForQuery = sb.substring(0, sb.length() - 1);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> getTaskRemindersInfo() {
        String sql = "select a.fprocinstid,a.fbillno,al.factivityname,b.fid,b.fcategory,b.fparenttaskid,b.fisdisplay,c.fuserid,b.fbusinesskey,b.fentitynumber from t_wf_execution a inner join t_wf_execution_l al on a.fid = al.fid and flocaleid = ? left join t_wf_task b on a.fid = b.fexecutionid left join t_wf_participant c on b.FID = c.FTASKID and c.FTYPE = ? where a.fparentid != 0 and a.fprocinstid in ( " + this.processInstanceIdsForQuery + " ) ";
        String algoKey = "TaskRemindersForBatchCmd.getTaskRemindersInfo";
        Object[] params = new Object[]{RequestContext.get().getLang().toString(), "participant"};
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            if (null == ds) {
                List<Map<String, Object>> list = null;
                return list;
            }
            ArrayList<Map<String, Object>> taskRemindersInfos = new ArrayList<Map<String, Object>>();
            Map<Object, Object> taskRemindersInfo = new HashMap();
            Row row2222 = null;
            HashSet<Long> set = new HashSet<Long>();
            Long taskId = null;
            ArrayList<Long> assigneeIds = new ArrayList<Long>();
            Long assigneeId = null;
            for (Row row2222 : ds) {
                if (null == row2222) continue;
                taskId = row2222.getLong("fid");
                if (WfUtils.isEmpty(taskId)) {
                    taskRemindersInfo = this.getTaskRemindersInfo(row2222);
                    taskRemindersInfos.add(taskRemindersInfo);
                    continue;
                }
                if ("YunzhijiaTask".equals(row2222.getString("fcategory")) && WfUtils.isEmpty(row2222.getLong("fparenttaskid"))) continue;
                if (set.add(taskId)) {
                    assigneeIds = new ArrayList();
                    taskRemindersInfo = this.getTaskRemindersInfo(row2222);
                    taskRemindersInfo.put("taskId", taskId);
                    taskRemindersInfo.put("displayTask", row2222.getBoolean("fisdisplay"));
                    taskRemindersInfos.add(taskRemindersInfo);
                    TaskRemindEventParams taskRemindEventParam = new TaskRemindEventParams();
                    taskRemindEventParam.setTaskId(taskId);
                    String entityNum = null;
                    String billNo = null;
                    String businesskey = null;
                    if (row2222.get("fbusinesskey") != null) {
                        businesskey = row2222.get("fbusinesskey").toString();
                    }
                    if (row2222.get("fentitynumber") != null) {
                        entityNum = row2222.get("fentitynumber").toString();
                    }
                    if (row2222.get("fbillno") != null) {
                        billNo = row2222.get("fbillno").toString();
                    }
                    taskRemindEventParam.setBillNo(billNo);
                    taskRemindEventParam.setBusinessKey(businesskey);
                    taskRemindEventParam.setEntityNumber(entityNum);
                    taskRemindEventParam.setReminderUserIds(assigneeIds);
                    this.taskRemindEventParams.add(taskRemindEventParam);
                }
                if (WfUtils.isNotEmpty(assigneeId = row2222.getLong("fuserid"))) {
                    assigneeIds.add(assigneeId);
                }
                taskRemindersInfo.put("assigneeIds", assigneeIds);
            }
            ArrayList<Map<String, Object>> arrayList = taskRemindersInfos;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.info("kd.bos.workflow.engine.impl.cmd.task.TaskRemindersForBatchCmd.getTaskRemindersInfo(CommandContext) Exception\uff1a " + WfUtils.getExceptionStacktrace(e));
            return Collections.EMPTY_LIST;
        }
    }

    private Map<String, Object> getTaskRemindersInfo(Row row) {
        if (null == row) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> taskRemindersInfo = new HashMap<String, Object>();
        taskRemindersInfo.put("processInstanceId", row.getLong("fprocinstid"));
        taskRemindersInfo.put("billNo", row.getString("fbillno"));
        taskRemindersInfo.put("activityName", row.getString("factivityname"));
        return taskRemindersInfo;
    }

    private BatchOperateResult doTaskRemindersForBatch(CommandContext commandContext, List<Map<String, Object>> taskRemindersInfos) {
        if (null == commandContext || null == taskRemindersInfos || taskRemindersInfos.isEmpty()) {
            return null;
        }
        BatchOperateResult batchOperateResult = new BatchOperateResult();
        int sucessCount = 0;
        int failedCount = 0;
        ArrayList<OperateResult> operateResults = new ArrayList<OperateResult>(taskRemindersInfos.size());
        batchOperateResult.setOperateResults(operateResults);
        String billNo = null;
        String operateMsg = null;
        Boolean displayTask = null;
        List assigneeIds = null;
        Iterator assigneeIdIte = null;
        Long assigneeId = null;
        this.currentUserId = Long.parseLong(RequestContext.get().getUserId());
        Long taskId = null;
        String activityName = null;
        HashSet processInsIds = new HashSet();
        taskRemindersInfos.stream().forEach(taskInfo -> processInsIds.add((Long)taskInfo.get("processInstanceId")));
        for (Long processInstanceId : this.processInstanceIds) {
            if (processInsIds.contains(processInstanceId)) continue;
            OperateResult operateResult = new OperateResult();
            operateResults.add(operateResult);
            ++failedCount;
            String opMsg = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u201c%s\u201d\u975e\u5728\u9014\u6d41\u7a0b\uff0c\u65e0\u6cd5\u50ac\u529e\u3002", (String)"TaskRemindersCmd_9", (String)BOS_WF_ENGINE, (Object[])new Object[0]), processInstanceId);
            this.setOperateResult(operateResult, billNo, activityName, opMsg, false);
        }
        for (Map map : taskRemindersInfos) {
            taskId = (Long)map.get("taskId");
            billNo = (String)map.get("billNo");
            activityName = (String)map.get("activityName");
            OperateResult operateResult = new OperateResult();
            operateResults.add(operateResult);
            if (WfUtils.isEmpty(taskId)) {
                ++failedCount;
                this.setOperateResult(operateResult, billNo, activityName, null, false);
                continue;
            }
            displayTask = (Boolean)map.get("displayTask");
            if (null != displayTask && !displayTask.booleanValue()) {
                ++failedCount;
                operateMsg = String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e0d\u5728\u6d88\u606f\u4e2d\u5fc3\u7684\u5f85\u529e\u4e2d\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TaskRemindersCmd_6", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
                this.setOperateResult(operateResult, billNo, activityName, operateMsg, false);
                continue;
            }
            assigneeIds = (List)map.get("assigneeIds");
            if (null == assigneeIds || assigneeIds.isEmpty()) {
                ++failedCount;
                this.setOperateResult(operateResult, billNo, activityName, null, false);
                continue;
            }
            assigneeIdIte = assigneeIds.iterator();
            while (assigneeIdIte.hasNext()) {
                assigneeId = (Long)assigneeIdIte.next();
                if (null == assigneeId || !assigneeId.equals(this.currentUserId)) continue;
                assigneeIdIte.remove();
            }
            if (null == assigneeIds || assigneeIds.isEmpty()) {
                ++failedCount;
                operateMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5904\u7406\u4eba\u662f\u81ea\u5df1\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"TaskRemindersCmd_2", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
                this.setOperateResult(operateResult, billNo, activityName, operateMsg, false);
                continue;
            }
            try {
                this.saveOperationLog(commandContext, (Long)map.get("processInstanceId"), taskId, assigneeIds);
                WFMessageServiceHelper.sendLinkMessageForReminders(taskId, this.reminderMsg, assigneeIds, this.currentUserId);
                for (Long userId : assigneeIds) {
                    TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, userId, "reminder");
                }
                ++sucessCount;
                this.setOperateResult(operateResult, billNo, activityName, null, true);
            }
            catch (Exception e) {
                this.logger.info("kd.bos.workflow.engine.impl.cmd.task.TaskRemindersForBatchCmd.doTaskRemindersForBatch(CommandContext, List<Map<String, Object>>) Exception\uff1a " + WfUtils.getExceptionStacktrace(e));
                ++failedCount;
                operateMsg = String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u4e0d\u80fd\u8fdb\u884c%s\u3002", (String)"TaskRemindersForBatchCmd_4", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
                this.setOperateResult(operateResult, billNo, activityName, operateMsg, false);
            }
        }
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> eventMap = new HashMap<String, Object>();
            eventMap.put("taskRemindEventParams", this.taskRemindEventParams);
            eventMap.put("reminderMsg", this.reminderMsg);
            eventMap.put("senderUserId", this.currentUserId);
            new EventTriggerCmd(TaskEventTypeEnum.TASK_REMINDER_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
        }
        batchOperateResult.setSucessCount(sucessCount);
        batchOperateResult.setFailedCount(failedCount);
        return batchOperateResult;
    }

    private void saveOperationLog(CommandContext commandContext, Long processInstanceId, Long taskId, List<Long> assigneeIds) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        if (null != assigneeIds && !assigneeIds.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Long id : assigneeIds) {
                sb.append(",").append(id);
            }
            operationLog.setAssigneeId(sb.substring(1));
            String assigneeNames = WfUtils.getUsersName(assigneeIds);
            if (WfUtils.isNotEmpty(assigneeNames)) {
                operationLog.setAssignee((ILocaleString)new LocaleString(assigneeNames));
            }
        }
        operationLog.setOwnerId(this.currentUserId);
        operationLog.setOwner(WfUtils.findUserName(this.currentUserId));
        operationLog.setProcInstId(processInstanceId);
        operationLog.setTaskId(taskId);
        operationLog.setType("reminders");
        operationLog.setNOpinion(this.reminderMsg);
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    private OperateResult setOperateResult(OperateResult operateResult, String billNo, String activityName, String operateMsg, boolean success) {
        if (success) {
            operateResult.setOperateStatus("success");
            operateMsg = String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"TaskRemindersForBatchCmd_3", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
        } else {
            operateResult.setOperateStatus("failed");
            if (WfUtils.isEmpty(operateMsg)) {
                operateMsg = String.format(ResManager.loadKDString((String)"\u65e0\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u8fdb\u884c%s\u3002", (String)"TaskRemindersForBatchCmd_6", (String)BOS_WF_ENGINE, (Object[])new Object[0]), WfConfigurationUtil.getUrgeName());
            }
        }
        if (WfUtils.isNotEmpty(activityName)) {
            operateMsg = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d", (String)"TaskRemindersForBatchCmd_5", (String)BOS_WF_ENGINE, (Object[])new Object[0]), activityName) + operateMsg;
        }
        if (WfUtils.isNotEmpty(billNo)) {
            operateMsg = billNo + "\uff1a" + operateMsg;
        }
        operateResult.setOperateMsg(operateMsg);
        operateResult.setOperateType("remind");
        return operateResult;
    }
}

