/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithCoordinateCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithSameUserCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.TasksTransferEventParams;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFTaskException;
import kd.bos.workflow.service.WfTraceType;

public class TaskTransferCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long taskId;
    protected Long transfererId;
    protected ILocaleString transferOpinion;
    protected Boolean transferSubscribe;
    protected Boolean isNeedDealCompositeTask;
    protected Long ownerId;
    public static final String PASS = "pass";
    private Map<String, Object> dynInfo;
    private Boolean isAutoTransfer = Boolean.FALSE;
    private Log logger = LogFactory.getLog(this.getClass());
    private TasksTransferEventParams tasksTransferEventParams = new TasksTransferEventParams();

    public TaskTransferCmd(Long taskId, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe, Long ownerId, Boolean isNeedDealCompositeTask) {
        this.taskId = taskId;
        this.transfererId = transfererId;
        this.transferOpinion = transferOpinion;
        this.transferSubscribe = transferSubscribe;
        this.ownerId = ownerId;
        this.isNeedDealCompositeTask = isNeedDealCompositeTask;
    }

    public TaskTransferCmd(Long taskId, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe, Long ownerId, Boolean isNeedDealCompositeTask, Boolean isAutoTransfer) {
        this(taskId, transfererId, transferOpinion, transferSubscribe, ownerId, isNeedDealCompositeTask);
        this.isAutoTransfer = isAutoTransfer;
    }

    public TaskTransferCmd(Long taskId, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe, Long ownerId, Boolean isNeedDealCompositeTask, Map<String, Object> dynInfo) {
        this.taskId = taskId;
        this.transfererId = transfererId;
        this.transferOpinion = transferOpinion;
        this.transferSubscribe = transferSubscribe;
        this.ownerId = ownerId;
        this.isNeedDealCompositeTask = isNeedDealCompositeTask;
        this.dynInfo = dynInfo;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (null == this.taskId || TaskUtils.handledRequest("TaskTransferCmd", this.taskId.toString())) {
            return null;
        }
        StringBuilder logInfo = new StringBuilder();
        if (!this.validateCanTransfer(commandContext)) {
            this.logger.debug(String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\u3010%s\u3011\u8f6c\u4ea4\u7ed9\u3010%s\u3011\u7684\u8bb0\u5f55\uff0c\u81ea\u52a8\u8f6c\u4ea4\u4e0b\u4e0d\u80fd\u518d\u8f6c\u4ea4\uff01", this.taskId, this.ownerId, this.transfererId));
            return null;
        }
        try {
            logInfo.append(this.transferTask(commandContext, this.taskId));
            if (this.isNeedDealCompositeTask.booleanValue()) {
                TaskHelper.dealWithCompositeTask(this.taskId);
            } else if (TaskHelper.isComposeTask(this.taskId)) {
                List<Long> composedTaskIds = commandContext.getTaskEntityManager().findComposedTaskIdsByCompositeTaskIdAndUserId(this.taskId, this.ownerId);
                for (Long composedTaskId : composedTaskIds) {
                    logInfo.append(this.transferTask(commandContext, composedTaskId));
                }
            } else if (TaskHelper.isComposedTask(this.taskId)) {
                TaskHelper.clearIdentityCompositeTaskId(this.taskId);
            }
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                HashMap<String, Object> eventMap = new HashMap<String, Object>();
                eventMap.put("transferOpinion", this.transferOpinion);
                eventMap.put("transferId", this.transfererId);
                eventMap.put("businessKey", this.tasksTransferEventParams.getBusinessKey());
                eventMap.put("entityNumber", this.tasksTransferEventParams.getEntityNumber());
                eventMap.put("tasksTransferEventParams", this.tasksTransferEventParams);
                eventMap.put("transferType", "OrdinaryTransfer");
                new EventTriggerCmd(TaskEventTypeEnum.TASK_TRANSFER_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
            }
        }
        catch (Exception e) {
            if (!WfUtils.isEmpty(logInfo.toString())) {
                this.logger.warn(logInfo.toString());
            }
            throw e;
        }
        finally {
            if (null != this.taskId) {
                TaskUtils.removeHandledRequest("TaskTransferCmd", this.taskId.toString());
            }
        }
        return null;
    }

    private String transferTask(CommandContext commandContext, Long taskId) {
        List<Long> ownerids = TaskUtils.getParticipantIdsByTaskId(taskId);
        if (null == ownerids) {
            throw new WFTaskException(WFErrorCode.taskHasBeenHandled(), taskId);
        }
        if (0 == ownerids.size()) {
            throw new WFTaskException(WFErrorCode.participantIsNull());
        }
        if (!ownerids.contains(this.transfererId)) {
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            if (null != task) {
                if (TaskUtils.isBizTask(task.getSource())) {
                    throw new WFTaskException(WFErrorCode.isNotFlowTask(), task.getBillNo(), ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"TaskTransferCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                TaskHandleLogEntity entity = this.getTaskHandleLogEntity(commandContext, task);
                this.dispatchTransferEvent(entity);
                if (this.isAutoTransfer.booleanValue()) {
                    new ResumeDelegateTasksCmd(taskId, "autoTransfer").execute(commandContext);
                } else {
                    new ResumeDelegateTasksCmd(taskId).execute(commandContext);
                }
                this.tasksTransferEventParams.setTaskId(taskId);
                this.tasksTransferEventParams.setOwnerId(ownerids);
                this.tasksTransferEventParams.setBusinessKey(task.getBusinessKey());
                this.tasksTransferEventParams.setBillNo(task.getBillNo());
                this.tasksTransferEventParams.setEntityNumber(task.getEntityNumber());
                this.saveTransfererInfo(commandContext, entity, task);
                this.dealWithToDoInfo(commandContext, taskId);
                ArrayList<Long> transferIds = new ArrayList<Long>();
                transferIds.add(this.transfererId);
                new TaskTransferDealWithSameUserCmd(taskId, transferIds).execute(commandContext);
                BPMNUtil.updateHitaskInstPresentAssignee(task.getExecution(), null);
                WfUtils.addOpLog("wf_task", "taskTransfer", new MultiLangEnumBridge("\u5f85\u529e\u4efb\u52a1\u8f6c\u4ea4", "TaskTransferCmd_19", "bos-wf-engine"), new MultiLangEnumBridge("\u5c06\u5f85\u529e\u4efb\u52a1[%1$s]\u4ece%2$s%3$s\u7ed9[%4$s]", "TaskTransferCmd_2", "bos-wf-engine"), taskId, WfUtils.listToString(ownerids, ","), WfConfigurationUtil.getTransferName(), this.transfererId);
            }
        } else {
            throw new WFTaskException(WFErrorCode.participantExistForTransferError());
        }
        return null;
    }

    private boolean validateCanTransfer(CommandContext commandContext) {
        if (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null && WfUtils.isNotEmpty(this.ownerId) && WfUtils.isNotEmpty(this.transfererId)) {
            QFilter taskFilter = new QFilter("taskId", "=", (Object)this.taskId);
            QFilter typeFilter = new QFilter("type", "=", (Object)"transfer");
            QFilter ownerFilter = new QFilter("ownerId", "=", (Object)this.ownerId);
            QFilter transferFilter = new QFilter("assigneeid", "=", (Object)this.transfererId);
            QFilter[] filters = new QFilter[]{taskFilter, typeFilter, ownerFilter, transferFilter};
            List handleLogs = commandContext.getTaskHandleLogEntityManager().findByQueryFilters(filters, "id,taskId", null);
            if (handleLogs != null && !handleLogs.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private TaskHandleLogEntity getTaskHandleLogEntity(CommandContext commandContext, TaskEntity task) {
        TaskHandleLogEntityImpl taskHandleLogEntity = new TaskHandleLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        taskHandleLogEntity.setAssigneeid(this.transfererId);
        taskHandleLogEntity.setAssignee(WfUtils.findUserName(this.transfererId));
        taskHandleLogEntity.setOwnerId(this.ownerId);
        taskHandleLogEntity.setOwnerFormat(ParticipantHelper.getParticipantDisplayInfo(task, Collections.singletonList(this.ownerId)).get(this.ownerId));
        taskHandleLogEntity.setAssigneeFormat(ParticipantHelper.getParticipantDisplayInfo(task, Collections.singletonList(this.transfererId)).get(this.transfererId));
        taskHandleLogEntity.setCreateDate(date);
        taskHandleLogEntity.setModifyDate(date);
        taskHandleLogEntity.setType("transfer");
        taskHandleLogEntity.setTaskId(task.getId());
        List<IdentityLinkEntity> participants = commandContext.getIdentityLinkEntityManager().findIdentityLinkByTaskUserAndType(this.taskId, this.ownerId, "participant");
        if (participants != null && !participants.isEmpty()) {
            IdentityLinkEntity participant = participants.get(0);
            taskHandleLogEntity.setDelegateId(participant.getDelegateId());
        }
        if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
            taskHandleLogEntity.setOpinion(this.transferOpinion);
        }
        taskHandleLogEntity.setSubscribe(this.transferSubscribe);
        taskHandleLogEntity.setProcessDefinitionId(task.getProcessDefinitionId());
        taskHandleLogEntity.setProcessInstanceId(task.getProcessInstanceId());
        taskHandleLogEntity.setBusinessKey(task.getBusinessKey());
        taskHandleLogEntity.setBillNo(task.getBillNo());
        taskHandleLogEntity.setActivityId(task.getTaskDefinitionKey());
        taskHandleLogEntity.setActivityName(task.getName());
        if (this.isAutoTransfer.booleanValue()) {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u7cfb\u7edf\u81ea\u52a8\u8f6c\u4ea4", "TaskTransferCmd_18", "bos-wf-engine"));
        }
        return taskHandleLogEntity;
    }

    private void dispatchTransferEvent(TaskHandleLogEntity entity) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled() && entity != null) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_TRANSFER, entity));
        }
    }

    private void dealWithToDoInfo(CommandContext commandContext, Long taskId) {
        if (!this.isAutoTransfer.booleanValue()) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(this.ownerId);
            commandContext.getMessageService().deleteToDo(taskId, userIds, false, true);
        }
        ArrayList<Long> transfererIds = new ArrayList<Long>();
        transfererIds.add(this.transfererId);
        commandContext.getMessageService().createTransferToDo(taskId, transfererIds);
    }

    private TaskHandleLogEntity saveTransfererInfo(CommandContext commandContext, TaskHandleLogEntity taskHandleLogEntity, final TaskEntity task) {
        String type = "participant";
        Long taskId = task.getId();
        new TaskTransferDealWithCoordinateCmd(taskId, this.transfererId.toString()).execute(commandContext);
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        taskHandleLogEntityManager.insert(taskHandleLogEntity);
        WfOperationLogUtil.recordOperationLogFromTaskHandle(commandContext, taskHandleLogEntity, null, null);
        Integer priority = 0;
        Object level = null;
        if (WfUtils.isNotEmptyForMap(this.dynInfo)) {
            level = this.dynInfo.get("priority");
            priority = TaskHelper.getPriorityValueByTaskLevel(level, taskId);
        }
        this.saveTransfererInfoForUpdateHiIdentity(commandContext, type, taskId);
        this.saveTransfererInfoForUpdateIdentity(commandContext, type, taskId);
        if (WfUtils.isNotEmptyString(priority) && 0 != priority && WfUtils.isNotEmptyString(level)) {
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, level.toString());
        }
        ArrayList<Long> transfererIds = new ArrayList<Long>();
        transfererIds.add(this.transfererId);
        commandContext.getHistoryManager().recordTaskParticipant(taskHandleLogEntity.getTaskId(), this.ownerId, transfererIds);
        if (!this.isAutoTransfer.booleanValue()) {
            commandContext.getTaskEntityManager().updateYzjTaskMemberInfoVariables(commandContext, task, this.ownerId, this.transfererId);
        } else if ("YunzhijiaTask".equals(task.getCategory())) {
            commandContext.getTaskEntityManager().updateYzjTaskMemberInfoVariablesForAuto(commandContext, task, this.ownerId, this.transfererId);
        }
        TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, PASS);
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.ownerId, "priority");
        if (JobUtil.isInJobThread()) {
            Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)process.getFlowElement(task.getTaskDefinitionKey()), task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
        } else {
            final Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("withdraw-transfer"){

                @Override
                public void closed(CommandContext commandContext) {
                    commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)process.getFlowElement(task.getTaskDefinitionKey()), task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
                }
            });
        }
        return taskHandleLogEntity;
    }

    private void saveTransfererInfoForUpdateHiIdentity(CommandContext commandContext, String type, Long taskId) {
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> entity = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, this.ownerId, type);
        if (null == entity || entity.isEmpty()) {
            return;
        }
        HistoricIdentityLinkEntity historicIdentityLinkEntity = entity.get(0);
        if (null == historicIdentityLinkEntity.getOwnerId() || 0L == historicIdentityLinkEntity.getOwnerId()) {
            historicIdentityLinkEntity.setOwnerId(this.ownerId);
        }
        if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
            historicIdentityLinkEntity.setTransferOpinion(this.transferOpinion);
        }
        historicIdentityLinkEntity.setUserId(this.transfererId);
        historicIdentityLinkEntity.setUserName(WfUtils.findUserName(this.transfererId));
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId);
        historicIdentityLinkEntity.setUserNameFormatter(participantDisplayInfo);
        historicIdentityLinkEntity.setPriority(0);
        historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
        if (WfUtils.isNotEmpty(historicIdentityLinkEntity.getDelegateId())) {
            QFilter qFilter3;
            QFilter qFilter2;
            QFilter qFilter1;
            QFilter[] QFilters;
            List hiTrusts;
            List<HistoricIdentityLinkEntity> delegationEntitys = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, historicIdentityLinkEntity.getOwnerId(), type);
            if (delegationEntitys != null && !delegationEntitys.isEmpty() && (hiTrusts = historicIdentityLinkEntityManager.findByQueryFilters(QFilters = new QFilter[]{qFilter1 = new QFilter("taskid", "=", (Object)taskId), qFilter2 = new QFilter("ownerid", "=", (Object)historicIdentityLinkEntity.getOwnerId()), qFilter3 = new QFilter("type", "=", (Object)"participant")})) != null && !hiTrusts.isEmpty()) {
                ArrayList<ILocaleString> names = new ArrayList<ILocaleString>(hiTrusts.size());
                ArrayList<ILocaleString> formats = new ArrayList<ILocaleString>(hiTrusts.size());
                for (HistoricIdentityLinkEntity hiTrust : hiTrusts) {
                    names.add(hiTrust.getUserName());
                    formats.add(hiTrust.getUserNameFormatter());
                }
                HistoricIdentityLinkEntity delegationEntity = delegationEntitys.get(0);
                if (delegationEntity != null && WfUtils.isNotEmpty(delegationEntity.getUserId()) && delegationEntity.getUserId().equals(historicIdentityLinkEntity.getOwnerId())) {
                    delegationEntity.setTrustName(WfMultiLangUtils.jointCollectionLocaleString(names, "\uff0c"));
                    delegationEntity.setTrustNameFormat(WfMultiLangUtils.jointCollectionLocaleString(formats, "\uff0c"));
                    historicIdentityLinkEntityManager.update(delegationEntity);
                }
            }
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, "delegate", null);
        }
    }

    private void saveTransfererInfoForUpdateIdentity(CommandContext commandContext, String type, Long taskId) {
        List<IdentityLinkEntity> coIdentityLinkEntities;
        List<IdentityLinkEntity> trusts;
        List<IdentityLinkEntity> delegationEntitys;
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, this.ownerId, type);
        if (null == identityLinkEntitys || identityLinkEntitys.isEmpty()) {
            return;
        }
        IdentityLinkEntity identityLinkEntity = identityLinkEntitys.get(0);
        if (null == identityLinkEntity.getOwnerId() || 0L == identityLinkEntity.getOwnerId()) {
            identityLinkEntity.setOwnerId(this.ownerId);
        }
        if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
            identityLinkEntity.setTransferOpinion(this.transferOpinion);
        }
        identityLinkEntity.setUserId(this.transfererId);
        identityLinkEntity.setUserName(WfUtils.findUserName(this.transfererId));
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId);
        identityLinkEntity.setUserNameFormatter(participantDisplayInfo);
        identityLinkEntity.setPriority(0);
        identityLinkEntity.setCreateDate(WfUtils.now());
        identityLinkEntityManager.update(identityLinkEntity);
        if (WfUtils.isNotEmpty(identityLinkEntity.getDelegateId()) && (delegationEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, identityLinkEntity.getOwnerId(), type)) != null && !delegationEntitys.isEmpty() && (trusts = identityLinkEntityManager.findDelegateIdentityLinkByTaskOwnerAndType(taskId, identityLinkEntity.getOwnerId(), "participant")) != null && !trusts.isEmpty()) {
            ArrayList<ILocaleString> names = new ArrayList<ILocaleString>(trusts.size());
            ArrayList<ILocaleString> formats = new ArrayList<ILocaleString>(trusts.size());
            for (IdentityLinkEntity trust : trusts) {
                names.add(trust.getUserName());
                formats.add(trust.getUserNameFormatter());
            }
            IdentityLinkEntity delegationEntity = delegationEntitys.get(0);
            if (delegationEntity != null && WfUtils.isNotEmpty(delegationEntity.getUserId()) && delegationEntity.getUserId().equals(identityLinkEntity.getOwnerId())) {
                delegationEntity.setTrustName(WfMultiLangUtils.jointCollectionLocaleString(names, "\uff0c"));
                delegationEntity.setTrustNameFormat(WfMultiLangUtils.jointCollectionLocaleString(formats, "\uff0c"));
                identityLinkEntityManager.update(delegationEntity);
            }
        }
        if ((coIdentityLinkEntities = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, this.transfererId, "coordinate")) != null && !coIdentityLinkEntities.isEmpty()) {
            RuleTaskRelationEntityManager ruleMgr = commandContext.getRuleTaskRelationEntityManager();
            for (IdentityLinkEntity coIdentityLinkEntity : coIdentityLinkEntities) {
                identityLinkEntityManager.delete(coIdentityLinkEntity);
                ruleMgr.deleteEntitiesByTaskIdAndTypeAndUserId(taskId, "coordinate", this.transfererId.toString());
            }
        }
    }
}

