/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import org.apache.commons.lang.StringUtils;

public class TaskTransferDealWithCoordinateCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private Boolean isAdministrator = Boolean.FALSE;
    private String transfererId;
    private static final String USERID = "userid";
    private static final String OWNERID = "ownerid";
    private static final String TASKIDSTR = "taskid";

    public TaskTransferDealWithCoordinateCmd(Long taskId, String transfererId, Boolean isAdministrator) {
        this.taskId = taskId;
        this.transfererId = transfererId;
        this.isAdministrator = isAdministrator;
    }

    public TaskTransferDealWithCoordinateCmd(Long taskId, String transfererId) {
        this.taskId = taskId;
        this.transfererId = transfererId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        TaskEntity taskInfo;
        List<Long> userIds = this.getUndealCoordinateParticipants(commandContext);
        if (!userIds.isEmpty()) {
            this.deleteCoordinateInfo(commandContext, userIds);
        }
        if (WfUtils.isNotEmpty((taskInfo = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId)).getParentTaskId()) && WfUtils.isNotEmpty(this.transfererId)) {
            String[] transferIdsArray = this.transfererId.split(",");
            ArrayList<Long> transferIds = new ArrayList<Long>(transferIdsArray.length);
            for (String transferId : transferIdsArray) {
                transferIds.add(Long.valueOf(transferId));
            }
            QFilter q1 = new QFilter(USERID, "in", transferIds);
            QFilter q2 = new QFilter("type", "=", (Object)"coordinate");
            QFilter q3 = new QFilter(OWNERID, "=", (Object)1);
            QFilter q4 = new QFilter(TASKIDSTR, "=", (Object)taskInfo.getParentTaskId());
            List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{q1, q2, q3, q4});
            if (CollectionUtil.isNotEmpty(identityLinkEntities)) {
                ArrayList<Long> userId1 = new ArrayList<Long>();
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    if (userId1.contains(identityLinkEntity.getUserId())) continue;
                    userId1.add(identityLinkEntity.getUserId());
                }
                this.taskId = taskInfo.getParentTaskId();
                this.deleteCoordinateInfo(commandContext, userId1);
            }
        }
        if (this.isAdministrator.booleanValue()) {
            this.deleteDealCoordinateRecords(commandContext);
            this.deleteParticiCoorTaskRelation(commandContext);
        }
        return null;
    }

    private void deleteParticiCoorTaskRelation(CommandContext commandContext) {
        ArrayList<Long> transferers = new ArrayList<Long>();
        String[] split = StringUtils.split((String)this.transfererId, (String)",");
        if (split != null && split.length > 0) {
            for (int i = 0; i < split.length; ++i) {
                transferers.add(Long.valueOf(split[i]));
            }
        }
        this.deleteRuleTaskRelation(commandContext, transferers, this.taskId);
    }

    private void deleteCoordinateInfo(CommandContext commandContext, List<Long> userIds) {
        this.deleteUndealCoordinateParticipant(commandContext, userIds, this.taskId);
        this.deleteCoordinateMessage(commandContext, userIds, this.taskId);
        this.deleteRuleTaskRelation(commandContext, userIds, this.taskId);
    }

    private void deleteDealCoordinateRecords(CommandContext commandContext) {
        QFilter q1 = new QFilter(TASKIDSTR, "=", (Object)this.taskId);
        QFilter q2 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q3 = new QFilter(OWNERID, "!=", (Object)1);
        commandContext.getCommentEntityManager().deleteByFilters(new QFilter[]{q1, q2, q3});
        commandContext.getHistoricIdentityLinkEntityManager().deleteByFilters(new QFilter[]{q1, q2, q3});
    }

    private void deleteCoordinateMessage(CommandContext commandContext, List<Long> userIds, Long taskId2) {
        commandContext.getMessageService().deleteToDo(taskId2, userIds, false, true);
    }

    private void deleteRuleTaskRelation(CommandContext commandContext, List<Long> userIds, Long taskId2) {
        QFilter q1 = new QFilter(TASKIDSTR, "=", (Object)taskId2);
        QFilter q2 = new QFilter("ruletype", "=", (Object)"coordinate");
        QFilter q3 = new QFilter(USERID, "in", userIds);
        commandContext.getRuleTaskRelationEntityManager().deleteByFilters(new QFilter[]{q1, q2, q3});
    }

    private void deleteUndealCoordinateParticipant(CommandContext commandContext, List<Long> userIds, Long taskId2) {
        QFilter q1 = new QFilter(TASKIDSTR, "=", (Object)taskId2);
        QFilter q2 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q4 = new QFilter(USERID, "in", userIds);
        commandContext.getIdentityLinkEntityManager().deleteByFilters(new QFilter[]{q1, q2, q4});
        QFilter q3 = new QFilter("endtime", "is null", (Object)Boolean.TRUE);
        commandContext.getHistoricIdentityLinkEntityManager().deleteByFilters(new QFilter[]{q1, q2, q3, q4});
    }

    private List<Long> getUndealCoordinateParticipants(CommandContext commandContext) {
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskId(this.taskId);
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        if (CollectionUtil.isNotEmpty(identityLinks)) {
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (!"coordinate".equals(identityLink.getType()) || userIds.contains(identityLink.getUserId()) || (this.transfererId == null || !this.transfererId.equals(identityLink.getUserId().toString())) && WfConstanst.ADMIN.equals(identityLink.getOwnerId())) continue;
                userIds.add(identityLink.getUserId());
            }
        }
        return userIds;
    }
}

