/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.AllTasksAllowTransferCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithCoordinateCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithSameUserCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.TasksTransferEventParams;

public class TasksTransferCmd
implements Command<Map<String, String>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> taskIds;
    private Long transfererId;
    private ILocaleString transferOpinion;
    private Boolean transferSubscribe;
    private Long ownerId;
    private static final String PASS = "pass";
    public static final String ISMUTILLEVELTRANSFER = "isMultiLevelTransfer";
    private List<TasksTransferEventParams> tasksTransferEventParams = new ArrayList<TasksTransferEventParams>();
    private Log logger = LogFactory.getLog(this.getClass());

    public TasksTransferCmd(List<Long> taskIds, Long transfererId, ILocaleString transferOpinion, Boolean transferSubscribe, Long ownerId) {
        this.taskIds = taskIds;
        this.transfererId = transfererId;
        this.transferOpinion = transferOpinion;
        this.transferSubscribe = transferSubscribe;
        this.ownerId = ownerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        if (null == this.taskIds || TaskUtils.handledRequest("TasksTransferCmd", WfUtils.listToString(this.taskIds, ","))) {
            return null;
        }
        StringBuilder resultsb = new StringBuilder();
        ArrayList<String> failList = new ArrayList<String>();
        HashMap<String, String> results = new HashMap<String, String>();
        int success = 0;
        int fail = 0;
        boolean isAllowTransfer = new AllTasksAllowTransferCmd(this.taskIds).execute(commandContext);
        if (!isAllowTransfer) {
            fail = this.taskIds.size();
            String s = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8f6c\u4ea4\u4efb\u52a1", (String)"TasksTransferCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            failList.add(s);
            resultsb.append(s);
        } else {
            try {
                Long delegateId = 0L;
                List<IdentityLinkEntity> participants = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskIds((Long[])this.taskIds.stream().toArray(Long[]::new));
                HashMap<Long, Long> taskAndDelegateMap = new HashMap<Long, Long>(participants.size());
                for (IdentityLinkEntity participant : participants) {
                    if (!this.ownerId.equals(participant.getUserId()) || !"participant".equals(participant.getType())) continue;
                    taskAndDelegateMap.put(participant.getTaskId(), participant.getDelegateId());
                }
                for (Long taskId : this.taskIds) {
                    String result = this.transferTasks(commandContext, taskId, taskAndDelegateMap);
                    if ("OK".equals(result) && TaskHelper.isComposeTask(taskId)) {
                        List<Long> composedTaskIds = commandContext.getTaskEntityManager().findComposedTaskIdsByCompositeTaskIdAndUserId(taskId, this.ownerId);
                        for (Long composedTaskId : composedTaskIds) {
                            result = this.transferTasks(commandContext, composedTaskId, taskAndDelegateMap);
                        }
                    }
                    if ("OK".equalsIgnoreCase(result)) {
                        ++success;
                        continue;
                    }
                    ++fail;
                    failList.add(result);
                    resultsb.append(result).append("\r\n");
                    this.logger.debug("\u6279\u91cf\u8f6c\u4ea4\u63d0\u793aresult" + result);
                    this.logger.debug("\u6279\u91cf\u8f6c\u4ea4\u63d0\u793a" + resultsb);
                }
                this.updateHiTaskPresentAssignee(commandContext);
                if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                    HashMap<String, Object> eventMap = new HashMap<String, Object>();
                    eventMap.put("tasksTransferEventParams", this.tasksTransferEventParams);
                    eventMap.put("transferOpinion", this.transferOpinion);
                    eventMap.put("transferId", this.transfererId);
                    eventMap.put("transferType", "OrdinaryTransfer");
                    new EventTriggerCmd(TaskEventTypeEnum.TASK_TRANSFER_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
                }
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace(e));
            }
            finally {
                if (null != this.taskIds) {
                    TaskUtils.removeHandledRequest("TasksTransferCmd", WfUtils.listToString(this.taskIds, ","));
                }
            }
        }
        String title = String.format(ResManager.loadKDString((String)"\u5171\u201c%1$s\u201d%2$s\u6761\u4efb\u52a1\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"TasksTransferCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName(), null == this.taskIds ? 0 : this.taskIds.size(), success, fail);
        StringBuilder details = new StringBuilder();
        if (resultsb.length() > 0) {
            details.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0:\r\n", (String)"TasksTransferCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)resultsb);
        }
        results.put("successCount", success + "");
        results.put("failCount", fail + "");
        results.put("title", title);
        results.put("details", details.toString());
        results.put("handleName", WfConfigurationUtil.getTransferName());
        String failListStr = Joiner.on((String)"#").join(failList);
        results.put("failList", failListStr);
        return results;
    }

    private void updateHiTaskPresentAssignee(CommandContext commandContext) {
        HashMap execIdParam = new HashMap();
        for (int i = 0; i < this.taskIds.size(); ++i) {
            Long taskId = this.taskIds.get(i);
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            Long executionId = task.getProcessInstanceId();
            if (execIdParam.get(executionId) != null) {
                ((Map)execIdParam.get(executionId)).put(String.valueOf(taskId), taskId);
                ((Map)execIdParam.get(executionId)).put("execution", task.getExecution());
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(String.valueOf(taskId), taskId);
            map.put("execution", task.getExecution());
            execIdParam.put(executionId, map);
        }
        for (Map.Entry entry : execIdParam.entrySet()) {
            BPMNUtil.updateHitaskInstPresentAssignee((ExecutionEntity)((Map)entry.getValue()).get("execution"), (Map)entry.getValue());
        }
    }

    private String transferTasks(CommandContext commandContext, Long taskId, Map<Long, Long> taskAndDelegateMap) {
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (null != taskEntity) {
            String billNo = this.getBillNoByTaskId(commandContext, taskId);
            List<Long> ownerids = TaskUtils.getParticipantIdsByTaskId(taskId);
            if (null == ownerids) {
                return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u53ef\u80fd\u5df2\u5904\u7406\u5b8c\u6210\u3002", (String)"TasksTransferCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), billNo);
            }
            if (ownerids.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%s]\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba\u4e3a\u7a7a\u3002", (String)"TasksTransferCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), billNo);
            }
            if (ownerids.contains(this.transfererId)) {
                return String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u201c%2$s\u201d\uff0c\u6240\u9009\u4eba\u5458\u5df2\u7ecf\u662f\u4efb\u52a1\u201c%1$s\u201d\u7684\u53c2\u4e0e\u4eba\u3002", (String)"TasksTransferCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), billNo, WfConfigurationUtil.getTransferName());
            }
            TasksTransferEventParams tasksTransferEventParam = new TasksTransferEventParams();
            tasksTransferEventParam.setTaskId(taskId);
            tasksTransferEventParam.setOwnerId(ownerids);
            tasksTransferEventParam.setBusinessKey(taskEntity.getBusinessKey());
            tasksTransferEventParam.setBillNo(taskEntity.getBillNo());
            tasksTransferEventParam.setEntityNumber(taskEntity.getEntityNumber());
            this.tasksTransferEventParams.add(tasksTransferEventParam);
            TaskHandleLogEntity entity = this.getTaskHandleLogEntity(commandContext, taskEntity, taskAndDelegateMap);
            this.dispatchTransferEvent(entity);
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            taskHelper.gatherAsyncCompensationData(taskEntity);
            new ResumeDelegateTasksCmd(taskId).execute(commandContext);
            this.saveTransfererInfo(commandContext, entity, taskId, taskEntity);
            this.dealWithToDoInfo(commandContext, taskId);
        }
        return "OK";
    }

    private String getBillNoByTaskId(CommandContext commandContext, Long taskId) {
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        String billNo = taskEntity.getBillNo();
        return billNo;
    }

    private TaskHandleLogEntity getTaskHandleLogEntity(CommandContext commandContext, TaskEntity taskEntity, Map<Long, Long> taskAndDelegateMap) {
        TaskHandleLogEntityImpl taskHandleLogEntity = new TaskHandleLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        taskHandleLogEntity.setAssigneeid(this.transfererId);
        taskHandleLogEntity.setAssignee(WfUtils.findUserName(this.transfererId));
        taskHandleLogEntity.setOwnerId(this.ownerId);
        taskHandleLogEntity.setOwner(WfUtils.findUserName(this.ownerId));
        taskHandleLogEntity.setOwnerFormat(ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.ownerId)).get(this.ownerId));
        taskHandleLogEntity.setAssigneeFormat(ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId));
        taskHandleLogEntity.setCreateDate(date);
        taskHandleLogEntity.setModifyDate(date);
        taskHandleLogEntity.setType("transfer");
        taskHandleLogEntity.setTaskId(taskEntity.getId());
        taskHandleLogEntity.setDelegateId(taskAndDelegateMap.get(taskEntity.getId()));
        if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
            taskHandleLogEntity.setOpinion(this.transferOpinion);
        }
        taskHandleLogEntity.setSubscribe(this.transferSubscribe);
        taskHandleLogEntity.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        taskHandleLogEntity.setProcessInstanceId(taskEntity.getProcessInstanceId());
        taskHandleLogEntity.setBusinessKey(taskEntity.getBusinessKey());
        taskHandleLogEntity.setBillNo(taskEntity.getBillNo());
        taskHandleLogEntity.setActivityId(taskEntity.getTaskDefinitionKey());
        taskHandleLogEntity.setActivityName(taskEntity.getName());
        return taskHandleLogEntity;
    }

    private void dispatchTransferEvent(TaskHandleLogEntity entity) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled() && entity != null) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_TRANSFER, entity));
        }
    }

    private void dealWithToDoInfo(CommandContext commandContext, Long taskId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(this.ownerId);
        commandContext.getMessageService().deleteToDo(taskId, userIds);
        ArrayList<Long> transfererIds = new ArrayList<Long>();
        transfererIds.add(this.transfererId);
        commandContext.getMessageService().createTransferToDo(taskId, transfererIds);
    }

    private TaskHandleLogEntity saveTransfererInfo(CommandContext commandContext, TaskHandleLogEntity taskHandleLogEntity, Long taskId, final TaskEntity task) {
        String type = "participant";
        new TaskTransferDealWithCoordinateCmd(taskId, this.transfererId.toString()).execute(commandContext);
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        List taskHandleLogEntities = taskHandleLogEntityManager.findByQueryFilters(new QFilter[]{new QFilter("taskid", "=", (Object)taskId), new QFilter("type", "=", (Object)"transfer")});
        if (taskHandleLogEntities != null && taskHandleLogEntities.size() > 0) {
            LocalVariables localVariables = LocalVariables.getOrCreate();
            localVariables.putParams(ISMUTILLEVELTRANSFER, "true");
        }
        taskHandleLogEntityManager.insert(taskHandleLogEntity);
        WfOperationLogUtil.recordOperationLogFromTaskHandle(commandContext, taskHandleLogEntity, null, null);
        this.saveTransfererInfoForUpdateHiIdentity(commandContext, type, taskId);
        this.saveTransfererInfoForUpdateIdentity(commandContext, type, taskId);
        ArrayList<Long> transfererIds = new ArrayList<Long>();
        transfererIds.add(this.transfererId);
        commandContext.getHistoryManager().recordTaskParticipant(taskHandleLogEntity.getTaskId(), this.ownerId, transfererIds);
        commandContext.getTaskEntityManager().updateYzjTaskMemberInfoVariables(commandContext, task, this.ownerId, this.transfererId);
        TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, PASS);
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.ownerId, "folder");
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.ownerId, "priority");
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, "coordinate");
        ArrayList<Long> transferIds = new ArrayList<Long>();
        transferIds.add(this.transfererId);
        new TaskTransferDealWithSameUserCmd(taskId, transferIds).execute(commandContext);
        if (JobUtil.isInJobThread()) {
            Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)process.getFlowElement(task.getTaskDefinitionKey()), task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
        } else {
            final Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("withdraw-transfer"){

                @Override
                public void closed(CommandContext commandContext) {
                    commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)process.getFlowElement(task.getTaskDefinitionKey()), task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
                }
            });
        }
        return taskHandleLogEntity;
    }

    private void saveTransfererInfoForUpdateHiIdentity(CommandContext commandContext, String type, Long taskId) {
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> entity = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, this.ownerId, type);
        HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)commandContext.getHistoricIdentityLinkEntityManager().create();
        if (entity != null && !entity.isEmpty()) {
            historicIdentityLinkEntity = entity.get(0);
            if (null == historicIdentityLinkEntity.getOwnerId() || 0L == historicIdentityLinkEntity.getOwnerId()) {
                historicIdentityLinkEntity.setOwnerId(this.ownerId);
            }
            if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
                historicIdentityLinkEntity.setTransferOpinion(this.transferOpinion);
            }
            historicIdentityLinkEntity.setUserId(this.transfererId);
            TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId);
            historicIdentityLinkEntity.setUserNameFormatter(participantDisplayInfo);
            historicIdentityLinkEntity.setUserName(WfUtils.findUserName(this.transfererId));
            historicIdentityLinkEntity.setReadTime(null);
            historicIdentityLinkEntity.setPriority(0);
            historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
            if (WfUtils.isNotEmpty(historicIdentityLinkEntity.getDelegateId())) {
                QFilter qFilter3;
                QFilter qFilter2;
                QFilter qFilter1;
                QFilter[] QFilters;
                List hiTrusts;
                List<HistoricIdentityLinkEntity> delegationEntitys = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, historicIdentityLinkEntity.getOwnerId(), type);
                if (delegationEntitys != null && !delegationEntitys.isEmpty() && (hiTrusts = historicIdentityLinkEntityManager.findByQueryFilters(QFilters = new QFilter[]{qFilter1 = new QFilter("taskid", "=", (Object)taskId), qFilter2 = new QFilter("ownerid", "=", (Object)historicIdentityLinkEntity.getOwnerId()), qFilter3 = new QFilter("type", "=", (Object)"participant")})) != null && !hiTrusts.isEmpty()) {
                    ArrayList<ILocaleString> names = new ArrayList<ILocaleString>(hiTrusts.size());
                    ArrayList<ILocaleString> formats = new ArrayList<ILocaleString>(hiTrusts.size());
                    for (HistoricIdentityLinkEntity hiTrust : hiTrusts) {
                        names.add(hiTrust.getUserName());
                        formats.add(hiTrust.getUserNameFormatter());
                    }
                    HistoricIdentityLinkEntity delegationEntity = delegationEntitys.get(0);
                    if (delegationEntity != null && WfUtils.isNotEmpty(delegationEntity.getUserId()) && delegationEntity.getUserId().equals(historicIdentityLinkEntity.getOwnerId())) {
                        delegationEntity.setTrustName(WfMultiLangUtils.jointCollectionLocaleString(names, "\uff0c"));
                        delegationEntity.setTrustNameFormat(WfMultiLangUtils.jointCollectionLocaleString(formats, "\uff0c"));
                        historicIdentityLinkEntityManager.update(delegationEntity);
                    }
                }
                TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, "delegate", null);
            }
        }
    }

    private void saveTransfererInfoForUpdateIdentity(CommandContext commandContext, String type, Long taskId) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, this.ownerId, type);
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntityImpl();
        if (identityLinkEntitys != null && !identityLinkEntitys.isEmpty()) {
            List<IdentityLinkEntity> coIdentityLinkEntities;
            List<IdentityLinkEntity> trusts;
            List<IdentityLinkEntity> delegationEntitys;
            identityLinkEntity = identityLinkEntitys.get(0);
            if (null == identityLinkEntity.getOwnerId() || 0L == identityLinkEntity.getOwnerId()) {
                identityLinkEntity.setOwnerId(this.ownerId);
            }
            if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
                identityLinkEntity.setTransferOpinion(this.transferOpinion);
            }
            identityLinkEntity.setUserId(this.transfererId);
            identityLinkEntity.setCreateDate(WfUtils.now());
            identityLinkEntity.setUserName(WfUtils.findUserName(this.transfererId));
            TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId);
            identityLinkEntity.setUserNameFormatter(participantDisplayInfo);
            identityLinkEntity.setReadTime(null);
            identityLinkEntity.setPriority(0);
            identityLinkEntityManager.update(identityLinkEntity);
            if (WfUtils.isNotEmpty(identityLinkEntity.getDelegateId()) && (delegationEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, identityLinkEntity.getOwnerId(), type)) != null && !delegationEntitys.isEmpty() && (trusts = identityLinkEntityManager.findDelegateIdentityLinkByTaskOwnerAndType(taskId, identityLinkEntity.getOwnerId(), "participant")) != null && !trusts.isEmpty()) {
                ArrayList<ILocaleString> names = new ArrayList<ILocaleString>(trusts.size());
                ArrayList<ILocaleString> formats = new ArrayList<ILocaleString>(trusts.size());
                for (IdentityLinkEntity trust : trusts) {
                    names.add(trust.getUserName());
                    formats.add(trust.getUserNameFormatter());
                }
                IdentityLinkEntity delegationEntity = delegationEntitys.get(0);
                if (delegationEntity != null && WfUtils.isNotEmpty(delegationEntity.getUserId()) && delegationEntity.getUserId().equals(identityLinkEntity.getOwnerId())) {
                    delegationEntity.setTrustName(WfMultiLangUtils.jointCollectionLocaleString(names, "\uff0c"));
                    delegationEntity.setTrustNameFormat(WfMultiLangUtils.jointCollectionLocaleString(formats, "\uff0c"));
                    identityLinkEntityManager.update(delegationEntity);
                }
            }
            if ((coIdentityLinkEntities = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, this.transfererId, "coordinate")) != null && !coIdentityLinkEntities.isEmpty()) {
                RuleTaskRelationEntityManager ruleMgr = commandContext.getRuleTaskRelationEntityManager();
                for (IdentityLinkEntity coIdentityLinkEntity : coIdentityLinkEntities) {
                    identityLinkEntityManager.delete(coIdentityLinkEntity);
                    ruleMgr.deleteEntitiesByTaskIdAndTypeAndUserId(taskId, "coordinate", this.transfererId.toString());
                }
            }
        }
    }
}

