/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.UnusualApprovalRecordInterface;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RPAUtil;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public enum UnusualApprovalRecord implements UnusualApprovalRecordInterface
{
    CallActivity("CallActivity"){

        @Override
        public ApprovalRecordItem createCurrentApprovalRecord(HistoricActivityInstanceEntity historicActivityInstanceEntity) {
            CommandContext commandContext = Context.getCommandContext();
            ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
            approvalRecordItem.setActivityId(historicActivityInstanceEntity.getActivityId());
            approvalRecordItem.setProcDefId(String.valueOf(historicActivityInstanceEntity.getProcessDefinitionId()));
            Date time = historicActivityInstanceEntity.getCreateDate();
            if (time != null) {
                approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
                Date userZoneDate = WfUtils.getUserZoneDate(time);
                approvalRecordItem.setFormatTime(userZoneDate.getTime());
                approvalRecordItem.setFormatStrTime(new SimpleDateFormat(UnusualApprovalRecord.MMDDHHMM).format(userZoneDate));
            }
            approvalRecordItem.setResult(WFMultiLangConstants.getSSCStateName1());
            Long subProcessInstanceId = historicActivityInstanceEntity.getCalledProcessInstanceId();
            if (WfUtils.isNotEmpty(subProcessInstanceId)) {
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(subProcessInstanceId);
                approvalRecordItem.setMessage(bpmnModel.getMainProcess().getName());
                approvalRecordItem.setCallActivity(true);
                String activityId = historicActivityInstanceEntity.getActivityId();
                approvalRecordItem.setAddSignMsg(this.getAddSignMsg(historicActivityInstanceEntity.getProcessInstanceId(), activityId));
                approvalRecordItem.setHandleState("willApproval");
                approvalRecordItem.setNodeType(activityId);
                approvalRecordItem.setProcInstId(String.valueOf(subProcessInstanceId));
                approvalRecordItem.setActivityName(historicActivityInstanceEntity.getActivityName().getLocaleValue() + " ");
                ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(subProcessInstanceId);
                if (executionEntity != null) {
                    if ("2".equals(executionEntity.getSuspensionState())) {
                        approvalRecordItem.setResult(UnusualApprovalRecord.getState("suspended"));
                    } else {
                        approvalRecordItem.setDecisionType("wait");
                    }
                } else {
                    approvalRecordItem.setResult(UnusualApprovalRecord.getState("approved"));
                }
            } else {
                return null;
            }
            approvalRecordItem.setGroup(String.valueOf(subProcessInstanceId));
            return approvalRecordItem;
        }

        @Override
        @Deprecated
        public ApprovalRecordItem createHistoryApprovalRecord(Row row, Map<String, HistoricIdentityLinkEntity> delegateParticipantMap) {
            return null;
        }

        @Override
        public ApprovalRecordItem createHistoryApprovalRecord(CommentEntity comment, Map<String, HistoricIdentityLinkEntity> delegateParticipantMap) {
            Optional<CommentEntity> commentGetter = Optional.of(comment);
            String subProcessInstanceId = commentGetter.map(CommentEntity::getSubProcessInstanceId).orElseGet(() -> 0L).toString();
            if (WfUtils.isNotEmpty(subProcessInstanceId) && !"0".equals(subProcessInstanceId)) {
                ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(Long.valueOf(subProcessInstanceId));
                approvalRecordItem.setMessage(bpmnModel.getMainProcess().getName());
                approvalRecordItem.setCallActivity(true);
                approvalRecordItem.setProcInstId(subProcessInstanceId);
                approvalRecordItem.setActivityName(comment.getActivityName());
                approvalRecordItem.setGroup(subProcessInstanceId);
                String activityId = comment.getActivityId();
                String addSignMsg = this.getAddSignMsg(commentGetter.map(Comment::getProcessInstanceId).orElseGet(() -> 0L), activityId);
                approvalRecordItem.setAddSignMsg(addSignMsg);
                approvalRecordItem.setNodeType(activityId);
                approvalRecordItem.setActivityId(activityId);
                approvalRecordItem.setUserNameFormat(commentGetter.map(CommentEntity::getUserNameFormatter).orElseGet(LocaleString::new).toString());
                Date time = comment.getTime();
                if (time != null) {
                    approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
                    Date userZoneDate = WfUtils.getUserZoneDate(time);
                    approvalRecordItem.setFormatTime(userZoneDate.getTime());
                    approvalRecordItem.setFormatStrTime(new SimpleDateFormat(UnusualApprovalRecord.MMDDHHMM).format(userZoneDate));
                    approvalRecordItem.setResult(WFMultiLangConstants.getSSCStateName2());
                    approvalRecordItem.setDecisionType("approve");
                } else {
                    approvalRecordItem.setResult(WFMultiLangConstants.getDefaultStateName());
                }
                return approvalRecordItem;
            }
            return null;
        }

        private String getAddSignMsg(Long processInstanceId, String activityId) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(processInstanceId);
            CallActivity callActivity = (CallActivity)bpmnModel.getFlowElement(activityId);
            String addSignMsg = callActivity.getAddSignMsg() == null || callActivity.getAddSignMsg().isEmpty() ? "" : callActivity.getAddSignMsg().get(RequestContext.get().getLang().toString());
            return addSignMsg;
        }
    }
    ,
    RPATask("RPATask"){

        @Override
        public ApprovalRecordItem createCurrentApprovalRecord(HistoricActivityInstanceEntity historicActivityInstanceEntity) {
            ApprovalRecordItem item = new ApprovalRecordItem();
            item.setGroup(String.valueOf(historicActivityInstanceEntity.getId()));
            item.setActivityId(historicActivityInstanceEntity.getActivityId());
            item.setActivityName(historicActivityInstanceEntity.getActivityName().getLocaleValue());
            item.setProcDefId(String.valueOf(historicActivityInstanceEntity.getProcessDefinitionId()));
            item.setTime(WfUtils.parseToUserZoneDateString(historicActivityInstanceEntity.getCreateDate()));
            item.setMessage(RPAUtil.getSendStartRPAProcMsgText().getLocaleValue());
            item.setAvatar(RPAUtil.getRPAApprovalRecordAvatar());
            return item;
        }

        @Override
        @Deprecated
        public ApprovalRecordItem createHistoryApprovalRecord(Row row, Map<String, HistoricIdentityLinkEntity> delegateParticipantMap) {
            return null;
        }

        @Override
        public ApprovalRecordItem createHistoryApprovalRecord(CommentEntity comment, Map<String, HistoricIdentityLinkEntity> delegateParticipantMap) {
            String parentTaskId;
            Long userId;
            Optional<CommentEntity> commentGetter = Optional.of(comment);
            ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
            approvalRecordItem.setCommentId(String.valueOf(commentGetter.map(Comment::getId)));
            approvalRecordItem.setBizIdentifyKey(comment.getBizIdentifyKey());
            approvalRecordItem.setTaskId(commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L).toString());
            approvalRecordItem.setHandleState(comment.getHandleState());
            String richTextMessage = comment.getRichTextMessage();
            if (WfUtils.isNotEmpty(richTextMessage)) {
                approvalRecordItem.setMessage(richTextMessage);
            } else {
                approvalRecordItem.setMessage(comment.getMessage());
            }
            approvalRecordItem.setBusinessKey(comment.getBusinessKey());
            approvalRecordItem.setEntityNumber(comment.getEntityNumber());
            approvalRecordItem.setResult(" " + comment.getResultNumber());
            approvalRecordItem.setDecisionType(comment.getDecisionType());
            Date time = comment.getTime();
            if (time != null) {
                approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
                Date userZoneDate = WfUtils.getUserZoneDate(time);
                approvalRecordItem.setFormatTime(userZoneDate.getTime());
                approvalRecordItem.setFormatStrTime(new SimpleDateFormat(UnusualApprovalRecord.MMDDHHMM).format(userZoneDate));
            }
            approvalRecordItem.setActivityId(comment.getActivityId());
            approvalRecordItem.setActivityName(comment.getActivityName() + " ");
            approvalRecordItem.setSubactivityname(comment.getSubactivityname() + " ");
            Long ownerId = commentGetter.map(CommentEntity::getOwnerId).orElseGet(() -> 0L);
            if (WfUtils.isNotEmpty(ownerId) && ownerId > 0L) {
                approvalRecordItem.setOwnerId(ownerId);
            }
            if (WfUtils.isNotEmpty(userId = commentGetter.map(Comment::getUserId).orElseGet(() -> 0L)) && userId > 0L) {
                approvalRecordItem.setUserStr(userId + "");
                approvalRecordItem.setUserId(userId);
            } else {
                approvalRecordItem.setUserId(-1L);
            }
            approvalRecordItem.setUserId(userId);
            String userNameFormatter = commentGetter.map(CommentEntity::getUserNameFormatter).orElseGet(LocaleString::new).toString();
            approvalRecordItem.setUserNameFormat(userNameFormatter);
            String userName = ParticipantHelper.getUserName(comment.getAssignee(), userNameFormatter);
            ILocaleString assignorNameFormat = ParticipantHelper.getUserNameFormatByHiIdent(Context.getCommandContext(), ownerId, comment.getTaskId());
            String assignorName = ParticipantHelper.getUserName(comment.getAssignorName().toString(), assignorNameFormat.toString());
            if (!WfUtils.isEmpty(ownerId) && !WfUtils.isEmpty(assignorName)) {
                approvalRecordItem.setDelegate(true);
                userName = TaskDelegateUtil.getDelegateAssigneeName(assignorName, userName, "replace");
            }
            approvalRecordItem.setAssignee(userName);
            if ("submit".equals(comment.getResultNumber()) || "save".equals(comment.getResultNumber())) {
                approvalRecordItem.setGroupDecisionType("submit");
            }
            if (WfUtils.isEmpty(parentTaskId = comment.getGroupId()) || "0".equals(parentTaskId)) {
                approvalRecordItem.setGroup(String.valueOf(commentGetter.map(Comment::getId).orElseGet(() -> 0L)));
            } else {
                approvalRecordItem.setGroup(parentTaskId);
            }
            approvalRecordItem.setLinks(RPAUtil.createViewLogLink(parentTaskId));
            approvalRecordItem.setAvatar(RPAUtil.getRPAApprovalRecordAvatar());
            String actType = "";
            actType = comment instanceof ThirdCommentEntity ? comment.getActivityId() : comment.getCategory();
            approvalRecordItem.setNodeType(actType);
            approvalRecordItem.setTerminalWay(comment.getTerminalWay());
            return approvalRecordItem;
        }
    };

    public String type;
    private static final String MMDDHHMM = "MM/dd HH:mm";

    private UnusualApprovalRecord(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static List<String> getTypes() {
        UnusualApprovalRecord[] values = UnusualApprovalRecord.values();
        ArrayList<String> types = new ArrayList<String>(values.length);
        for (UnusualApprovalRecord value : values) {
            types.add(value.getType());
        }
        return types;
    }

    private static String getState(String state) {
        if ("dismissed".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ApprovalRecordCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("willApproval".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"ApprovalRecordCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("willHandled".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ApprovalRecordCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("freeze".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ApprovalRecordCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("approved".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ApprovalRecordCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("suspended".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ApprovalRecordCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("manualSuspended".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u624b\u52a8\u6302\u8d77", (String)"ApprovalRecordCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return state;
    }
}

