/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class UpdateHicommentsData
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<CommentEntity> hiComments;
    private int limitSize = 3000;

    public UpdateHicommentsData(List<CommentEntity> hiComments, int limitSize) {
        this.hiComments = hiComments;
        this.limitSize = limitSize;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.hiComments == null || this.hiComments.isEmpty()) {
            return null;
        }
        HashMap<String, List<Object[]>> langParamList = new HashMap<String, List<Object[]>>(this.hiComments.size());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(this.hiComments.size());
        this.buildSqlParams(this.hiComments, langParamList, paramsList);
        String hitaskSql = "update t_wf_hicomment set fbillno = ?, fentityname = ?, fsendernameformat = ?, fstarterid = ?, fpresentassignee = ?, fprocessingpage = ?, fprocessingmobilepage = ?, fhandlestate = ?, fcategory = ?, fsendername = ?, fcreatedate = ?, fexecutiontype = ?, fisdisplay = ?, fendtype = ?, fbilltype = ?, fstartname = ?, fstartnameformat = ?, fdelegateid = ?, fcurrentsubject = ? where fid = ?";
        WfUtils.executeBatch(hitaskSql, paramsList, this.limitSize);
        String hitaskGLSql = "update t_wf_hicomment_l  set fentityname = ?, fsendernameformat = ?, fpresentassignee = ?, fsendername = ?, fstartname = ?, fstartnameformat = ?, fcurrentsubject = ? where fid = ? and flocaleid = ?";
        for (Map.Entry entrySet : langParamList.entrySet()) {
            WfUtils.executeBatch(hitaskGLSql, (List)entrySet.getValue(), this.limitSize);
        }
        return null;
    }

    private void buildSqlParams(List<CommentEntity> hiComments, Map<String, List<Object[]>> langParamList, List<Object[]> paramsList) {
        hiComments.forEach(hiComment -> {
            ArrayList<Object> tempParamArr = new ArrayList<Object>(18);
            HashMap<String, List<Object>> tempLangParamArr = new HashMap<String, List<Object>>();
            tempParamArr.add(hiComment.getBillNo());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getEntityName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getSenderNameFormat());
            tempParamArr.add(hiComment.getStarterId());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getPresentAssignee());
            tempParamArr.add(hiComment.getProcessingPage());
            tempParamArr.add(hiComment.getProcessingMobilePage());
            tempParamArr.add(hiComment.getHandleState());
            tempParamArr.add(hiComment.getCategory());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getSenderName());
            tempParamArr.add(hiComment.getCreateDate());
            tempParamArr.add(hiComment.getExecutionType());
            tempParamArr.add(hiComment.isDisplay());
            tempParamArr.add(hiComment.getEndType());
            tempParamArr.add(hiComment.getBillType());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getStartName());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getStartNameFormat());
            tempParamArr.add(hiComment.getDelegateId());
            this.addLocaleStringField(tempParamArr, tempLangParamArr, hiComment.getCurrentSubject());
            tempParamArr.add(hiComment.getId());
            paramsList.add(tempParamArr.toArray());
            for (Map.Entry entry : tempLangParamArr.entrySet()) {
                List list = (List)entry.getValue();
                list.add(hiComment.getId());
                list.add(entry.getKey());
                if (list.size() != 9) continue;
                List<Object> langParam = langParamList.get(entry.getKey()) == null ? new ArrayList<Object[]>() : (List)langParamList.get(entry.getKey());
                langParam.add(list.toArray());
                langParamList.put((String)entry.getKey(), (List<Object[]>)langParam);
            }
        });
    }

    private void addLocaleStringField(List<Object> tempParamArr, Map<String, List<Object>> tempLangParamArr, ILocaleString ls) {
        if (WfUtils.isNotEmpty(ls)) {
            tempParamArr.add(ls.getLocaleValue() != null ? ls.getLocaleValue() : " ");
            for (Map.Entry entrySet : ls.entrySet()) {
                String key = (String)entrySet.getKey();
                List<Object> paramList = tempLangParamArr.get(key) != null ? tempLangParamArr.get(key) : new ArrayList();
                paramList.add(entrySet.getValue());
                tempLangParamArr.put(key, paramList);
            }
        } else {
            tempParamArr.add(" ");
            for (Map.Entry<String, List<Object>> entry : tempLangParamArr.entrySet()) {
                List<Object> paramList = entry.getValue();
                if (paramList == null) {
                    paramList = new ArrayList<Object>();
                }
                paramList.add(" ");
                tempLangParamArr.put(entry.getKey(), paramList);
            }
        }
    }
}

