/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TrdProcRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.util.RPAUtil;
import kd.bos.workflow.engine.task.Comment;

public class UpdateTrdRelatedProcComment
implements Command<Void> {
    private String relationValue;
    private Comment comment;
    private Log log = LogFactory.getLog(this.getClass());

    public UpdateTrdRelatedProcComment(String relationValue, Comment comment) {
        this.relationValue = relationValue;
        this.comment = comment;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.relationValue)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u201crelationValue\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateTrdRelatedProcComment_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (this.comment == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u201ccomment\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateTrdRelatedProcComment_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        List<TrdProcRelationEntity> relations = commandContext.getTrdProcRelationEntityManager().findTrdProcRelationByRelationValAndType(this.relationValue, "rpa");
        if (relations == null || relations.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u201crelationValue\u201d\uff1a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u6d41\u7a0b\u4fe1\u606f\u3002", (String)"UpdateTrdRelatedProcComment_3", (String)"bos-wf-engine", (Object[])new Object[0]), this.relationValue));
        }
        this.log.debug(String.format("UpdateRPACommentCmd--relationValue: %s, message: %s", this.relationValue, this.comment.getMessage()));
        TrdProcRelationEntity relation = relations.get(0);
        CommentEntityManager commentManager = commandContext.getCommentEntityManager();
        CommentEntity commentEntity = (CommentEntity)commentManager.findById(relation.getCommentId());
        if (WfUtils.isNotEmpty(this.comment.getTaskAssignee())) {
            commentEntity.setAssignee(this.comment.getTaskAssignee());
        }
        if (WfUtils.isNotEmpty(this.comment.getCommentResult())) {
            commentEntity.setResultName(this.comment.getCommentResult());
        }
        if (WfUtils.isNotEmpty(this.comment.getCommentMessage())) {
            commentEntity.setMessage(this.comment.getCommentMessage());
        }
        if (this.comment.getTime() != null) {
            commentEntity.setTime(this.comment.getTime());
        } else {
            commentEntity.setTime(WfUtils.now());
        }
        if (WfUtils.isNotEmpty(this.comment.getType())) {
            commentEntity.setType(this.comment.getType());
        }
        if (WfUtils.isNotEmpty(this.comment.getTerminalWay())) {
            commentEntity.setTerminalWay(this.comment.getTerminalWay());
        }
        commentManager.update(commentEntity);
        RPAUtil.recordOperationLog(commandContext, commentEntity);
        return null;
    }
}

