/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class UserTaskComplete
implements Command<Void> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long taskId = null;
    private String bkId = null;

    public UserTaskComplete(Long taskId, String bkId) {
        this.taskId = taskId;
        this.bkId = bkId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            return null;
        }
        if (WfUtils.isNotEmpty(this.bkId) && !this.bkId.equalsIgnoreCase(task.getBusinessKey())) {
            this.logger.debug(String.format("Task[%s] is not matching businesskey[%s].", this.taskId, this.bkId));
            return null;
        }
        commandContext.getMessageService().dealToDo(task, Long.parseLong(RequestContext.get().getUserId()), false, false, true);
        task.setDisplay(false);
        commandContext.getTaskEntityManager().update(task, false);
        return null;
    }
}

