/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.task.TaskCoordinateScene;
import kd.bos.workflow.exception.WFTaskException;

public class WithdrawTansferCoordinateTaskCmd
implements Command<Void> {
    private Long taskId;
    private Long ownerId;

    public WithdrawTansferCoordinateTaskCmd(Long taskId, Long ownerId) {
        this.taskId = taskId;
        this.ownerId = ownerId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        try {
            this.withdrawTansfer(commandContext, this.taskId, this.ownerId);
        }
        catch (Exception e) {
            ErrorCode errorCode = new ErrorCode("bos.wf.WithdrawTansferCoordinateTaskCmd", String.format(ResManager.loadKDString((String)"%s\u64a4\u56de\u5931\u8d25\u3002", (String)"WithdrawTansferCoordinateTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            throw new WFTaskException(e, errorCode, e.getMessage());
        }
        return null;
    }

    private void withdrawTansfer(CommandContext commandContext, Long taskId, Long ownerId) {
        this.saveOperationLog(commandContext, taskId);
        Long transferId = null;
        ArrayList<Long> deleteTaskHandleLogIds = new ArrayList<Long>();
        Boolean isFindRecord = Boolean.FALSE;
        List<TaskHandleLogEntity> entities = commandContext.getTaskHandleLogEntityManager().findEntitiesByTaskIdAndType(taskId, "transfer");
        int entitiesSize = entities.size();
        if (0 != entitiesSize) {
            for (TaskHandleLogEntity entity : entities) {
                if (!isFindRecord.booleanValue() && ownerId.equals(entity.getOwnerId())) {
                    isFindRecord = Boolean.TRUE;
                }
                if (!isFindRecord.booleanValue()) continue;
                deleteTaskHandleLogIds.add(entity.getId());
            }
            transferId = entities.get(entitiesSize - 1).getAssigneeid();
        }
        commandContext.getTaskHandleLogEntityManager().deleteEntitiesByTaskHandleLogIds(deleteTaskHandleLogIds);
        String participantType = "coordinate";
        boolean isCoordinator = CoordinateRecordUtil.isParticipant(taskId, RequestContext.get().getUserId(), "coordinate");
        if (isCoordinator) {
            HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager;
            List<HistoricIdentityLinkEntity> entity;
            IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
            List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, transferId, participantType);
            if (identityLinkEntitys != null && !identityLinkEntitys.isEmpty()) {
                identityLinkEntityManager.delete((Entity)identityLinkEntitys.get(0));
            }
            if ((entity = (historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager()).findHistoricIdentityLinksByTaskUserGroupAndType(taskId, transferId, participantType)) != null && !entity.isEmpty()) {
                historicIdentityLinkEntityManager.delete((Entity)entity.get(0));
            }
            return;
        }
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> ownerEntity = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, ownerId, participantType);
        ILocaleString transferOpinion = ownerEntity.get(0).getTransferOpinion();
        ILocaleString currenSubject = ownerEntity.get(0).getCurrenSubject();
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, transferId, participantType);
        IdentityLinkEntity identityLinkEntity = identityLinkEntitys.get(0);
        identityLinkEntity.setTransferOpinion(transferOpinion);
        identityLinkEntity.setUserId(ownerId);
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        ArrayList<Long> formatUserIds = new ArrayList<Long>();
        formatUserIds.add(ownerId);
        ILocaleString userNameFormatValue = ParticipantHelper.getUserNameFormatValue(taskEntity, formatUserIds);
        identityLinkEntity.setUserNameFormatter(userNameFormatValue);
        identityLinkEntity.setUserName(WfUtils.findUserName(ownerId));
        identityLinkEntity.setCurrentSubject(currenSubject);
        identityLinkEntityManager.update(identityLinkEntity);
        List<HistoricIdentityLinkEntity> entity = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, transferId, participantType);
        HistoricIdentityLinkEntity historicIdentityLinkEntity = entity.get(0);
        historicIdentityLinkEntity.setTransferOpinion(transferOpinion);
        historicIdentityLinkEntity.setUserId(ownerId);
        historicIdentityLinkEntity.setUserName(WfUtils.findUserName(ownerId));
        historicIdentityLinkEntity.setCurrenSubject(currenSubject);
        historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
        commandContext.getRuleTaskRelationEntityManager().deleteEntitiesByTaskIdAndTypeAndUserId(taskId, "coordinate", String.valueOf(transferId));
        this.dispatchTaskCoordinateListener(taskEntity, transferId);
        commandContext.getTaskHelper().gatherAsyncCompensationData(taskEntity, QuantitySummary.PLUS);
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(transferId);
        commandContext.getMessageService().deleteToDo(taskId, userIds);
        userIds.clear();
        userIds.add(ownerId);
        commandContext.getMessageService().createCoordinateToDo(taskId, userIds, WfMultiLangUtils.changeILocaleStringToLocaleString(currenSubject));
    }

    private void dispatchTaskCoordinateListener(TaskEntity taskEntity, Long transferId) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            ArrayList<Long> coordinateTransferIds = new ArrayList<Long>();
            coordinateTransferIds.add(transferId);
            ArrayList<Long> coordinateUserIds = new ArrayList<Long>();
            coordinateUserIds.add(this.ownerId);
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createCoordinateTransferTaskEvent(ActivitiEventType.TASK_COORDINATE, taskEntity, coordinateUserIds, coordinateTransferIds, null, TaskCoordinateScene.TASKCOORDINATETRANFERWITHDRAW));
        }
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("withdraw");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u64a4\u56de\u8f6c\u4ea4\u7684\u534f\u529e\u4efb\u52a1", "WithdrawTansferCoordinateTaskCmd_1", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

