/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFTaskException;

public class WithdrawTansferTaskCmd
implements Command<Void> {
    private Long taskId;
    private Long ownerId;
    private Map<String, Object> eventMap = new HashMap<String, Object>();

    public WithdrawTansferTaskCmd(Long taskId, Long ownerId) {
        this.taskId = taskId;
        this.ownerId = ownerId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        try {
            TaskEntity task;
            this.withdrawTansfer(commandContext, this.taskId, this.ownerId);
            if (TaskHelper.isComposeTask(this.taskId)) {
                List<Long> composedTaskIds = commandContext.getTaskEntityManager().findComposedTaskIdsByCompositeTaskIdAndUserId(this.taskId, this.ownerId);
                for (Long composedTaskId : composedTaskIds) {
                    this.withdrawTansfer(commandContext, composedTaskId, this.ownerId);
                }
            }
            QFilter qFilter1 = new QFilter("taskid", "=", (Object)this.taskId);
            QFilter qFilter2 = new QFilter("delegateid", "=", (Object)0L);
            QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
            List identityLinkEntitys = commandContext.getIdentityLinkEntityManager().findByQueryFilters(qFilters);
            ArrayList<Long> participantIds = new ArrayList<Long>(identityLinkEntitys.size());
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
                participantIds.add(identityLinkEntity.getUserId());
            }
            if (participantIds.contains(this.ownerId)) {
                TaskDelegateUtil.recoverTaskDelegate(commandContext, this.taskId, Boolean.TRUE, "recoverTransferTask");
            }
            if ((task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId)).getExecution() != null) {
                BPMNUtil.updateHitaskInstPresentAssignee(task.getExecution(), null);
            }
            TaskHelper taskHelper = Context.getCommandContext().getTaskHelper();
            taskHelper.gatherAsyncCompensationData(task, QuantitySummary.PLUS);
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                new EventTriggerCmd(TaskEventTypeEnum.TASK_WITHDRAW_TRANSFER_EVENT.getCode(), SerializationUtils.toJsonString(this.eventMap)).execute(commandContext);
            }
        }
        catch (Exception e) {
            ErrorCode errorCode = new ErrorCode("bos.wf.WithdrawTansferTask", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u64a4\u56de\u5931\u8d25\u3002", (String)"WithdrawTansferTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            WFTaskException taskExp = new WFTaskException(e, errorCode, e.getMessage());
            throw taskExp;
        }
        return null;
    }

    private void withdrawTansfer(CommandContext commandContext, Long taskId, Long ownerId) {
        this.saveOperationLog(commandContext, taskId);
        Long transferId = null;
        ArrayList<Long> deleteTaskHandleLogIds = new ArrayList<Long>();
        Boolean isFindRecord = false;
        String[] types = new String[]{"transfer"};
        List<TaskHandleLogEntity> entities = commandContext.getTaskHandleLogEntityManager().getTaskHandleLogs(taskId, "createDate", types);
        int entitiesSize = entities.size();
        if (0 != entitiesSize) {
            for (TaskHandleLogEntity entity : entities) {
                if (!isFindRecord.booleanValue() && ownerId.equals(entity.getOwnerId())) {
                    isFindRecord = true;
                }
                if (!isFindRecord.booleanValue()) continue;
                deleteTaskHandleLogIds.add(entity.getId());
            }
            transferId = entities.get(entitiesSize - 1).getAssigneeid();
        }
        QFilter q1 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q2 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q3 = new QFilter("ownerid", "=", (Object)transferId);
        DeleteServiceHelper.delete((String)"wf_participant", (QFilter[])new QFilter[]{q1, q2, q3});
        QFilter q11 = new QFilter("type", "=", (Object)"coordinate");
        QFilter q12 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q13 = new QFilter("ownerid", "=", (Object)transferId);
        DeleteServiceHelper.delete((String)"wf_hiparticipant", (QFilter[])new QFilter[]{q12, q13, q11});
        commandContext.getRuleTaskRelationEntityManager().deleteEntitiesByTaskIdAndTypeAndUserId(taskId, "coordinate", String.valueOf(ownerId));
        QFilter ownerFormatFilter2 = new QFilter("ownerid", "=", (Object)ownerId);
        QFilter[] ownerFormatFilters = new QFilter[]{q2, ownerFormatFilter2};
        List taskHandleLogEntity = commandContext.getTaskHandleLogEntityManager().findByQueryFilters(ownerFormatFilters);
        LocaleString ownerFormat = new LocaleString();
        if (taskHandleLogEntity != null && !taskHandleLogEntity.isEmpty()) {
            ownerFormat = ((TaskHandleLogEntity)taskHandleLogEntity.get(0)).getOwnerFormat();
        }
        commandContext.getTaskHandleLogEntityManager().deleteEntitiesByTaskHandleLogIds(deleteTaskHandleLogIds);
        String participantType = "participant";
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, transferId, participantType);
        IdentityLinkEntity identityLinkEntity = identityLinkEntitys.get(0);
        if (ownerId == null || identityLinkEntity.getOwnerId() == null || identityLinkEntity.getOwnerId() <= 0L || identityLinkEntity.getOwnerId().longValue() == ownerId.longValue()) {
            identityLinkEntity.setOwnerId(0L);
        }
        identityLinkEntity.setTransferOpinion((ILocaleString)new LocaleString(""));
        identityLinkEntity.setUserId(ownerId);
        identityLinkEntity.setUserName(WfUtils.findUserName(ownerId));
        identityLinkEntity.setUserNameFormatter((ILocaleString)ownerFormat);
        identityLinkEntity.setReadTime(null);
        identityLinkEntity.setCreateDate(WfUtils.now());
        identityLinkEntity.setPriority(0);
        identityLinkEntityManager.update(identityLinkEntity);
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> entity = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, transferId, participantType);
        HistoricIdentityLinkEntity historicIdentityLinkEntity = entity.get(0);
        if (ownerId == null || historicIdentityLinkEntity.getOwnerId() == null || historicIdentityLinkEntity.getOwnerId() <= 0L || historicIdentityLinkEntity.getOwnerId().longValue() == ownerId.longValue()) {
            historicIdentityLinkEntity.setOwnerId(0L);
        }
        historicIdentityLinkEntity.setTransferOpinion((ILocaleString)new LocaleString(""));
        historicIdentityLinkEntity.setUserId(ownerId);
        historicIdentityLinkEntity.setUserName(WfUtils.findUserName(ownerId));
        historicIdentityLinkEntity.setUserNameFormatter((ILocaleString)ownerFormat);
        historicIdentityLinkEntity.setReadTime(null);
        historicIdentityLinkEntity.setPriority(0);
        historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
        QFilter owerQFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter owerQFilter2 = new QFilter("userid", "=", (Object)identityLinkEntity.getOwnerId());
        QFilter[] owerQFilters = new QFilter[]{owerQFilter1, owerQFilter2};
        if (WfUtils.isNotEmpty(identityLinkEntity.getDelegateId()) && WfUtils.isNotEmpty(identityLinkEntity.getOwnerId())) {
            List owerHisIdentityLinkEntitys;
            QFilter trusteeQFilter1 = new QFilter("taskid", "=", (Object)taskId);
            QFilter trusteeQFilter2 = new QFilter("ownerid", "=", (Object)identityLinkEntity.getOwnerId());
            QFilter trusteeQFilter3 = new QFilter("type", "=", (Object)"participant");
            QFilter[] trusteeQFilters = new QFilter[]{trusteeQFilter1, trusteeQFilter2, trusteeQFilter3};
            List trusteeIdentityLinkEntitys = identityLinkEntityManager.findByQueryFilters(trusteeQFilters);
            ArrayList<ILocaleString> name = new ArrayList<ILocaleString>(trusteeIdentityLinkEntitys.size());
            ArrayList<ILocaleString> nameFormat = new ArrayList<ILocaleString>(trusteeIdentityLinkEntitys.size());
            for (IdentityLinkEntity trusteeIdentityLinkEntity : trusteeIdentityLinkEntitys) {
                name.add(trusteeIdentityLinkEntity.getUserName());
                nameFormat.add(trusteeIdentityLinkEntity.getUserNameFormatter());
            }
            List owerIdentityLinkEntitys = identityLinkEntityManager.findByQueryFilters(owerQFilters);
            if (owerIdentityLinkEntitys != null && !owerIdentityLinkEntitys.isEmpty()) {
                IdentityLinkEntity owerIdentityLinkEntity = (IdentityLinkEntity)owerIdentityLinkEntitys.get(0);
                owerIdentityLinkEntity.setTrustName(WfMultiLangUtils.getFormatMergeValue(name));
                owerIdentityLinkEntity.setTrustNameFormat(WfMultiLangUtils.getFormatMergeValue(nameFormat));
                identityLinkEntityManager.update(owerIdentityLinkEntity);
            }
            if ((owerHisIdentityLinkEntitys = historicIdentityLinkEntityManager.findByQueryFilters(owerQFilters)) != null && !owerHisIdentityLinkEntitys.isEmpty()) {
                HistoricIdentityLinkEntity owerHisIdentityLinkEntity = (HistoricIdentityLinkEntity)owerHisIdentityLinkEntitys.get(0);
                owerHisIdentityLinkEntity.setTrustName(WfMultiLangUtils.getFormatMergeValue(name));
                owerHisIdentityLinkEntity.setTrustNameFormat(WfMultiLangUtils.getFormatMergeValue(nameFormat));
                historicIdentityLinkEntityManager.update(owerHisIdentityLinkEntity);
            }
        }
        commandContext.getTaskEntityManager().updateTaskParticipantName(taskId, transferId, ownerId);
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        commandContext.getTaskEntityManager().updateYzjTaskMemberInfoVariables(commandContext, taskEntity, transferId, ownerId);
        if (deleteTaskHandleLogIds.size() != entitiesSize) {
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, ownerId, "pass");
        }
        this.dealWithOtherData(commandContext, transferId);
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, transferId, "priority");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(transferId);
        commandContext.getMessageService().deleteToDo(taskId, userIds);
        ArrayList<Long> ownerIds = new ArrayList<Long>();
        ownerIds.add(ownerId);
        commandContext.getMessageService().createWithdrawTransferToDo(taskId, ownerIds);
        ActivitiEventDispatcher eventDispatcher = commandContext.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            HashMap<String, Long> param = new HashMap<String, Long>();
            param.put("taskId", taskId);
            param.put("ownerId", transferId);
            param.put("withdrawerId", ownerId);
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_WITHDRAWTRANSFER, param));
        }
        final TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        this.eventMap.put("taskId", taskId);
        this.eventMap.put("ownerId", ownerId);
        this.eventMap.put("busKey", task.getBusinessKey());
        this.eventMap.put("billNo", task.getBillNo());
        this.eventMap.put("entityNum", task.getEntityNumber());
        this.eventMap.put("transferId", transferId);
        if (task.isBizTask()) {
            return;
        }
        final Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId(), task.getProcessInstanceId());
        final String activitiId = task.getTaskDefinitionKey();
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("withdraw-transfer"){

            @Override
            public void closed(CommandContext commandContext) {
                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)process.getFlowElement(activitiId), task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
            }
        });
    }

    private void dealWithOtherData(CommandContext commandContext, Long transferId) {
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("withdraw");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNote(WfUtils.getPromptWordLocaleString("\u64a4\u56de\u8f6c\u4ea4\u4efb\u52a1", "WithdrawTansferTaskCmd_2", "bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

