/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDateRange;
import kd.bos.workflow.engine.WfDateUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.MainEntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.MessageCenterParams;

public class ProcessDataCollectorCmd<T>
implements Command<T>,
Serializable {
    private static final String ENDTIME = "endtime";
    private static final String SENDERNAME = "sendername";
    private static final String HANDLESTATE = "handlestate";
    private static final String SUBJECT = "subject";
    private static final String STARTNAME = "startname";
    private static final String ACTIVITYNAMESHOW = "activitynameshow";
    private static final String SUBJECTSHOW = "subjectshow";
    private static final String ENTRABILLNAMESHOW = "entrabillnameshow";
    private static final String TIMETODAY = "timeto";
    private static final String TIMEYESTODAY = "timeyesto";
    private static final String TIMEWEEK = "timewe";
    private static final String TIMEMONTH = "timemo";
    private static final String TIMEQUARTER = "timet";
    Log logger = LogFactory.getLog(this.getClass());

    @Override
    public T execute(CommandContext commandContext) {
        return null;
    }

    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
    }

    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
    }

    protected void buildQFilters(EntityQueryParams entityQueryParams) {
    }

    protected Object buildQueryResult(DynamicObjectCollection dynamicObjects) {
        return null;
    }

    protected MainEntityQueryParams getMainEntityQueryObj(String queryType) {
        switch (queryType) {
            case "toHandle": 
            case "delegateToHandle": {
                return new MainEntityQueryParams("wf_participant");
            }
            case "handled": 
            case "delegateHandled": {
                return new MainEntityQueryParams("wf_hicomment");
            }
            case "toApply": {
                return new MainEntityQueryParams("wf_execution_tc");
            }
            case "applyed": {
                return new MainEntityQueryParams("wf_hiprocinst");
            }
            case "transferHandled": 
            case "transferToHandle": {
                return new MainEntityQueryParams("wf_taskhandlelog");
            }
            case "message": {
                return new MainEntityQueryParams("wf_msg_receiver");
            }
        }
        return null;
    }

    protected void dealQfilter(EntityQueryParams entityQueryParams, ProcessDataEntityQueryParams processDataEntityQueryParams) {
        ArrayList<QFilter> qFilter;
        block20: {
            if (entityQueryParams.getMainEntityQueryParams() == null) {
                return;
            }
            Map<String, String> sqlFilterMap = processDataEntityQueryParams.getSqlFilterMap();
            if (sqlFilterMap == null) {
                return;
            }
            String timeFilter = sqlFilterMap.get("timeFilter");
            String entityFilter = sqlFilterMap.get("entityFilter");
            String beginDate = sqlFilterMap.get("beginDate");
            String endDate = sqlFilterMap.get("endDate");
            qFilter = new ArrayList<QFilter>();
            if (WfUtils.isNotEmpty(entityFilter)) {
                qFilter.add(new QFilter("billtype", "in", Arrays.asList(entityFilter.split(","))));
            }
            if ("timecustom".equalsIgnoreCase(timeFilter)) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    if (beginDate != null) {
                        Date begin = simpleDateFormat.parse(beginDate + " 00:00:00");
                        qFilter.add(new QFilter("CREATEDATE", ">=", (Object)begin));
                    }
                    if (endDate != null) {
                        Date end = simpleDateFormat.parse(endDate + " 23:59:59");
                        qFilter.add(new QFilter("CREATEDATE", "<=", (Object)end));
                    }
                    break block20;
                }
                catch (Exception e) {
                    if (beginDate != null) {
                        qFilter.add(new QFilter("CREATEDATE", ">=", (Object)beginDate));
                    }
                    if (endDate != null) {
                        qFilter.add(new QFilter("CREATEDATE", "<=", (Object)endDate));
                    }
                    break block20;
                }
            }
            WfDateRange wfDateRange = null;
            if (TIMETODAY.equalsIgnoreCase(timeFilter)) {
                wfDateRange = WfDateUtil.getCurrentdayRange();
            } else if (TIMEYESTODAY.equals(timeFilter)) {
                wfDateRange = WfDateUtil.getYesterdayRange();
            } else if (TIMEWEEK.equals(timeFilter)) {
                wfDateRange = WfDateUtil.getWeekdayRange();
            } else if (TIMEMONTH.equals(timeFilter)) {
                wfDateRange = WfDateUtil.getThisMonth();
            } else if (TIMEQUARTER.equals(timeFilter)) {
                wfDateRange = WfDateUtil.getThisQuarter();
            }
            if (wfDateRange != null) {
                qFilter.add(new QFilter("CREATEDATE", ">=", (Object)wfDateRange.getStart()).and(new QFilter("CREATEDATE", "<=", (Object)wfDateRange.getEnd())));
            }
        }
        entityQueryParams.getMainEntityQueryParams().setQFilter(qFilter);
    }

    private void dealQuickQuery(QFilter ap, Map<String, String> fieldsMapping, String entityNumber, List<QFilter> qFilterList) {
        this.logger.debug("dealQuery Qfilter params :" + ap.toString());
        if ((ap.getCP().equals("match") || ap.getCP().equals("ftlike")) && WfUtils.isNotEmptyString(ap.getValue())) {
            String value = ap.getValue().toString();
            if (value.contains("#")) {
                int location = value.indexOf("#");
                String fields = value.substring(0, location);
                String fieldValue = value.substring(location + 1, value.length());
                String[] field = fields.split(",");
                ArrayList<QFilter> orQfilters = new ArrayList<QFilter>();
                if (fieldValue.contains("\b")) {
                    String[] items = fieldValue.split("\b");
                    for (int j = 0; j < field.length; ++j) {
                        String fi = fieldsMapping.get(field[j]);
                        if (WfUtils.isEmpty(fi)) {
                            fi = field[j];
                        }
                        QFilter qFilter = new QFilter(fi, "like", (Object)items[0], (QFilterHint)QFilterHint.CONTAINS);
                        for (int i = 1; i < items.length; ++i) {
                            qFilter.or(new QFilter(fi, "like", (Object)items[i], (QFilterHint)QFilterHint.CONTAINS));
                        }
                        orQfilters.add(qFilter);
                    }
                } else {
                    for (int j = 0; j < field.length; ++j) {
                        String fi = fieldsMapping.get(field[j]);
                        if (WfUtils.isEmpty(fi)) {
                            fi = field[j];
                        }
                        QFilter qFilter = new QFilter(fi, "like", (Object)fieldValue, (QFilterHint)QFilterHint.CONTAINS);
                        orQfilters.add(qFilter);
                    }
                }
                QFilter qFilter = (QFilter)orQfilters.get(0);
                for (int i = 1; i < orQfilters.size(); ++i) {
                    qFilter.or((QFilter)orQfilters.get(i));
                }
                qFilterList.add(qFilter);
            }
        } else {
            qFilterList.add(ap);
        }
    }

    protected void dealQFilterByQueryType(String queryType, EntityQueryParams entityQueryParams, List<QFilter> qFilters) {
        String entityNumber = entityQueryParams.getMainEntityQueryParams().getEntityNumber();
        Map<String, String> fieldsMapping = this.getFilterFieldsMapping(queryType);
        ArrayList<QFilter> entityAndQFilter = new ArrayList<QFilter>();
        for (QFilter ap : qFilters) {
            this.logger.debug("builed Qfilter params :" + ap.toString());
            if ((ap.getCP().equals("match") || ap.getCP().equals("ftlike")) && WfUtils.isNotEmptyString(ap.getValue())) {
                this.dealQuickQuery(ap, fieldsMapping, entityNumber, entityAndQFilter);
                continue;
            }
            QFilter[] subFilter = ap.recombine();
            for (int i = 0; i < subFilter.length; ++i) {
                String field;
                if ("prioritynumber".equalsIgnoreCase(subFilter[i].getProperty()) && subFilter[i].getValue() instanceof String) {
                    subFilter[i].__setValue((Object)Integer.parseInt((String)subFilter[i].getValue()));
                }
                if (WfUtils.isEmpty(field = fieldsMapping.get(subFilter[i].getProperty()))) {
                    this.logger.debug("builed Qfilter is NotExtis Mapping :" + subFilter[i].getProperty());
                    field = subFilter[i].getProperty();
                }
                this.logger.debug("builed Qfilter is  file :" + field);
                subFilter[i].__setProperty(field);
                List qFilterNests = subFilter[i].getNests(true);
                if (qFilterNests != null && qFilterNests.size() > 0) {
                    for (QFilter.QFilterNest qFilterNest : qFilterNests) {
                        String subOrField;
                        QFilter subOrFilter = qFilterNest.getFilter();
                        if ("prioritynumber".equalsIgnoreCase(subOrFilter.getProperty()) && subOrFilter.getValue() instanceof String) {
                            subOrFilter.__setValue((Object)Integer.parseInt((String)subOrFilter.getValue()));
                        }
                        if (WfUtils.isEmpty(subOrField = fieldsMapping.get(subOrFilter.getProperty()))) {
                            this.logger.debug("builed qFilterNest is NotExtis Mapping :" + subOrFilter.getProperty());
                            subOrField = subOrFilter.getProperty();
                        }
                        subOrFilter.__setProperty(subOrField);
                    }
                    this.logger.debug("builed Qfilter is have or condition result :" + subFilter[i].toString());
                    entityAndQFilter.add(subFilter[i]);
                    continue;
                }
                entityAndQFilter.add(subFilter[i]);
                this.logger.debug("builed Qfilter is have and condition result :" + subFilter[i].toString());
            }
        }
        if (entityAndQFilter.size() > 0) {
            entityQueryParams.getMainEntityQueryParams().setQFilter(entityAndQFilter);
        }
    }

    protected void dealOrderBySqlFields(String queryType, EntityQueryParams entityQueryParams, String orderBy) {
        if (WfUtils.isEmpty(orderBy)) {
            return;
        }
        this.logger.debug("builed orderbysql params :" + orderBy);
        String[] orderBys = orderBy.split(",");
        Map<String, String> fieldsMappiang = this.getFilterFieldsMapping(queryType);
        StringBuilder orderSql = new StringBuilder();
        StringBuilder orginalOrderBy = new StringBuilder();
        for (int i = 0; i < orderBys.length; ++i) {
            String[] names;
            this.logger.debug("builed orderbysql field :" + orderBys[i]);
            List<String> list = Arrays.asList(orderBys[i].split(" "));
            List nam = list.stream().filter(s -> s != null && s.trim().length() > 0).collect(Collectors.toList());
            String name = (String)nam.get(0);
            String fieldName = fieldsMappiang.get(name);
            this.logger.debug("builed orderbysql get new fieldname :" + fieldName);
            if (WfUtils.isEmpty(fieldName) && (names = name.split("\\.f")).length > 1) {
                name = names[1];
                this.logger.debug("builed orderbysql get new fieldname by api :" + name);
                fieldName = fieldsMappiang.get(names[1]);
            }
            if (WfUtils.isNotEmpty(fieldName)) {
                fieldName = fieldName + " " + (String)nam.get(1);
            } else {
                this.logger.debug("builed orderbysql get original field :" + name);
                fieldName = name + " " + (String)nam.get(1);
            }
            orginalOrderBy.append(name).append(" ").append((String)nam.get(1));
            orderSql.append(fieldName);
            if (i >= orderBys.length - 1) continue;
            orderSql.append(",");
            orginalOrderBy.append(",");
        }
        if (orderSql.length() > 0) {
            entityQueryParams.getMainEntityQueryParams().setOrderBySql(orderSql.toString());
            entityQueryParams.getMainEntityQueryParams().setOriginalOrderBySql(orginalOrderBy.toString());
        }
    }

    protected Map<String, String> getFilterFieldsMapping(String queryType) {
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>(32);
        if ("handled".equals(queryType) || "delegateHandled".equals(queryType)) {
            if (WfConfigurationUtil.isDisplaySetting()) {
                formFieldMapSQLFiled.put(STARTNAME, "startnameformat");
                formFieldMapSQLFiled.put(SENDERNAME, "sendernameformat");
                formFieldMapSQLFiled.put("trustee", "usernameformatter");
            } else {
                formFieldMapSQLFiled.put("trustee", "assignee");
            }
            formFieldMapSQLFiled.put(SUBJECT, "currentsubject");
            formFieldMapSQLFiled.put("name", "activityname");
            formFieldMapSQLFiled.put("id", "taskid");
            formFieldMapSQLFiled.put(ENDTIME, "time");
        } else if ("transferHandled".equals(queryType)) {
            if (WfConfigurationUtil.isDisplaySetting()) {
                formFieldMapSQLFiled.put(STARTNAME, "startnameformat");
                formFieldMapSQLFiled.put(SENDERNAME, "sendernameformat");
            }
            formFieldMapSQLFiled.put(SUBJECT, "currentsubject");
            formFieldMapSQLFiled.put("name", "activityname");
            formFieldMapSQLFiled.put("id", "taskid");
            formFieldMapSQLFiled.put(HANDLESTATE, "taskstate");
        } else if ("toApply".equals(queryType)) {
            formFieldMapSQLFiled.put("handletime", "activityid");
            formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, "entrabillname");
            formFieldMapSQLFiled.put(ACTIVITYNAMESHOW, "activityname");
            formFieldMapSQLFiled.put(SUBJECTSHOW, SUBJECT);
        } else if ("applyed".equals(queryType)) {
            formFieldMapSQLFiled.put(SUBJECTSHOW, SUBJECT);
            formFieldMapSQLFiled.put(ENTRABILLNAMESHOW, "entrabillname");
            formFieldMapSQLFiled.put("proandversion", "name");
            formFieldMapSQLFiled.put("totalhandleduration", "businesskey");
            formFieldMapSQLFiled.put("handletime", "businesskey");
        } else if ("toHandle".equals(queryType) || "delegateToHandle".equals(queryType)) {
            formFieldMapSQLFiled.put("id", "taskid");
            formFieldMapSQLFiled.put(SUBJECT, "currentsubject");
            formFieldMapSQLFiled.put(HANDLESTATE, "taskstate");
            formFieldMapSQLFiled.put("processinstanceid", "procinstid");
            if ("toHandle".equals(queryType)) {
                formFieldMapSQLFiled.put("prioritynumber", "priority");
                formFieldMapSQLFiled.put("priorityshow", "priority");
            }
            if ("delegateToHandle".equals(queryType)) {
                formFieldMapSQLFiled.put("delegatetime", "createdate");
            }
            if (WfConfigurationUtil.isDisplaySetting()) {
                formFieldMapSQLFiled.put("trustee", "usernameformatter");
                formFieldMapSQLFiled.put(STARTNAME, "startnameformat");
                formFieldMapSQLFiled.put(SENDERNAME, "sendernameformat");
            } else {
                formFieldMapSQLFiled.put("trustee", "username");
                formFieldMapSQLFiled.put(STARTNAME, STARTNAME);
                formFieldMapSQLFiled.put(SENDERNAME, SENDERNAME);
            }
            formFieldMapSQLFiled.put("groupnumber.id", "groupnumber");
        } else if ("transferToHandle".equals(queryType)) {
            formFieldMapSQLFiled.put("id", "taskid");
            formFieldMapSQLFiled.put(SUBJECT, "currentsubject");
            formFieldMapSQLFiled.put(HANDLESTATE, "taskstate");
            formFieldMapSQLFiled.put("name", "activityname");
            formFieldMapSQLFiled.put("processinstanceid", "procinstid");
            formFieldMapSQLFiled.put("prioritynumber", "priority");
            if (WfConfigurationUtil.isDisplaySetting()) {
                formFieldMapSQLFiled.put(STARTNAME, "startnameformat");
                formFieldMapSQLFiled.put(SENDERNAME, "assigneeformat");
            } else {
                formFieldMapSQLFiled.put(STARTNAME, STARTNAME);
                formFieldMapSQLFiled.put(SENDERNAME, "assignee");
            }
            formFieldMapSQLFiled.put("groupnumber.id", "groupnumber");
        } else if ("message".equals(queryType)) {
            formFieldMapSQLFiled.put("id", "messageid");
        }
        return formFieldMapSQLFiled;
    }

    protected void getApplyedResult(DynamicObjectCollection ret) {
        if (ret == null || ret.size() == 0) {
            return;
        }
        String hour = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"HistoricProcessInstanceEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        for (DynamicObject object : ret) {
            if (object.containsProperty("handletime")) {
                Long handleTime = object.getLong("handletimemillis");
                if (WfUtils.isEmpty(handleTime)) {
                    object.set("handletime", (Object)("0.00" + hour));
                } else {
                    double handlenum = (double)handleTime.longValue() / 3600000.0;
                    BigDecimal re = BigDecimal.valueOf(handlenum);
                    Double handleTimeDecimalRe = re.setScale(2, 0).doubleValue();
                    object.set("handletime", (Object)(handleTimeDecimalRe + hour));
                }
            }
            if (!object.containsProperty("totalhandledurationmillis") || !object.containsProperty("totalhandleduration")) continue;
            Long totalhandleduration = object.getLong("totalhandledurationmillis");
            double num = (double)totalhandleduration.longValue() / 3600000.0;
            BigDecimal totalhandledurationDecimal = BigDecimal.valueOf(num);
            Double totalhandledurationDecimalRe = totalhandledurationDecimal.setScale(2, 0).doubleValue();
            object.set("totalhandleduration", (Object)(totalhandledurationDecimalRe + hour));
        }
    }

    protected Map<Long, Set<String>> getMark(String queryFiled, Long userId, String filterSql, String orderBy) {
        StringBuilder markSql = new StringBuilder();
        markSql.append("select a.ftaskid taskid").append(",").append(queryFiled).append(" from t_wf_taskmark b inner join t_wf_rtrelation a on b.fid = a.fmarkid ").append("where a.fuserid = ? ");
        if (WfUtils.isNotEmpty(filterSql)) {
            markSql.append(" and ").append(filterSql);
        }
        if (WfUtils.isNotEmpty(orderBy)) {
            markSql.append(" order by ").append(orderBy);
        }
        Object[] markSqlParams = new Object[]{userId};
        HashMap<Long, Set<String>> markMap = new HashMap<Long, Set<String>>();
        try (DataSet markDs = DB.queryDataSet((String)"WfTaskCenter.wf_taskmark.queryGridData", (DBRoute)DBRoute.workflow, (String)markSql.toString(), (Object[])markSqlParams);){
            for (Row row : markDs) {
                Set<String> values;
                Long taskid = row.getLong("taskid");
                String value = row.getString("name");
                if (!WfUtils.isNotEmpty(value)) continue;
                if (markMap.containsKey(taskid)) {
                    values = (Set)markMap.get(taskid);
                    values.add(value);
                    continue;
                }
                values = new HashSet();
                values.add(value);
                markMap.put(taskid, values);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return markMap;
    }

    protected DynamicObjectCollection mergeTransferTaskByTime(DynamicObjectCollection ret) {
        DynamicObjectCollection col = new DynamicObjectCollection();
        HashMap<Long, Integer> p = new HashMap<Long, Integer>();
        for (int i = 0; i < ret.size(); ++i) {
            DynamicObject dyObject = (DynamicObject)ret.get(i);
            if (!dyObject.containsProperty("id") || !dyObject.containsProperty("createdate")) {
                return ret;
            }
            Long taskId = dyObject.getLong("id");
            if (p.containsKey(taskId)) {
                int index;
                Date dateInMap;
                Date dateOfCurrent = dyObject.getDate("createdate");
                if (!dateOfCurrent.after(dateInMap = ((DynamicObject)col.get(index = ((Integer)p.get(taskId)).intValue())).getDate("createdate"))) continue;
                col.remove(index);
                col.add((Object)dyObject);
                continue;
            }
            col.add((Object)dyObject);
            p.put(taskId, col.size() - 1);
        }
        return col;
    }

    protected List<String> getExecutionType() {
        List<String> executionType = this.getExecutionTypeByProcessAssistant();
        executionType.add("manualdraw");
        executionType.add("manualpush");
        return executionType;
    }

    protected List<String> getExecutionTypeByProcessAssistant() {
        ArrayList<String> executionType = new ArrayList<String>();
        executionType.add("byHand");
        executionType.add("byExpireAuto");
        executionType.add("skip");
        executionType.add("forceReject");
        executionType.add("jump");
        executionType.add("enterBoundary");
        executionType.add("frozen");
        executionType.add("abandon");
        executionType.add("cancel");
        executionType.add("addSignBefore");
        executionType.add("compensation");
        return executionType;
    }

    protected List<String> getType() {
        ArrayList<String> type = new ArrayList<String>();
        type.add("message");
        type.add("comment");
        type.add("forceReject");
        type.add("coordinate");
        type.add("converted");
        type.add("event");
        return type;
    }

    protected List<QFilter> getQfilter(MessageCenterParams messageCenterParams, String queryType) {
        QFilter schemeFilter;
        FilterScheme scheme;
        ArrayList<QFilter> allFilter = new ArrayList<QFilter>();
        if (WfUtils.isNotEmpty(messageCenterParams.getScheme()) && (scheme = FilterServiceHelper.getFilterSchemeById((String)messageCenterParams.getScheme())) != null && (schemeFilter = FilterServiceHelper.getQFilterByFilterScheme((FilterScheme)scheme, (String)scheme.getFormId(), null)) != null) {
            allFilter.add(schemeFilter);
        }
        if (messageCenterParams.getqFilters() != null && messageCenterParams.getqFilters().size() > 0) {
            allFilter.addAll(messageCenterParams.getqFilters());
        }
        ArrayList<QFilter> schemeList = new ArrayList<QFilter>();
        if (allFilter.size() > 0) {
            List<String> fields = this.queryFilterFields(queryType);
            StringBuilder str = new StringBuilder();
            for (QFilter schemeQfilter : allFilter) {
                QFilter[] schemes = schemeQfilter.recombine();
                for (int i = 0; i < schemes.length; ++i) {
                    QFilter qFilter = schemes[i];
                    if ("toHandle".equals(queryType) && "prioritynumber".equals(qFilter.getProperty())) {
                        qFilter.__setValue((Object)Integer.parseInt((String)qFilter.getValue()));
                    } else if (!"toHandle".equals(queryType) && "prioritynumber".equals(qFilter.getProperty())) {
                        qFilter = null;
                    }
                    List qFilterNests = schemes[i].getNests(true);
                    if (qFilterNests != null && qFilterNests.size() > 0) {
                        ArrayList<QFilter> orQfilters = new ArrayList<QFilter>(qFilterNests.size() + 1);
                        if (qFilter != null) {
                            if (!fields.contains(qFilter.getProperty())) {
                                str.append(qFilter.getProperty()).append(",");
                            }
                            orQfilters.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
                        }
                        for (QFilter.QFilterNest qFilterNest : qFilterNests) {
                            QFilter subOrFilter = qFilterNest.getFilter();
                            if ("toHandle".equals(queryType) && "prioritynumber".equals(subOrFilter.getProperty())) {
                                subOrFilter.__setValue((Object)Integer.parseInt((String)qFilter.getValue()));
                            } else if (!"toHandle".equals(queryType) && "prioritynumber".equals(qFilter.getProperty())) {
                                subOrFilter = null;
                            }
                            if (subOrFilter == null) continue;
                            if (!fields.contains(subOrFilter.getProperty())) {
                                str.append(subOrFilter.getProperty()).append(",");
                            }
                            orQfilters.add(new QFilter(subOrFilter.getProperty(), subOrFilter.getCP(), subOrFilter.getValue()));
                        }
                        if (orQfilters.size() <= 0) continue;
                        QFilter re = (QFilter)orQfilters.get(0);
                        for (int j = 1; j < orQfilters.size(); ++j) {
                            re.or((QFilter)orQfilters.get(j));
                        }
                        schemeList.add(re);
                        continue;
                    }
                    if (qFilter == null) continue;
                    if (!fields.contains(qFilter.getProperty())) {
                        str.append(qFilter.getProperty()).append(",");
                    }
                    schemeList.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
                }
            }
            if (str.length() > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\uff1a%s\u4e0d\u652f\u6301\u8fc7\u6ee4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GetProcessDataForNewApiCmd_16", (String)"bos-wf-engine", (Object[])new Object[0]), str.toString()));
            }
        }
        return schemeList;
    }

    protected List<String> queryFilterFields(String queryType) {
        ArrayList<String> fields = new ArrayList<String>(15);
        if ("toHandle".equals(queryType) || "transferToHandle".equals(queryType) || "delegateToHandle".equals(queryType)) {
            fields.add("id");
            fields.add(HANDLESTATE);
            fields.add("billno");
            fields.add("entityname");
            fields.add(STARTNAME);
            fields.add(SUBJECT);
            fields.add("name");
            fields.add("processinstanceid");
            if ("delegateToHandle".equals(queryType)) {
                fields.add("delegatetime");
            } else {
                fields.add("createdate");
                fields.add(SENDERNAME);
            }
            if ("toHandle".equals(queryType)) {
                fields.add("entitynumber");
            }
        } else if ("handled".equals(queryType) || "delegateHandled".equals(queryType) || "transferHandled".equals(queryType)) {
            fields.add("id");
            fields.add(HANDLESTATE);
            fields.add(STARTNAME);
            fields.add("name");
            fields.add("billno");
            fields.add("entityname");
            fields.add(SUBJECT);
            fields.add(SENDERNAME);
            if ("handled".equals(queryType) || "transferHandled".equals(queryType)) {
                fields.add("createdate");
            }
            fields.add(ENDTIME);
            fields.add("presentassignee");
            fields.add("entitynumber");
        } else if ("toApply".equals(queryType)) {
            fields.add("id");
            fields.add(ENTRABILLNAMESHOW);
            fields.add("suspensionstate");
            fields.add("presentassignee");
            fields.add(ACTIVITYNAMESHOW);
            fields.add("activityname");
            fields.add(SUBJECTSHOW);
            fields.add("entrabillname");
            fields.add("billno");
            fields.add("createdate");
            fields.add(SUBJECT);
        } else if ("applyed".equals(queryType)) {
            fields.add("id");
            fields.add("priorityshow");
            fields.add(ENDTIME);
            fields.add("billno");
            fields.add(ENTRABILLNAMESHOW);
            fields.add(SUBJECTSHOW);
            fields.add("createdate");
        } else if ("warning".equals(queryType) || "message".equals(queryType) || "notice".equals(queryType) || "alarm".equals(queryType) || "activity".equals(queryType)) {
            fields.add("messageid");
            fields.add("id");
            fields.add(SENDERNAME);
            fields.add("title");
            fields.add("tag");
            fields.add("readstate");
            fields.add("createdate");
            fields.add("content_summary");
            fields.add("operation");
        }
        return fields;
    }

    protected String orderByConvertToString(String queryType, Map<String, String> sortFields) {
        if (sortFields == null || sortFields.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        int size = sortFields.size();
        StringBuilder re = new StringBuilder();
        List<String> fields = this.queryFilterFields(queryType);
        for (Map.Entry<String, String> entry : sortFields.entrySet()) {
            if (!fields.contains(entry.getKey())) {
                re.append(entry.getKey()).append("\uff0c");
            }
            str.append(entry.getKey()).append(" ").append(entry.getValue());
            if (size-- <= 1) continue;
            str.append(",");
        }
        if (re.length() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6392\u5e8f\u5b57\u6bb5\u4e2d\uff1a%s\u4e0d\u652f\u6301\u6392\u5e8f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GetProcessDataForNewApiCmd_17", (String)"bos-wf-engine", (Object[])new Object[0]), re.toString()));
        }
        String res = str.toString();
        this.logger.info("\u6392\u5e8f\u539f\u59cb\u5b57\u6bb5\u4e3a" + res);
        return res;
    }
}

