/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.api;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.GetProcessAndTaskDatasCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.api.GetProcessDataForApiCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;

public class GetProcessDataForApiListCmd
extends GetProcessDataForApiCmd<DynamicObjectCollection> {
    private static final String PROCESSINSTANCEID = "processInstanceId";
    private static final String ACTIVE = "active";
    private static final String INITIATORID = "initiatorId";
    private static final String CATEGORY = "category";
    private static final String STARTNAME = "startname";

    public GetProcessDataForApiListCmd(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        this.processDataEntityQueryParams = processDataEntityQueryParams;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setQueryType(this.processDataEntityQueryParams.getQueryType());
        entityQueryParams.setUserId(this.processDataEntityQueryParams.getUserId());
        entityQueryParams.setEndType(this.processDataEntityQueryParams.getEndType());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj(this.processDataEntityQueryParams.getQueryType()));
        this.buildQFilters(entityQueryParams);
        entityQueryParams.setLimit(this.processDataEntityQueryParams.getLimit());
        entityQueryParams.setStart(this.processDataEntityQueryParams.getStart());
        this.buildQueryFields(entityQueryParams);
        this.buildOrderBy(entityQueryParams);
        DynamicObjectCollection datas = new GetProcessAndTaskDatasCmd(entityQueryParams).execute(commandContext);
        return this.buildQueryResult(datas);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String queryFields = "entityname ,startname ,currentsubject currentsubject,currentsubject subject,name,sendername,entityname priorityshow,sendernameformat,startnameformat, taskid id,taskstate handlestate,billno,biztraceno,priority,type,STARTERID initiatorId,mobileformkey,processingmobilepage,processingpage,category,businesskey,businesskey url,businesskey billName,businesskey userImgUrl,businesskey openId ,groupnumber groupNumber,businesskey text,createdate";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(queryFields);
                break;
            }
            case "toApply": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String toApplyFields = "id,processinstanceid procinstid,entrabillname,subject,subject subjectshow,activityname activitynameshow,presentassignee,entrabillname entrabillnameshow,billno, currenttaskid taskid,entityNumber,processdefinitionid procdefid,activityId,suspensionstate,createdate,businessKey,businessKey url,activityid totalhandleduration,activityid handletime,startuserid startUserId,businessKey initiatorId,businessKey text,businessKey category, processinstanceid,businessKey initiator,priorityshow priorityshow,businessKey userImgUrl,processtype";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(toApplyFields);
                break;
            }
            case "applyed": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String applyedQueryFields = " id procinstid,endtime endTime,businesskey,startuserid startUserId,entitynumber entityNumber,billno billNo,entrabillname billname,subject,startname,createdate,activityname,businesskey initiatorId,businesskey initiator,businesskey userImgUrl, businesskey openId,businesskey text ,businesskey url";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(applyedQueryFields);
            }
        }
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                this.dealOrderBySqlFields("toHandle", entityQueryParams, this.processDataEntityQueryParams.getOrderBy());
                break;
            }
            case "handled": {
                this.dealOrderBySqlFields("handled", entityQueryParams, this.processDataEntityQueryParams.getOrderBy());
                break;
            }
            case "applyed": {
                entityQueryParams.getMainEntityQueryParams().setOrderBySql("createdate desc");
            }
        }
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    protected DynamicObjectCollection buildQueryResult(DynamicObjectCollection ret) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                return this.buildToHandleTaskResult(ret);
            }
            case "handled": {
                return this.buildHandletaskResult(ret);
            }
            case "toApply": {
                return this.buildToApplyResult(ret);
            }
            case "applyed": {
                return this.buildApplyedResult(ret);
            }
        }
        return ret;
    }

    private DynamicObjectCollection buildToHandleTaskResult(DynamicObjectCollection ret) {
        HashMap<String, String> stateMap = new HashMap<String, String>();
        stateMap.put("dismissed", ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"TaskEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("willApproval", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"TaskEntityManagerImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("freeze", ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"TaskEntityManagerImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("willHandled", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"TaskEntityManagerImpl_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        Map<Long, Set<String>> markMap = this.getMark("b.fnumber name", this.processDataEntityQueryParams.getUserId(), "a.fruletype != 'folder'", "");
        HashSet<Long> user = new HashSet<Long>();
        for (DynamicObject dyObject : ret) {
            Long taskid = dyObject.getLong("id");
            if (markMap.get(taskid) != null) {
                dyObject.set("priorityshow", markMap.get(taskid));
            } else {
                dyObject.set("priorityshow", (Object)"");
            }
            if (WfUtils.isNotEmpty(dyObject.getLong(INITIATORID))) {
                user.add(dyObject.getLong(INITIATORID));
            }
            String category = dyObject.getString(CATEGORY);
            String pCaption = MessageServiceUtil.getPCCaption(dyObject.getString(STARTNAME), dyObject.getString("entityname"));
            String mCaption = MessageServiceUtil.getMBCaption(dyObject.getString("entityname"));
            String url = MessageServiceUtil.buildWebPageForTaskUrl(dyObject.getString("processingpage"), dyObject.getString("processingmobilepage"), dyObject.getLong("id"), "toHandle", dyObject.getString("businesskey"), WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofUserTaskOnly(category), pCaption, mCaption);
            dyObject.set("url", (Object)url);
            dyObject.set("billName", (Object)String.format(ResManager.loadKDString((String)"%1$s\u53d1\u8d77\u7684%2$s", (String)"TaskEntityManagerImpl_5", (String)"bos-wf-engine", (Object[])new Object[0]), dyObject.getString(STARTNAME), dyObject.getString("entityname")));
            String state = dyObject.getString("handlestate");
            if (WfUtils.isNotEmpty(state) && WfUtils.isNotEmpty((String)stateMap.get(state))) {
                dyObject.set("text", stateMap.get(state));
                continue;
            }
            dyObject.set("text", (Object)"");
        }
        Map<String, Map<String, Object>> userInfoMap = ProcessAssistantUtil.queryUserInfo(user, null);
        for (DynamicObject dyObject : ret) {
            Long startUserId = dyObject.getLong(INITIATORID);
            if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(startUserId)) {
                Map<String, Object> userInfo = userInfoMap.get(startUserId.toString());
                dyObject.set("userImgUrl", userInfo != null ? userInfo.get("imgUrl") : "");
                dyObject.set("openId", userInfo != null ? userInfo.get("openId") : "");
                continue;
            }
            dyObject.set("userImgUrl", (Object)"");
            dyObject.set("openId", (Object)"");
        }
        return ret;
    }

    private DynamicObjectCollection buildApplyedResult(DynamicObjectCollection ret) {
        HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
        HashSet<Long> userIds = new HashSet<Long>();
        for (DynamicObject row : ret) {
            Long startUserId = row.getLong("startUserId");
            String startName = row.getString(STARTNAME);
            if (WfUtils.isNotEmpty(startUserId)) {
                userInfoMap.put(startUserId, startName);
                userIds.add(startUserId);
                row.set(INITIATORID, (Object)startUserId);
            } else {
                row.set(INITIATORID, (Object)this.processDataEntityQueryParams.getUserId());
            }
            row.set("text", (Object)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ProcessAssistantApplyedTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            row.set("url", (Object)MessageServiceUtil.buildWebPageUrlForMyApplyed((Long)row.get("procinstid")));
        }
        Map<String, UserInfo> userInfos = ProcessAssistantUtil.queryUserInfos(userIds, userInfoMap);
        for (DynamicObject row : ret) {
            String initiatorId = String.valueOf(row.get(INITIATORID));
            UserInfo userInfo = userInfos.get(initiatorId);
            if (userInfo == null) continue;
            row.set("initiator", (Object)userInfo.getName());
            row.set("userImgUrl", (Object)userInfo.getImgUrl());
            row.set("openId", (Object)userInfo.getOpenId());
        }
        return ret;
    }

    private DynamicObjectCollection buildToApplyResult(DynamicObjectCollection ret) {
        Object url;
        LinkedHashMap<String, DynamicObject> proinstMap = new LinkedHashMap<String, DynamicObject>();
        HashSet<Long> userIds = new HashSet<Long>();
        StringBuilder proinstIdsSB = new StringBuilder();
        for (DynamicObject o : ret) {
            Date date = o.getDate("createdate");
            if (date != null) {
                long totalDuration = WfUtils.now().getTime() - date.getTime();
                String totalHour = WfUtils.formatTime(totalDuration);
                o.set("handletime", (Object)totalHour);
            }
            url = MessageServiceUtil.buildWebPageForAuditTaskUrl(o.getLong("procinstid"), "toApply", o.getString("businessKey"));
            o.set("url", url);
            long startUserId = o.getLong("startUserId");
            o.set(INITIATORID, (Object)(WfUtils.isNotEmpty(startUserId) ? startUserId : 0L));
            if (ManagementConstants.SUSPENDED.getStateCode().equals(o.get("suspensionState"))) {
                o.set("text", (Object)ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ExecutionEntityManagerImpl_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            } else {
                proinstIdsSB.append(o.get(PROCESSINSTANCEID)).append(',');
            }
            if (WfUtils.isNotEmpty(startUserId)) {
                userIds.add(startUserId);
            }
            proinstMap.put(o.getLong(PROCESSINSTANCEID) + "", o);
        }
        if (proinstIdsSB.length() > 0) {
            String inProinstIds = "(" + proinstIdsSB.substring(0, proinstIdsSB.length() - 1) + ")";
            String sqlForUser = "SELECT a.FUSERID userId,b.FPROCINSTID procinstId,b.fcategory category,b.fhandlestate handlestate from t_wf_task b LEFT JOIN t_wf_participant a ON a.FTASKID = b.FID WHERE b.FPROCINSTID in " + inProinstIds;
            DataSet dataSet = DB.queryDataSet((String)"wf.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sqlForUser, null);
            url = null;
            try {
                for (Row r : dataSet) {
                    long inititor;
                    Long proinst = r.getLong("procinstId");
                    Long userId = r.getLong("userId");
                    String category = r.getString(CATEGORY);
                    if (!WfUtils.isNotEmpty(proinst)) continue;
                    DynamicObject applyTask = (DynamicObject)proinstMap.get(proinst.toString());
                    applyTask.set(CATEGORY, (Object)category);
                    if ("SSCApprove".equals(category)) {
                        applyTask.set("text", (Object)String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279%s", (String)"ExecutionEntityManagerImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), GraphCodecUtils.getSSCStateName(String.valueOf(r.get("handlestate")))));
                    } else {
                        if (WfUtils.isEmpty(userId)) continue;
                        if (WfUtils.isEmptyString(applyTask.get("text"))) {
                            applyTask.set("text", (Object)userId);
                        } else {
                            String text = applyTask.get("text").toString() + "," + userId;
                            applyTask.set("text", (Object)text);
                        }
                    }
                    proinstMap.put(proinst.toString(), applyTask);
                    userIds.add(userId);
                    if (applyTask == null || (inititor = applyTask.getLong(INITIATORID)) <= 0L || inititor == userId) continue;
                    userIds.add(inititor);
                }
            }
            catch (Throwable iter) {
                url = iter;
                throw iter;
            }
            finally {
                if (dataSet != null) {
                    if (url != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable iter) {
                            ((Throwable)url).addSuppressed(iter);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        if (!userIds.isEmpty()) {
            Map<String, UserInfo> userInfo = ProcessAssistantUtil.queryUserInfos(userIds);
            UserInfo user = null;
            for (DynamicObject m : proinstMap.values()) {
                String muserIds;
                if (WfUtils.isEmptyString(m.get("text"))) {
                    m.set("text", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"ExecutionEntityManagerImpl_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                    continue;
                }
                String suffix = ResManager.loadKDString((String)"\u5904\u7406", (String)"ExecutionEntityManagerImpl_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                if (m.get(CATEGORY) != null && BpmnModelUtil.instanceofAuditTask(m.get(CATEGORY).toString())) {
                    suffix = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"ExecutionEntityManagerImpl_6", (String)"bos-wf-engine", (Object[])new Object[0]);
                }
                if ((muserIds = m.get("text").toString()).contains(",")) {
                    String[] ids = muserIds.split(",");
                    StringBuilder sb = new StringBuilder();
                    int j = 0;
                    String text = "";
                    for (int i = 0; i < ids.length; ++i) {
                        if (j > 2) {
                            text = String.format(ResManager.loadKDString((String)"%1$s%2$s\u7b49%3$s", (String)"ExecutionEntityManagerImpl_8", (String)"bos-wf-engine", (Object[])new Object[0]), WFMultiLangConstants.getWaiting(), sb.substring(0, sb.length() - 1), suffix);
                            break;
                        }
                        user = userInfo.get(ids[i]);
                        if (!WfUtils.isNotEmpty(ids[i]) || user == null || !WfUtils.isNotEmpty(user.getName())) continue;
                        ++j;
                        sb.append(user.getName());
                        sb.append(',');
                    }
                    if (WfUtils.isEmpty(text) && sb.length() > 0) {
                        text = WFMultiLangConstants.getWaiting() + sb.substring(0, sb.length() - 1) + suffix;
                    }
                    m.set("text", (Object)text);
                } else {
                    user = userInfo.get(muserIds);
                    if (user != null && WfUtils.isNotEmpty(user.getName())) {
                        m.set("text", (Object)(WFMultiLangConstants.getWaiting() + user.getName() + suffix));
                    }
                }
                if ((user = userInfo.get(m.get(INITIATORID) + "")) == null) continue;
                m.set("initiator", (Object)user.getName());
                m.set("userImgUrl", (Object)user.getImgUrl());
            }
        }
        DynamicObjectCollection re = (DynamicObjectCollection)ret.clone();
        re.clear();
        re.addAll(proinstMap.values());
        return re;
    }

    private DynamicObjectCollection buildHandletaskResult(DynamicObjectCollection ret) {
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (DynamicObject d : ret) {
            String d_type;
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("startnameformat"))) {
                d.set(STARTNAME, d.get("startnameformat"));
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("sendernameformat"))) {
                d.set("sendername", d.get("sendernameformat"));
            }
            String category = d.getString(CATEGORY);
            String pCaption = MessageServiceUtil.getPCCaption(d.getString(STARTNAME), d.getString("entityname"));
            String mCaption = MessageServiceUtil.getMBCaption(d.getString("entityname"));
            String url = MessageServiceUtil.buildWebPageForTaskUrl(d.getString("processingpage"), d.getString("processingmobilepage"), d.getLong("id"), "handled", d.getString("businesskey"), WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofUserTaskOnly(category), pCaption, mCaption);
            d.set("url", (Object)url);
            if (WfUtils.isNotEmpty(d.getString("currentsubject"))) {
                d.set("subject", (Object)d.getString("currentsubject"));
            }
            if ("coordinate".equals(d_type = d.getString("d_type"))) {
                d.set("HANDLESTATE", (Object)"handled");
                continue;
            }
            if (!"forceReject".equals(d_type)) continue;
            d.set("HANDLESTATE", (Object)d_type);
        }
        return ret;
    }
}

