/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.messagecenter;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.format.FormatObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.GetProcessAndTaskDatasCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.messagecenter.GetProcessDataForMessageCenteCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class GetMessageCenterDataListCmd
extends GetProcessDataForMessageCenteCmd<DynamicObjectCollection> {
    public GetMessageCenterDataListCmd(String schemeName, ProcessDataEntityQueryParams processDataEntityQueryParams) {
        this.schemeName = schemeName;
        this.processDataEntityQueryParams = processDataEntityQueryParams;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setQueryType(this.processDataEntityQueryParams.getQueryType());
        entityQueryParams.setUserId(this.processDataEntityQueryParams.getUserId());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj(this.processDataEntityQueryParams.getQueryType()));
        entityQueryParams.setEndType("pc");
        entityQueryParams.setSource("messageCenter");
        this.buildQFilters(entityQueryParams);
        entityQueryParams.setLimit(this.processDataEntityQueryParams.getLimit());
        entityQueryParams.setStart(this.processDataEntityQueryParams.getStart());
        this.buildQueryFields(entityQueryParams);
        this.buildOrderBy(entityQueryParams);
        DynamicObjectCollection datas = new GetProcessAndTaskDatasCmd(entityQueryParams).execute(commandContext);
        return this.buildQueryResult(datas);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                StringBuilder queryFields = new StringBuilder();
                String taskBillEntity = WfUtils.isNotEmpty(this.processDataEntityQueryParams.getEntityNumber()) ? this.processDataEntityQueryParams.getEntityNumber() : this.processDataEntityQueryParams.getBillType();
                JSONObject json = TaskExtendFieldUtil.getTaskBusinessEntityFields(entityQueryParams.getMainEntityQueryParams().getEntityNumber(), taskBillEntity);
                queryFields.append("ENTITYNAME ,STARTNAME ,CURRENTSUBJECT CURRENTSUBJECT,CURRENTSUBJECT SUBJECT,name,SENDERNAME,ENTITYNAME PRIORITYSHOW,SENDERNAMEFORMAT,STARTNAMEFORMAT, taskid id,taskstate handlestate,billno,biztraceno,priority,type,bizformat,createdate,").append("sourcename,").append(json.getString("taskBusinessFieldStr")).append(" processtype");
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(queryFields.toString());
                break;
            }
            case "handled": {
                String billEntity = WfUtils.isNotEmpty(this.processDataEntityQueryParams.getEntityNumber()) ? this.processDataEntityQueryParams.getEntityNumber() : this.processDataEntityQueryParams.getBillType();
                String queryField = "bizformat,";
                if (TaskExtendFieldUtil.isNeedQueryBusinessField(billEntity)) {
                    JSONObject jsonObject = TaskExtendFieldUtil.getTaskBusinessEntityFields(entityQueryParams.getMainEntityQueryParams().getEntityNumber(), billEntity);
                    queryField = queryField + jsonObject.getString("taskBusinessFieldStr");
                }
                queryField = queryField + "processtype";
                entityQueryParams.getMainEntityQueryParams().setQueryPartFields(queryField);
                break;
            }
            case "toApply": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String toApplyFields = "id,processinstanceid procinstid,entrabillname,subject,subject subjectshow,activityname activitynameshow,presentassignee,entrabillname entrabillnameshow,billno, currenttaskid taskid,entityNumber,processdefinitionid procdefid,activityId,suspensionstate,createdate,businessKey,businessKey url,activityid totalhandleduration,activityid handletime,startuserid startUserId,businessKey initiatorId,businessKey text,businessKey category, processinstanceid,businessKey initiator,priorityshow priorityshow,businessKey userImgUrl,processtype";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(toApplyFields);
                break;
            }
            case "applyed": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String applyedQueryFields = "id, entrabillname entrabillnameshow ,subject subjectshow ,billno,createdate,endtime,processtype,durationinmillis duration, realdurationinmillis realduration,priorityshow,name proandversion,businesskey handletime,businesskey totalhandleduration ,entrabillname,subject,";
                boolean isOpenWorkCalendar = WfConfigurationUtil.getIsOpenWorkCalendar();
                applyedQueryFields = isOpenWorkCalendar && WfConfigurationUtil.enableWorkCalendar() ? applyedQueryFields + "realdurationinmillis handletimemillis ," : applyedQueryFields + "durationinmillis handletimemillis,";
                applyedQueryFields = applyedQueryFields + "durationinmillis totalhandledurationmillis";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(applyedQueryFields);
                break;
            }
            case "transferToHandle": {
                String transferToHandle = "ENTITYNAME ,STARTNAME ,CURRENTSUBJECT CURRENTSUBJECT,CURRENTSUBJECT SUBJECT,activityname name,assignee SENDERNAME,ENTITYNAME PRIORITYSHOW,assigneeformat SENDERNAMEFORMAT,STARTNAMEFORMAT, taskid id,taskstate handlestate,billno,priority,createdate,sourcename";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(transferToHandle);
                break;
            }
            case "transferHandled": {
                String transferHandled = "entityname ,startname ,CURRENTSUBJECT CURRENTSUBJECT,CURRENTSUBJECT SUBJECT,activityname name,SENDERNAME,presentassignee ,STARTNAMEFORMAT, taskid id,taskstate handlestate,billno,priority,createdate,endtime,type,sourcename";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(transferHandled);
                break;
            }
            case "delegateHandled": {
                String delegateToHandle = "taskid id, billno,entityname,startname ,currentsubject subject,handlestate,activityname name,sendername,createdate,delegateid,assignee trustee,time endtime,presentassignee,sendernameformat,startnameformat,usernameformatter,sourcename";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(delegateToHandle);
                break;
            }
            case "delegateToHandle": {
                String delegateHandled = "taskid id,billno,taskstate handlestate,ENTITYNAME ,STARTNAME ,CURRENTSUBJECT CURRENTSUBJECT,CURRENTSUBJECT SUBJECT,name,username trustee,ENTITYNAME PRIORITYSHOW,usernameformatter,startnameformat,createdate delegatetime,createdate createdate,sourcename";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(delegateHandled);
            }
        }
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        String orderBySql = this.processDataEntityQueryParams.getOrderBy();
        if ("applyed".equals(this.processDataEntityQueryParams.getQueryType())) {
            if (WfUtils.isEmpty(orderBySql)) {
                orderBySql = "endtime desc";
            } else if (!orderBySql.contains("endtime")) {
                orderBySql = orderBySql + ",endtime desc";
            }
        }
        this.dealOrderBySqlFields(this.processDataEntityQueryParams.getQueryType(), entityQueryParams, orderBySql);
    }

    protected DynamicObjectCollection buildQueryResult(DynamicObjectCollection dynamicObjects) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                this.getToHandleResult(dynamicObjects);
                break;
            }
            case "transferToHandle": {
                return this.getTransferToHandle(dynamicObjects);
            }
            case "delegateToHandle": {
                this.getDelagateToHandle(dynamicObjects);
                break;
            }
            case "handled": {
                this.getHandledTaskResult(dynamicObjects);
                break;
            }
            case "transferHandled": {
                return this.getTransferHandledResult(dynamicObjects);
            }
            case "delegateHandled": {
                this.getDelegateHandledResult(dynamicObjects);
                break;
            }
            case "toApply": {
                this.getToApplyResult(dynamicObjects);
                break;
            }
            case "applyed": {
                this.getApplyedResult(dynamicObjects);
                break;
            }
        }
        return dynamicObjects;
    }

    private void getToHandleResult(DynamicObjectCollection ret) {
        Map<Long, Set<String>> markMap = this.getMark("b.fnumber name", this.processDataEntityQueryParams.getUserId(), "a.fruletype != 'folder'", "a.fpriority desc");
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)this.processDataEntityQueryParams.getEntityNumber()) ? this.processDataEntityQueryParams.getEntityNumber() : this.processDataEntityQueryParams.getBillType();
        JSONObject json = TaskExtendFieldUtil.getTaskBusinessEntityFields("wf_participant", billEntityNumber);
        Map<Long, Set<String>> markValueMap = this.getMarkValueMap();
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        FormatObject formatObject = null;
        for (DynamicObject taskData : ret) {
            Long taskid = taskData.getLong("id");
            if (isDisplaySetting && WfUtils.isNotEmpty(taskData.getString("startnameformat"))) {
                taskData.set("startname", taskData.get("startnameformat"));
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(taskData.getString("sendernameformat"))) {
                taskData.set("sendername", taskData.get("sendernameformat"));
            }
            if (markMap.get(taskid) != null) {
                Set<String> set = markMap.get(taskid);
                if (set.contains("urgency")) {
                    set.remove("important");
                }
                Iterator<String> it = set.iterator();
                StringBuilder str = new StringBuilder();
                while (it.hasNext()) {
                    str.append(String.valueOf(it.next())).append(",");
                }
                String value = str.toString();
                value = value.length() != 0 ? value.substring(0, value.length() - 1) : "";
                taskData.set("priorityshow", (Object)value);
            } else {
                Long priority = taskData.getLong("priority");
                if (null != priority && null != markValueMap && !markValueMap.isEmpty() && markValueMap.get(priority) != null) {
                    taskData.set("priorityshow", markValueMap.get(priority));
                } else {
                    taskData.set("priorityshow", (Object)"");
                }
            }
            if (json.getJSONObject("fieldRelateFormatField").isEmpty()) continue;
            for (Map.Entry property : json.getJSONObject("fieldRelateFormatField").entrySet()) {
                taskData.set((String)property.getValue(), taskData.get((String)property.getKey()));
            }
            if (!org.apache.commons.lang.StringUtils.isNotBlank((String)taskData.getString("bizformat"))) continue;
            if (formatObject == null) {
                formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
            }
            TaskExtendFieldUtil.formatTaskBusinessFieldVlue(taskData, json.getJSONObject("fieldRelateFormatField"), formatObject);
        }
    }

    private DynamicObjectCollection getTransferToHandle(DynamicObjectCollection ret) {
        if (ret == null || ret.size() == 0) {
            return ret;
        }
        String markSql = "select a.ftaskid taskid,b.fnumber name from t_wf_rtrelation a INNER JOIN t_wf_taskmark b ON a.FMARKID = b.fid and a.fruletype != 'folder' and a.fruletype != 'pass' and a.fruletype != 'priority' where a.ftaskid in (select distinct ftaskid taskid from t_wf_taskhandlelog c where c.FOWNERID = ?  AND c.fisadminforward = '0') and a.FUSERID = ? order by a.fpriority desc;";
        Object[] markSqlParams = new Object[]{this.processDataEntityQueryParams.getUserId(), this.processDataEntityQueryParams.getUserId()};
        HashMap<Long, Set<String>> markMap = new HashMap<Long, Set<String>>();
        try (DataSet markSqlDs = DB.queryDataSet((String)"WfTaskCenterCustom.queryGridData", (DBRoute)DBRoute.workflow, (String)markSql, (Object[])markSqlParams);){
            for (Row row : markSqlDs) {
                Set<String> values;
                String value;
                Set<String> values2;
                Long taskid = row.getLong("taskid");
                if (markMap.containsKey(taskid)) {
                    values2 = (Set)markMap.get(taskid);
                    values2.add(row.getString("name"));
                } else {
                    values2 = new LinkedHashSet();
                    values2.add(row.getString("name"));
                    markMap.put(taskid, values2);
                }
                if (!WfUtils.isNotEmpty(value = row.getString("name"))) continue;
                if (markMap.containsKey(taskid)) {
                    values = (Set)markMap.get(taskid);
                    values.add(value);
                    continue;
                }
                values = new HashSet();
                values.add(value);
                markMap.put(taskid, values);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.specialHandleProperties(ret, markMap, "transfer");
        return this.mergeTransferTaskByTime(ret);
    }

    private void getDelagateToHandle(DynamicObjectCollection ret) {
        Map<Long, Set<String>> markMap = this.getMark("b.fnumber name", this.processDataEntityQueryParams.getUserId(), " a.fruletype != 'folder' and a.fruletype != 'delegate' and a.fruletype != 'priority'", "a.fpriority desc");
        this.specialHandleProperties(ret, markMap, "delegate");
    }

    private Map<Long, Set<String>> getMarkValueMap() {
        QFilter[] filters = new QFilter[]{new QFilter("categorynumber", "=", (Object)"priority")};
        Map taskMarkMap = BusinessDataServiceHelper.loadFromCache((String)"wf_taskmark", (String)"number,value", (QFilter[])filters);
        if (null == taskMarkMap || taskMarkMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Set<String>> markValueMap = new HashMap<Long, Set<String>>(taskMarkMap.size());
        DynamicObject dynObj = null;
        Object value = null;
        Object number = null;
        HashSet<String> numbers = null;
        Set entrySet = taskMarkMap.entrySet();
        Iterator entryIte = entrySet.iterator();
        Map.Entry entry = null;
        while (entryIte.hasNext()) {
            entry = entryIte.next();
            if (null == entry || null == (dynObj = (DynamicObject)entry.getValue()) || null == (value = dynObj.get("value")) || WfUtils.isEmptyString(value) || null == (number = dynObj.get("number")) || WfUtils.isEmptyString(number)) continue;
            numbers = new HashSet<String>();
            numbers.add(number.toString());
            markValueMap.put(Long.valueOf(value.toString()), numbers);
        }
        return markValueMap;
    }

    private DynamicObjectCollection getTransferHandledResult(DynamicObjectCollection ret) {
        if (ret == null || ret.size() == 0) {
            return ret;
        }
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (int i = 0; i < ret.size(); ++i) {
            DynamicObject dyObject = (DynamicObject)ret.get(i);
            String startNameFormat = dyObject.getString("startnameformat");
            if (!isDisplaySetting || !WfUtils.isNotEmpty(startNameFormat)) continue;
            dyObject.set("startname", (Object)startNameFormat);
        }
        return this.mergeTransferTaskByTime(ret);
    }

    private void getDelegateHandledResult(DynamicObjectCollection resultDynamicObjectCollection) {
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (DynamicObject resultDynamicObject : resultDynamicObjectCollection) {
            if (resultDynamicObject != null && resultDynamicObject.containsProperty("startnameformat") && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("startnameformat"))) {
                resultDynamicObject.set("startname", (Object)resultDynamicObject.getString("startnameformat"));
            }
            if (resultDynamicObject != null && resultDynamicObject.containsProperty("usernameformatter") && isDisplaySetting && WfUtils.isNotEmpty(resultDynamicObject.getString("usernameformatter")) && !"false".equals(resultDynamicObject.getString("usernameformatter"))) {
                resultDynamicObject.set("trustee", (Object)resultDynamicObject.getString("usernameformatter"));
            }
            if (resultDynamicObject == null || !resultDynamicObject.containsProperty("sendernameformat") || !isDisplaySetting || !WfUtils.isNotEmpty(resultDynamicObject.getString("sendernameformat")) || "false".equals(resultDynamicObject.getString("sendernameformat"))) continue;
            resultDynamicObject.set("sendername", (Object)resultDynamicObject.getString("sendernameformat"));
        }
    }

    private void getHandledTaskResult(DynamicObjectCollection ret) {
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        HashMap<String, JSONObject> extendFieldJsonMap = new HashMap<String, JSONObject>();
        FormatObject formatObject = null;
        String billEntityNumber = StringUtils.isNotBlank((CharSequence)this.processDataEntityQueryParams.getEntityNumber()) ? this.processDataEntityQueryParams.getEntityNumber() : this.processDataEntityQueryParams.getBillType();
        for (DynamicObject d : ret) {
            String d_type;
            String separateStorageKey = d.getString("separateStorageKey");
            JSONObject json = (JSONObject)extendFieldJsonMap.get(separateStorageKey);
            if (json == null) {
                json = TaskExtendFieldUtil.getTaskBusinessEntityFields(EntityNumberConstant.getHiCommentEntityNumber(separateStorageKey), billEntityNumber);
                extendFieldJsonMap.put(separateStorageKey, json);
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("startnameformat"))) {
                d.set("startname", d.get("startnameformat"));
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("sendernameformat"))) {
                d.set("sendername", d.get("sendernameformat"));
            }
            if ("coordinate".equals(d_type = d.getString("d_type"))) {
                d.set("HANDLESTATE", (Object)"handled");
            } else if ("forceReject".equals(d_type)) {
                d.set("HANDLESTATE", (Object)d_type);
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("currentsubject"))) {
                d.set("subject", (Object)d.getString("currentsubject"));
            }
            if (!TaskExtendFieldUtil.isNeedQueryBusinessField(billEntityNumber) || !WfUtils.isNotEmpty(this.processDataEntityQueryParams.getEntityNumber()) && !WfUtils.isNotEmpty(this.processDataEntityQueryParams.getBillType())) continue;
            if (!json.getJSONObject("fieldRelateFormatField").isEmpty()) {
                for (Map.Entry property : json.getJSONObject("fieldRelateFormatField").entrySet()) {
                    if (!d.containsProperty((String)property.getKey())) continue;
                    d.set((String)property.getValue(), d.get((String)property.getKey()));
                }
            }
            if (!d.containsProperty("bizformat") || !WfUtils.isNotEmpty(d.getString("bizformat"))) continue;
            if (formatObject == null) {
                formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
            }
            TaskExtendFieldUtil.formatTaskBusinessFieldVlue(d, json.getJSONObject("fieldRelateFormatField"), formatObject);
        }
    }

    private void getToApplyResult(DynamicObjectCollection ret) {
        for (DynamicObject o : ret) {
            Date date = o.getDate("createdate");
            if (date == null) continue;
            long totalDuration = WfUtils.now().getTime() - date.getTime();
            String totalHour = WfUtils.formatTime(totalDuration);
            o.set("handletime", (Object)totalHour);
        }
    }

    private void specialHandleProperties(DynamicObjectCollection ret, Map<Long, Set<String>> markMap, String key) {
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (DynamicObject dyObject : ret) {
            Long taskid = dyObject.getLong("id");
            if (CollectionUtils.isNotEmpty(markMap.get(taskid))) {
                Set<String> values = markMap.get(taskid);
                if (values.contains("urgency")) {
                    values.remove("important");
                }
                String valueStr = org.apache.commons.lang.StringUtils.join(values, (String)",");
                dyObject.set("priorityshow", (Object)valueStr);
            } else {
                dyObject.set("priorityshow", (Object)"");
            }
            if (dyObject != null && isDisplaySetting && WfUtils.isNotEmpty(dyObject.getString("startnameformat"))) {
                dyObject.set("startname", (Object)dyObject.getString("startnameformat"));
            }
            if ("delegate".equals(key) && isDisplaySetting && WfUtils.isNotEmpty(dyObject.getString("usernameformatter")) && !"false".equals(dyObject.getString("usernameformatter"))) {
                dyObject.set("trustee", (Object)dyObject.getString("usernameformatter"));
            }
            if (("folder".equals(key) || "transfer".equals(key)) && isDisplaySetting && WfUtils.isNotEmpty(dyObject.getString("sendernameformat")) && !"false".equals(dyObject.getString("sendernameformat"))) {
                dyObject.set("sendername", (Object)dyObject.getString("sendernameformat"));
            }
            if (!"folder".equals(key) || !org.apache.commons.lang.StringUtils.isNotBlank((String)dyObject.getString("currentsubject"))) continue;
            dyObject.set("subject", (Object)dyObject.getString("currentsubject"));
        }
    }
}

