/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.newapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.ProcessDataCollectorCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.MessageCenterParams;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class GetProcessDataForNewApiCmd<T>
extends ProcessDataCollectorCmd {
    protected String queryType;
    protected MessageCenterParams messageCenterParams;
    public Log logger = LogFactory.getLog(this.getClass());

    @Override
    public T execute(CommandContext commandContext) {
        return null;
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        if (this.messageCenterParams.getListFields() == null || this.messageCenterParams.getListFields().size() == 0) {
            this.messageCenterParams.setListFields(this.getMessasgeCenterFields(this.queryType));
        }
        if (entityQueryParams == null) {
            return;
        }
        this.dealQueryFieldsByOrderBy();
        this.getQueryFields(entityQueryParams);
        String queryField = "";
        switch (this.queryType) {
            case "handled": {
                queryField = "type d_type,time";
                break;
            }
            case "applyed": {
                boolean isOpenWorkCalendar = WfConfigurationUtil.getIsOpenWorkCalendar();
                queryField = isOpenWorkCalendar && WfConfigurationUtil.enableWorkCalendar() ? queryField + "realdurationinmillis handletimemillis ," : queryField + "durationinmillis handletimemillis,";
                queryField = queryField + "durationinmillis totalhandledurationmillis,";
                queryField = queryField + "durationinmillis duration, realdurationinmillis realduration";
                break;
            }
        }
        String sql = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        if (WfUtils.isNotEmpty(queryField) && entityQueryParams.getMainEntityQueryParams().getQueryALLFields() != null) {
            sql = sql + "," + queryField;
        }
        entityQueryParams.getMainEntityQueryParams().setQueryALLFields(sql);
    }

    private List<String> getMessasgeCenterFields(String querytype) {
        IMessageCenterService service = (IMessageCenterService)ServiceFactory.getService((String)"MessageCenterService");
        List fieldsMap = service.getTaskAndMessageFields(querytype);
        ArrayList<String> fields = new ArrayList<String>(fieldsMap.size());
        for (Map map : fieldsMap) {
            fields.add((String)map.get("fieldKey"));
        }
        return fields;
    }

    private void getQueryFields(EntityQueryParams entityQueryParams) {
        HashSet listFields = new HashSet(this.messageCenterParams.getListFields());
        Map<String, String> formFieldMap = this.getFilterFieldsMapping(this.queryType);
        StringBuilder stringBuilder = new StringBuilder();
        for (String fieldName : listFields) {
            if (!WfUtils.isNotEmpty(fieldName)) continue;
            String newName = formFieldMap.get(fieldName);
            String fieldsql = newName + " " + fieldName;
            if (WfUtils.isEmpty(newName)) {
                fieldsql = fieldName;
            }
            stringBuilder.append(fieldsql).append(",");
        }
        if (stringBuilder.length() > 0) {
            String re = stringBuilder.toString();
            re = re.substring(0, re.length() - 1);
            entityQueryParams.getMainEntityQueryParams().setQueryALLFields(re);
        }
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        List<QFilter> qFilterList;
        ArrayList<QFilter> filterScheme = new ArrayList<QFilter>();
        if ("handled".equals(this.queryType)) {
            List<String> type = this.getType();
            List<String> executionType = this.getExecutionType();
            filterScheme.add(new QFilter("userid", "=", (Object)entityQueryParams.getUserId()).and(new QFilter("type", "in", type)).and(new QFilter("executiontype", "in", executionType)));
        }
        if ((qFilterList = this.getQfilter(this.messageCenterParams, this.queryType)) == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        Map params = this.messageCenterParams.getParams();
        this.dealQFilterByQueryType(this.queryType, entityQueryParams, qFilterList);
        if (params != null && params.size() > 0) {
            Object queryDelegate = params.get("queryDelegate");
            boolean isDelegate = false;
            if (queryDelegate instanceof String) {
                isDelegate = Boolean.parseBoolean((String)queryDelegate);
            } else if (queryDelegate instanceof Boolean) {
                isDelegate = (Boolean)queryDelegate;
            }
            if (isDelegate && ("toApply".equals(this.queryType) || "applyed".equals(this.queryType))) {
                filterScheme.add(new QFilter("startuserid", "=", (Object)this.messageCenterParams.getUserId()).or(new QFilter("creatorid", "=", (Object)this.messageCenterParams.getUserId())));
                entityQueryParams.setUserId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(entityQueryParams.getMainEntityQueryParams().getQFilter())) {
            filterScheme.addAll(entityQueryParams.getMainEntityQueryParams().getQFilter());
        }
        entityQueryParams.getMainEntityQueryParams().setQFilter(filterScheme);
    }

    @Override
    protected Map<String, Object> buildQueryResult(DynamicObjectCollection dynamicObjects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList listRe = new ArrayList();
        result.put("data", listRe);
        if (dynamicObjects == null) {
            return result;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> re = new HashMap<String, Object>();
            for (String fieldName : this.messageCenterParams.getListFields()) {
                if (!WfUtils.isNotEmpty(fieldName)) continue;
                Object value = dynamicObject.get(fieldName);
                re.put(fieldName, value);
                if (!"handlestate".equals(fieldName) && !"suspensionstate".equals(fieldName)) continue;
                re.put("handlestatedesc", this.getHandleStateDesc(value == null ? "" : (String)value));
            }
            listRe.add(re);
        }
        return result;
    }

    private String getHandleStateDesc(String handleState) {
        switch (handleState) {
            case "dismissed": {
                return ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"GetProcessDataForNewApiListCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "willApproval": {
                return ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"GetProcessDataForNewApiListCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "freeze": {
                return ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"GetProcessDataForNewApiListCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "willHandled": {
                return ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"GetProcessDataForNewApiListCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "unConverted": {
                return ResManager.loadKDString((String)"\u5f85\u8f6c\u6362", (String)"GetProcessDataForNewApiListCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "converted": {
                return ResManager.loadKDString((String)"\u5df2\u8f6c\u6362", (String)"GetProcessDataForNewApiListCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "converting": {
                return ResManager.loadKDString((String)"\u8f6c\u6362\u4e2d", (String)"GetProcessDataForNewApiListCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "manualSuspended": {
                return ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"GetProcessDataForNewApiListCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "approve": {
                return ResManager.loadKDString((String)"\u5df2\u540c\u610f", (String)"GetProcessDataForNewApiListCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "reject": {
                return ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"GetProcessDataForNewApiListCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "forceReject": {
                return ResManager.loadKDString((String)"\u5df2\u5f3a\u5236\u9a73\u56de", (String)"GetProcessDataForNewApiListCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "terminate": {
                return ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"GetProcessDataForNewApiListCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "handled": {
                return ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"GetProcessDataForNewApiListCmd_13", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"GetProcessDataForNewApiListCmd_14", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u6302\u8d77", (String)"GetProcessDataForNewApiListCmd_15", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return null;
    }

    protected Map<String, List<Object>> buildQFiltersToSql(boolean isFormCount) {
        Map<String, List<Object>> filterSqlAndParams = new HashMap<String, List<Object>>();
        List<QFilter> scheme = this.getQfilter(this.messageCenterParams, this.queryType);
        if (scheme == null) {
            scheme = new ArrayList<QFilter>();
        }
        if (scheme.size() == 0) {
            return filterSqlAndParams;
        }
        WorkflowFormService workflowFormService = WorkflowFormService.create();
        for (QFilter qp : scheme) {
            workflowFormService.analyzeHandlestateFilter(qp);
        }
        if ("toHandle".equals(this.queryType) || "transferToHandle".equals(this.queryType) || "delegateToHandle".equals(this.queryType)) {
            filterSqlAndParams = WorkflowFormService.create().buildToHandleFilter(this.queryType, "wf_msg_center", scheme, true, isFormCount);
        } else if ("transferHandled".equals(this.queryType) || ("handled".equals(this.queryType) || "delegateHandled".equals(this.queryType)) && (!WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() || !WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue())) {
            filterSqlAndParams = WorkflowFormService.create().buildHandledTaskFilter(this.queryType, scheme, isFormCount);
        }
        return filterSqlAndParams;
    }

    private void dealQueryFieldsByOrderBy() {
        if (("delegateHandled".equals(this.queryType) || "handled".equals(this.queryType) || "applyed".equals(this.queryType)) && this.messageCenterParams.getListFields() != null && this.messageCenterParams.getListFields().size() > 0 && this.messageCenterParams.getOrderByFields() != null && this.messageCenterParams.getOrderByFields().size() > 0) {
            ArrayList fie = new ArrayList();
            fie.addAll(this.messageCenterParams.getListFields());
            for (Map.Entry field : this.messageCenterParams.getOrderByFields().entrySet()) {
                if (fie.contains(field.getKey())) continue;
                fie.add(field.getKey());
            }
            this.messageCenterParams.setListFields(fie);
        }
    }
}

