/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.newapi.multipletable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.newapi.GetProcessDataForNewApiCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.MessageCenterParams;

public class GetProcessDataListByMultipleTablesCmd
extends GetProcessDataForNewApiCmd<Map<String, Object>> {
    public GetProcessDataListByMultipleTablesCmd(String queryType, MessageCenterParams messageCenterParams) {
        if (WfUtils.isEmpty(messageCenterParams.getUserId())) {
            messageCenterParams.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        }
        if (messageCenterParams.getLimit() == 0) {
            messageCenterParams.setLimit(20);
        }
        this.queryType = queryType;
        this.messageCenterParams = messageCenterParams;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        DynamicObjectCollection datas = null;
        boolean isFormCount = false;
        if ("delegateHandled".equals(this.queryType) || "delegateToHandle".equals(this.queryType)) {
            isFormCount = true;
        }
        String orderSql = this.buildOrderByToSql();
        super.buildQueryFields(null);
        Map<String, List<Object>> filterSqlAndParams = super.buildQFiltersToSql(isFormCount);
        String filterSql = "";
        ArrayList<Object> params = new ArrayList();
        if (!filterSqlAndParams.isEmpty()) {
            Map.Entry<String, List<Object>> entry = filterSqlAndParams.entrySet().iterator().next();
            filterSql = entry.getKey();
            params = entry.getValue();
        }
        if ("toHandle".equals(this.queryType)) {
            datas = commandContext.getTaskEntityManager().getToHandleTasksByParticipantIdForMC(String.valueOf(this.messageCenterParams.getUserId()), "", "", this.messageCenterParams.getStart(), this.messageCenterParams.getLimit(), filterSql, "pc", params, orderSql);
        } else if ("transferToHandle".equals(this.queryType)) {
            datas = commandContext.getTaskEntityManager().getTransferToHandleTask(String.valueOf(this.messageCenterParams.getUserId()), this.messageCenterParams.getStart(), this.messageCenterParams.getLimit(), filterSql, params, orderSql);
        } else if ("delegateToHandle".equals(this.queryType)) {
            datas = commandContext.getTaskEntityManager().getDelegateToHandleTask(String.valueOf(this.messageCenterParams.getUserId()), this.messageCenterParams.getStart(), this.messageCenterParams.getLimit(), filterSql, params, orderSql);
        } else if ("handled".equals(this.queryType)) {
            datas = commandContext.getHistoricTaskInstanceEntityManager().getHandledTasksByAssigneeid(String.valueOf(this.messageCenterParams.getUserId()), "", "", this.messageCenterParams.getStart(), this.messageCenterParams.getLimit(), filterSql, params, orderSql);
        } else if ("transferHandled".equals(this.queryType)) {
            datas = commandContext.getHistoricTaskInstanceEntityManager().getTransferHandledTask(String.valueOf(this.messageCenterParams.getUserId()), this.messageCenterParams.getStart(), this.messageCenterParams.getLimit(), filterSql, params, orderSql);
        } else if ("delegateHandled".equals(this.queryType)) {
            datas = commandContext.getHistoricTaskInstanceEntityManager().getDelegateHandledTask(String.valueOf(this.messageCenterParams.getUserId()), this.messageCenterParams.getStart(), this.messageCenterParams.getLimit(), filterSql, params, orderSql);
        }
        return this.buildQueryResult(datas);
    }

    private String buildOrderByToSql() {
        String orderSql = "";
        if (this.messageCenterParams.getOrderByFields() != null && this.messageCenterParams.getOrderByFields().size() > 0) {
            String orderBy = this.orderByConvertToString(this.queryType, this.messageCenterParams.getOrderByFields());
            this.logger.info("\u6784\u5efaorderByMultiple" + orderBy);
            orderSql = WorkflowFormService.create().buildOrderByToSql(this.queryType, orderBy);
        }
        return orderSql;
    }
}

