/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.newapi.singletable;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.GetProcessAndTaskDatasCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.newapi.GetProcessDataForNewApiCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.MessageCenterParams;

public class GetProcessDataListBySingleTableCmd
extends GetProcessDataForNewApiCmd<Map<String, Object>> {
    public GetProcessDataListBySingleTableCmd(String queryType, MessageCenterParams messageCenterParams) {
        if (WfUtils.isEmpty(messageCenterParams.getUserId())) {
            messageCenterParams.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        }
        if (messageCenterParams.getLimit() == 0) {
            messageCenterParams.setLimit(20);
        }
        this.queryType = queryType;
        this.messageCenterParams = messageCenterParams;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setQueryType(this.queryType);
        entityQueryParams.setUserId(this.messageCenterParams.getUserId());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj(this.queryType));
        entityQueryParams.setEndType("pc");
        this.buildOrderBy(entityQueryParams);
        this.buildQueryFields(entityQueryParams);
        this.buildQFilters(entityQueryParams);
        entityQueryParams.setLimit(this.messageCenterParams.getLimit());
        entityQueryParams.setStart(this.messageCenterParams.getStart());
        DynamicObjectCollection datas = new GetProcessAndTaskDatasCmd(entityQueryParams).execute(commandContext);
        return this.buildQueryResult(datas);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        super.buildQueryFields(entityQueryParams);
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        String orderBy = this.orderByConvertToString(this.queryType, this.messageCenterParams.getOrderByFields());
        this.logger.info("\u6784\u5efaorderBySingleList" + orderBy);
        this.dealOrderBySqlFields(this.queryType, entityQueryParams, orderBy);
    }

    private DynamicObjectCollection buildResult(DynamicObjectCollection dynamicObjects) {
        switch (this.queryType) {
            case "transferToHandle": {
                return this.getTransferToHandle(dynamicObjects);
            }
            case "handled": {
                this.getHandledTaskResult(dynamicObjects);
                break;
            }
            case "transferHandled": {
                return this.getTransferHandledResult(dynamicObjects);
            }
            case "toApply": {
                this.getToApplyResult(dynamicObjects);
                break;
            }
            case "applyed": {
                this.getApplyedResult(dynamicObjects);
            }
        }
        return dynamicObjects;
    }

    private DynamicObjectCollection getTransferToHandle(DynamicObjectCollection ret) {
        if (ret == null || ret.size() == 0) {
            return ret;
        }
        return this.mergeTransferTaskByTime(ret);
    }

    private DynamicObjectCollection getTransferHandledResult(DynamicObjectCollection ret) {
        if (ret == null || ret.size() == 0) {
            return ret;
        }
        return this.mergeTransferTaskByTime(ret);
    }

    private void getHandledTaskResult(DynamicObjectCollection ret) {
        for (DynamicObject d : ret) {
            if (!d.containsProperty("HANDLESTATE")) continue;
            String d_type = d.getString("d_type");
            if ("coordinate".equals(d_type)) {
                d.set("HANDLESTATE", (Object)"handled");
                continue;
            }
            if (!"forceReject".equals(d_type)) continue;
            d.set("HANDLESTATE", (Object)d_type);
        }
    }

    private void getToApplyResult(DynamicObjectCollection ret) {
        for (DynamicObject o : ret) {
            Date date;
            if (!o.containsProperty("handletime") || !o.containsProperty("createdate") || (date = o.getDate("createdate")) == null) continue;
            long totalDuration = WfUtils.now().getTime() - date.getTime();
            String totalHour = WfUtils.formatTime(totalDuration);
            o.set("handletime", (Object)totalHour);
        }
    }

    @Override
    protected Map<String, Object> buildQueryResult(DynamicObjectCollection dynamicObjectMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (dynamicObjectMap == null || dynamicObjectMap.size() == 0) {
            result.put("data", null);
            return result;
        }
        DynamicObjectCollection dynamicObjects = this.buildResult(dynamicObjectMap);
        return super.buildQueryResult(dynamicObjects);
    }
}

