/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.nocodeflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.GetProcessAndTaskDatasCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.nocodeflow.GetProcessDataForNoCodeFlowCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;

public class GetProcessDataListForNoCodeFlowCmd
extends GetProcessDataForNoCodeFlowCmd<DynamicObjectCollection> {
    public GetProcessDataListForNoCodeFlowCmd(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        this.processDataEntityQueryParams = processDataEntityQueryParams;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setQueryType(this.processDataEntityQueryParams.getQueryType());
        entityQueryParams.setUserId(this.processDataEntityQueryParams.getUserId());
        entityQueryParams.setEndType(this.processDataEntityQueryParams.getEndType());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj(this.processDataEntityQueryParams.getQueryType()));
        this.buildQFilters(entityQueryParams);
        entityQueryParams.setLimit(this.processDataEntityQueryParams.getLimit());
        entityQueryParams.setStart(this.processDataEntityQueryParams.getStart());
        this.buildQueryFields(entityQueryParams);
        this.buildOrderBy(entityQueryParams);
        DynamicObjectCollection datas = new GetProcessAndTaskDatasCmd(entityQueryParams).execute(commandContext);
        return this.buildQueryResult(datas);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                StringBuilder queryFields = new StringBuilder();
                queryFields.append("entityname,startName,currentsubject subject,name activityName,sendername,taskid id,businessKey,starterid startUserId,businesskey startUserImgUrl,taskstate handleState,entitynumber entityNumber,processinstanceid procInstId,processdefid procDefId,businesskey procDefName,createdate createDate,taskdefinitionkey activityId,senderid senderid,category,type,priority,createdate c_createdate,executionid executionId,businesskey nodeBusinessKey,businesskey nodeEntityNumber");
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(queryFields.toString());
                break;
            }
            case "handled": {
                String handleField = "taskid id,entityname,currentsubject subject,startname,activityname,sendername,sendernameformat,startnameformat,presentassignee,resultname resultName,businesskey,starterid startUserId, businesskey startUserImgUrl,handlestate,entitynumber entityNumber,processinstanceid procInstId,processinstanceid executionId,processinstanceid procDefId,businesskey procDefName,createdate createDate,billno,category,resultnumber resultNumber,type d_type,TIME ENDTIME,TIME,activityid activityId,businesskey nodeBusinessKey,businesskey nodeEntityNumber";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(handleField);
                break;
            }
            case "toApply": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String toApplyFields = "id,businessKey,startuserid startUserId,starusernameformat startName,entrabillname entityName,presentassignee activityUserName,activityname activityName, entitynumber entityNumber,processinstanceid procinstid,processdefinitionid procdefid,businessKey procDefName,businessKey startUserImgUrl,createdate createDate,suspensionstate, businessKey handleState ,businessKey endType,businessKey activityUserId,businessKey activityUserImgUrl,activityId,businessKey category,currenttaskid taskid,businessKey endtime,businessKey handletime,billno";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(toApplyFields);
                break;
            }
            case "applyed": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String applyedQueryFields = "ID procInstId,businesskey businessKey,startuserid startUserId,businesskey startName,businesskey startUserImgUrl,entrabillname entityName,entitynumber entityNumber,processdefinitionid procDefId,businesskey procDefName,createdate createdate,endtime endTime,billno billNo,endtype endType,deletereason deleteReason,businesskey initiatorId,businesskey initiator,businesskey userImgUrl,businesskey handleState,businesskey activityUserId,businesskey activityUserName,businesskey activityUserImgUrl,businesskey activityId,businesskey activityName,businesskey handletime,businesskey category";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(applyedQueryFields);
            }
        }
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "applyed": {
                entityQueryParams.getMainEntityQueryParams().setOrderBySql("createdate desc");
            }
        }
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    protected DynamicObjectCollection buildQueryResult(DynamicObjectCollection ret) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                return this.buildToHandleTaskResult(ret);
            }
            case "handled": {
                return this.buildHandletaskResult(ret);
            }
            case "toApply": {
                return this.buildToApplyResult(ret);
            }
            case "applyed": {
                return this.buildApplyedResult(ret);
            }
        }
        return ret;
    }

    private DynamicObjectCollection buildToHandleTaskResult(DynamicObjectCollection ret) {
        HashSet<Long> procDefIds = new HashSet<Long>(ret.size());
        HashSet<Long> startUserIds = new HashSet<Long>(ret.size());
        HashSet<Long> procInstId = new HashSet<Long>(ret.size());
        for (DynamicObject dyObject : ret) {
            procDefIds.add(dyObject.getLong("procDefId"));
            startUserIds.add(dyObject.getLong("startUserId"));
            procInstId.add(dyObject.getLong("procInstId"));
        }
        Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procDefIds);
        Map<String, UserInfo> userInfoMap = ProcessAssistantUtil.queryUserInfos(startUserIds);
        List hisProcInstEntities = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", procInstId)});
        Map<Long, HistoricProcessInstanceEntity> hisProcInstMap = hisProcInstEntities.stream().collect(Collectors.toMap(HistoricProcessInstance::getId, each -> each));
        for (DynamicObject dyObject : ret) {
            if (WfUtils.isNotEmptyForMap(procdefMap)) {
                dyObject.set("procDefName", (Object)procdefMap.get(dyObject.getLong("procDefId")));
            }
            Long startUserId = dyObject.getLong("startUserId");
            if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(startUserId)) {
                UserInfo userInfo = userInfoMap.get(startUserId.toString());
                dyObject.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
            }
            if ("UserTask".equalsIgnoreCase(dyObject.getString("category"))) {
                dyObject.set("nodeBusinessKey", dyObject.get("businessKey"));
                dyObject.set("nodeEntityNumber", dyObject.get("entityNumber"));
                HistoricProcessInstanceEntity hisProcInstEntity = hisProcInstMap.get(dyObject.getLong("procInstId"));
                if (hisProcInstEntity == null) continue;
                dyObject.set("businessKey", (Object)hisProcInstEntity.getBusinessKey());
                dyObject.set("entityNumber", (Object)hisProcInstEntity.getEntitynumber());
                continue;
            }
            dyObject.set("nodeBusinessKey", null);
            dyObject.set("nodeEntityNumber", null);
        }
        return ret;
    }

    private DynamicObjectCollection buildHandletaskResult(DynamicObjectCollection ret) {
        HashSet<Long> procDefIds = new HashSet<Long>(ret.size());
        HashSet<Long> startUserIds = new HashSet<Long>(ret.size());
        HashSet<Long> procInstId = new HashSet<Long>(ret.size());
        ArrayList<Long> taskid = new ArrayList<Long>();
        for (DynamicObject dyObject : ret) {
            startUserIds.add(dyObject.getLong("startUserId"));
            procInstId.add(dyObject.getLong("procInstId"));
            taskid.add(dyObject.getLong("id"));
        }
        HashMap<Long, DynamicObject> hitaskMap = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection hiTasks = QueryServiceHelper.query((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"id,executionid,processdefinitionid", (QFilter[])new QFilter[]{new QFilter("id", "in", taskid)});
        for (DynamicObject dynamicObject : hiTasks) {
            hitaskMap.put(dynamicObject.getLong("id"), dynamicObject);
            procDefIds.add(dynamicObject.getLong("processdefinitionid"));
        }
        List hisProcInstEntities = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", procInstId)});
        Map<Long, HistoricProcessInstanceEntity> hisProcInstMap = hisProcInstEntities.stream().collect(Collectors.toMap(HistoricProcessInstance::getId, each -> each));
        Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procDefIds);
        Map<String, UserInfo> userInfoMap = ProcessAssistantUtil.queryUserInfos(startUserIds);
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (DynamicObject d : ret) {
            String d_type;
            DynamicObject dynamicObject = (DynamicObject)hitaskMap.get(d.get("id"));
            if (dynamicObject != null) {
                d.set("executionId", dynamicObject.get("executionid"));
                d.set("procDefId", dynamicObject.get("processdefinitionid"));
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("startnameformat"))) {
                d.set("startname", d.get("startnameformat"));
            }
            if (isDisplaySetting && WfUtils.isNotEmpty(d.getString("sendernameformat"))) {
                d.set("sendername", d.get("sendernameformat"));
            }
            if ("forceReject".equals(d_type = d.getString("d_type"))) {
                d.set("HANDLESTATE", (Object)d_type);
            }
            if (WfUtils.isNotEmptyForMap(procdefMap)) {
                d.set("procDefName", (Object)procdefMap.get(d.getLong("procDefId")));
            }
            Long startUserId = d.getLong("startUserId");
            if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(startUserId)) {
                UserInfo userInfo = userInfoMap.get(startUserId.toString());
                d.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
            }
            if ("UserTask".equalsIgnoreCase(d.getString("category"))) {
                d.set("nodeBusinessKey", d.get("businessKey"));
                d.set("nodeEntityNumber", d.get("entityNumber"));
                HistoricProcessInstanceEntity hisProcInstEntity = hisProcInstMap.get(d.getLong("procInstId"));
                if (hisProcInstEntity == null) continue;
                d.set("businessKey", (Object)hisProcInstEntity.getBusinessKey());
                d.set("entityNumber", (Object)hisProcInstEntity.getEntitynumber());
                continue;
            }
            d.set("nodeBusinessKey", null);
            d.set("nodeEntityNumber", null);
        }
        return ret;
    }

    private DynamicObjectCollection buildToApplyResult(DynamicObjectCollection ret) {
        HashSet<Long> userIds = new HashSet<Long>(ret.size());
        HashSet<Long> procdefIds = new HashSet<Long>(ret.size());
        StringBuilder proinstIdsSB = new StringBuilder();
        LinkedHashMap<Long, DynamicObject> proinstMap = new LinkedHashMap<Long, DynamicObject>();
        for (DynamicObject dyObject : ret) {
            long startUserId = dyObject.getLong("startUserId");
            long procInstId = dyObject.getLong("procInstId");
            long procDefId = dyObject.getLong("procDefId");
            procdefIds.add(procDefId);
            userIds.add(startUserId);
            dyObject.set("startUserId", (Object)(WfUtils.isNotEmpty(startUserId) ? startUserId : 0L));
            proinstMap.put(procInstId, dyObject);
            proinstIdsSB.append(procInstId).append(',');
            Date date = dyObject.getDate("createdate");
            if (date != null) {
                long totalDuration = WfUtils.now().getTime() - date.getTime();
                dyObject.set("handletime", (Object)WfUtils.formatTime(totalDuration));
            }
            dyObject.set("endtime", null);
        }
        this.getPartipantInfoByProcinstIds(proinstIdsSB, proinstMap, userIds);
        Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procdefIds);
        HashMap<String, UserInfo> userInfoMap = new HashMap(ret.size());
        if (!userIds.isEmpty()) {
            userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
        }
        this.handleData(proinstMap, procdefMap, userInfoMap);
        DynamicObjectCollection re = (DynamicObjectCollection)ret.clone();
        re.clear();
        re.addAll(proinstMap.values());
        return re;
    }

    private void getPartipantInfoByProcinstIds(StringBuilder proinstIdsSB, Map<Long, DynamicObject> proinstMap, Set<Long> userIds) {
        if (proinstIdsSB.length() <= 0) {
            return;
        }
        String inProinstIds = "(" + proinstIdsSB.substring(0, proinstIdsSB.length() - 1) + ")";
        String sqlForUser = "select a.fuserid userid,b.fprocinstid procinstid,b.fcategory category,b.fhandlestate handlestate,c.fendtype endType,c.fendtime endtime from t_wf_task b left join " + TableNameConstant.getHiProcInstTableName() + " c on b.fprocinstid = c.fid left join t_wf_participant a on a.ftaskid = b.fid where b.fprocinstid in " + inProinstIds + " order by b.fprocinstid desc;";
        try (DataSet dataSet = DB.queryDataSet((String)"wf.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sqlForUser, null);){
            DynamicObjectCollection dc = ORM.create().toPlainDynamicObjectCollection(dataSet);
            for (DynamicObject o : dc) {
                Long procinstId = o.getLong("procinstId");
                if (WfUtils.isEmpty(procinstId)) continue;
                Long userId = o.getLong("userId");
                DynamicObject applyTask = proinstMap.get(procinstId);
                applyTask.set("category", (Object)o.getString("category"));
                String activityUserId = applyTask.getString("activityUserId");
                applyTask.set("activityUserId", WfUtils.isNotEmpty(activityUserId) ? activityUserId + "," + userId : userId);
                applyTask.set("handleState", (Object)o.getString("handlestate"));
                applyTask.set("endType", (Object)o.getString("endType"));
                applyTask.set("endtime", o.get("endtime"));
                userIds.add(userId);
                proinstMap.put(procinstId, applyTask);
            }
        }
    }

    private void handleData(Map<Long, DynamicObject> proinstMap, Map<Long, String> procdefMap, Map<String, UserInfo> userInfoMap) {
        for (DynamicObject m : proinstMap.values()) {
            String activityUserId;
            String procDefName = "";
            if (WfUtils.isNotEmptyForMap(procdefMap)) {
                procDefName = procdefMap.get(m.getLong("procDefId"));
            }
            m.set("procDefName", (Object)procDefName);
            Long startUserId = m.getLong("startUserId");
            if (!WfUtils.isNotEmptyForMap(userInfoMap)) continue;
            if (WfUtils.isNotEmpty(startUserId)) {
                UserInfo userInfo = userInfoMap.get(startUserId.toString());
                m.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                m.set("startName", userInfo != null ? userInfo.getName() : "");
            }
            if (!WfUtils.isNotEmpty(activityUserId = m.getString("activityUserId"))) continue;
            List<String> activityUserIds = Arrays.asList(activityUserId.split(","));
            StringBuilder activityUserName = new StringBuilder();
            StringBuilder activityUserImgUrl = new StringBuilder();
            for (String str : activityUserIds) {
                UserInfo userInfo = userInfoMap.get(str);
                if (userInfo == null) continue;
                activityUserName.append(userInfo.getName()).append(StandardTips.getComma());
                activityUserImgUrl.append(userInfo.getImgUrl()).append(",");
            }
            if (activityUserName != null && activityUserName.length() > 0) {
                m.set("activityUserName", (Object)activityUserName.substring(0, activityUserName.length() - 1));
            }
            if (activityUserImgUrl == null || activityUserImgUrl.length() <= 0) continue;
            m.set("activityUserImgUrl", (Object)activityUserImgUrl.substring(0, activityUserImgUrl.length() - 1));
        }
    }

    private DynamicObjectCollection buildApplyedResult(DynamicObjectCollection ret) {
        LinkedHashMap<Long, DynamicObject> proinstMap = new LinkedHashMap<Long, DynamicObject>();
        HashSet<Long> userIds = new HashSet<Long>(ret.size());
        HashSet<Long> procdefIds = new HashSet<Long>(ret.size());
        ArrayList<Long> procInstIds = new ArrayList<Long>(ret.size());
        for (DynamicObject dyObject : ret) {
            procInstIds.add(dyObject.getLong("procinstid"));
            userIds.add(dyObject.getLong("startUserId"));
            procdefIds.add(dyObject.getLong("procDefId"));
        }
        QFilter qFilter = new QFilter("processinstanceid", "in", procInstIds);
        DynamicObjectCollection cl = QueryServiceHelper.query((String)EntityNumberConstant.getHiCommentEntityNumber(SeparateStorageType.NOCODE.getKey()), (String)"processinstanceid,handlestate,userid,activityid,activityname,category,time", (QFilter[])new QFilter[]{qFilter}, (String)"time desc");
        if (WfUtils.isNotEmptyForCollection((Collection)cl)) {
            for (DynamicObject obj : cl) {
                Long procInstId = obj.getLong("processinstanceid");
                DynamicObject dynamicObject = (DynamicObject)proinstMap.get(procInstId);
                if (dynamicObject == null || obj.getDate("time").after(dynamicObject.getDate("time"))) {
                    proinstMap.put(obj.getLong("processinstanceid"), obj);
                }
                userIds.add(obj.getLong("userid"));
            }
        }
        Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procdefIds);
        Map<Object, Object> userInfoMap = new HashMap(ret.size());
        if (!userIds.isEmpty()) {
            userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
        }
        for (DynamicObject dyObject : ret) {
            DynamicObject obj;
            Long startUserId;
            Date date = dyObject.getDate("createdate");
            Date endDate = dyObject.getDate("endtime");
            if (date != null) {
                long totalDuration = endDate != null ? endDate.getTime() - date.getTime() : WfUtils.now().getTime() - date.getTime();
                dyObject.set("handletime", (Object)WfUtils.formatTime(totalDuration));
            }
            if (WfUtils.isNotEmpty(startUserId = Long.valueOf(dyObject.getLong("startUserId")))) {
                UserInfo userInfo = (UserInfo)userInfoMap.get(startUserId.toString());
                dyObject.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                dyObject.set("startName", userInfo != null ? userInfo.getName() : "");
            }
            if (WfUtils.isNotEmptyForMap(procdefMap)) {
                dyObject.set("procDefName", (Object)procdefMap.get(dyObject.getLong("procDefId")));
            }
            if ((obj = (DynamicObject)proinstMap.get(dyObject.getLong("procinstid"))) == null) continue;
            dyObject.set("category", (Object)obj.getString("category"));
            dyObject.set("handlestate", (Object)obj.getString("handlestate"));
            dyObject.set("activityId", (Object)obj.getString("activityId"));
            dyObject.set("activityName", (Object)obj.getString("activityName"));
            Long activityUserId = obj.getLong("userid");
            if (!WfUtils.isNotEmpty(activityUserId)) continue;
            UserInfo userInfo = (UserInfo)userInfoMap.get(activityUserId.toString());
            dyObject.set("activityUserId", (Object)activityUserId);
            dyObject.set("activityUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
            dyObject.set("activityUserName", userInfo != null ? userInfo.getName() : "");
        }
        return ret;
    }
}

