/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.dataquery.processassistant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.GetProcessAndTaskDatasCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.processassistant.GetProcessAssistantDataCmd;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.task.TaskUtils;

public class GetProcessAssistantDataListCmd
extends GetProcessAssistantDataCmd<List<Map<String, Object>>> {
    private static final String STARTNAME = "startname";
    private static final String PROCINSTID = "procinstid";
    private static final String BILLNAME = "billName";
    private static final String INITIATOR = "initiator";
    private static final String SUBJECT = "subject";
    private static final String PRESENTASSIGNEE = "presentassignee";
    private static final String CURRENTSUBJECT = "currentsubject";
    private static final String CATEGORY = "category";
    private static final String INITIATORID = "initiatorId";
    private static final String USERNAME = "username";

    public GetProcessAssistantDataListCmd(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        this.processDataEntityQueryParams = processDataEntityQueryParams;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setQueryType(this.processDataEntityQueryParams.getQueryType());
        entityQueryParams.setUserId(this.processDataEntityQueryParams.getUserId());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj(this.processDataEntityQueryParams.getQueryType()));
        this.buildQFilters(entityQueryParams);
        entityQueryParams.setLimit(this.processDataEntityQueryParams.getLimit());
        entityQueryParams.setStart(this.processDataEntityQueryParams.getStart());
        entityQueryParams.setEndType(this.processDataEntityQueryParams.getEndType());
        this.buildQueryFields(entityQueryParams);
        this.buildOrderBy(entityQueryParams);
        DynamicObjectCollection datas = new GetProcessAndTaskDatasCmd(entityQueryParams).execute(commandContext);
        return this.buildQueryResult(datas);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        StringBuilder queryFields = new StringBuilder();
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                queryFields.append("taskid taskId,entityname billName,startname initiator,currentsubject,currentsubject subject,").append("name,STARTERID initiatorId,BUSINESSKEY billId,taskstate state,processingMobilePage,type,priority,createDate,category,source");
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(queryFields.toString());
                break;
            }
            case "handled": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                queryFields.append("taskid taskId,businesskey billId,starterid initiatorId, handlestate,category,source,").append("processingmobilepage processingMobilePage, type,time,time endTime,entityname billname,startname initiator,currentsubject,presentassignee,currentsubject subject");
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(queryFields.toString());
                break;
            }
            case "toApply": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String ToApplyQueryFields = " entrabillname  billname,activityname ,subject, businesskey, createdate, \nactivityid actid, processdefinitionid , processinstanceid,suspensionstate suspensionState,entitynumber , startuserid startUserId ";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(ToApplyQueryFields);
                break;
            }
            case "applyed": {
                if (entityQueryParams.getMainEntityQueryParams() == null) break;
                String applyedQueryFields = " id procinstid,endtime endTime,businesskey,startuserid startUserId,entitynumber formId,billno billNo,entrabillname billname,subject,startname,createdate";
                entityQueryParams.getMainEntityQueryParams().setQueryALLFields(applyedQueryFields);
                break;
            }
        }
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        StringBuilder orderByS = new StringBuilder();
        String orderBy = this.processDataEntityQueryParams.getOrderBy();
        if (WfUtils.isNotEmpty(orderBy)) {
            orderByS.append(orderBy).append(",");
        }
        if ("applyed".equals(this.processDataEntityQueryParams.getQueryType())) {
            orderByS.append("endtime desc");
        }
        if (orderByS.toString().isEmpty()) {
            return;
        }
        String orderByStr = orderByS.toString();
        orderBy = orderByStr.endsWith(",") ? orderByStr.substring(0, orderByStr.length() - 1) : orderByStr;
        entityQueryParams.getMainEntityQueryParams().setOrderBySql(orderBy);
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    private List<Map<String, Object>> buildToHandleResult(DynamicObjectCollection ret) {
        HashMap<String, String> stateMap = new HashMap<String, String>();
        stateMap.put("dismissed", ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ProcessAssistantGetTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("willApproval", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"ProcessAssistantGetTasksCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("freeze", ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ProcessAssistantGetTasksCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("willHandled", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ProcessAssistantGetTasksCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        stateMap.put("manualSuspended", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ProcessAssistantGetTasksCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        String lang = RequestContext.get().getLang().toString();
        Map<Long, Set<String>> markMap = this.getMark("b.fvalue name", this.processDataEntityQueryParams.getUserId(), "a.fruletype != 'folder'", "");
        Iterator iter = ret.iterator();
        String initiatorName = null;
        ArrayList<Map<String, Object>> taskList = new ArrayList<Map<String, Object>>();
        HashSet<Long> user = new HashSet<Long>();
        HashMap<Long, String> userNameMap = new HashMap<Long, String>();
        while (iter.hasNext()) {
            DynamicObject row = (DynamicObject)iter.next();
            HashMap<String, Object> task = new HashMap<String, Object>(14);
            Long initiatorId = (Long)row.get(INITIATORID);
            initiatorName = row.getString(INITIATOR);
            if (WfUtils.isNotEmpty(initiatorId)) {
                user.add(initiatorId);
                userNameMap.put(initiatorId, initiatorName);
            }
            Long taskId = row.getLong("taskId");
            task.put("taskId", taskId);
            if (markMap.get(taskId) != null) {
                Set<String> set = markMap.get(taskId);
                set.remove("100");
                set.remove("60");
                set.add(String.valueOf(row.get("priority")));
                Iterator<String> it = set.iterator();
                StringBuilder str = new StringBuilder();
                while (it.hasNext()) {
                    str.append(String.valueOf(it.next())).append(",");
                }
                String value = str.toString();
                value = value.length() != 0 ? value.substring(0, value.length() - 1) : "";
                task.put("priority", value);
            } else {
                task.put("priority", row.get("priority"));
            }
            String starter = ResManager.loadKDString((String)"\u53d1\u8d77\u7684", (String)"ProcessAssistantGetTasksCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            String billName = row.get(INITIATOR) + starter + row.get(BILLNAME);
            if (lang.equals(Lang.en_US.toString())) {
                billName = row.get(INITIATOR) + " " + starter + " " + row.get(BILLNAME);
            }
            task.put(BILLNAME, billName);
            task.put("billId", row.get("billId"));
            task.put(INITIATOR, initiatorName);
            task.put(INITIATORID, initiatorId);
            if (StringUtils.isNotBlank((Object)row.get(CURRENTSUBJECT))) {
                task.put(SUBJECT, row.get(CURRENTSUBJECT));
            } else {
                task.put(SUBJECT, row.get(SUBJECT));
            }
            task.put("formId", row.get("processingMobilePage"));
            task.put("type", row.get("type"));
            task.put("createDate", row.get("createDate"));
            String state = row.getString("state");
            if ("coordinate".equals(row.getString("type"))) {
                state = "willHandled";
            }
            if (WfUtils.isNotEmpty(state) && WfUtils.isNotEmpty((String)stateMap.get(state))) {
                task.put("text", stateMap.get(state));
            } else {
                task.put("text", "");
            }
            task.put("name", row.get("name"));
            if (row.getString(CATEGORY) != null) {
                task.put(CATEGORY, row.getString(CATEGORY));
            }
            if (row.getString("source") != null) {
                task.put("isBizTask", TaskUtils.isBizTask(row.getString("source")));
            }
            taskList.add(task);
        }
        this.getUserImgUrl(taskList, user, userNameMap);
        return taskList;
    }

    private void getUserImgUrl(List<Map<String, Object>> taskList, Set<Long> user, Map<Long, String> userInfoMap) {
        Map<String, Map<String, Object>> userInfoMaps = ProcessAssistantUtil.queryUserInfo(user, userInfoMap);
        for (Map<String, Object> objectMap : taskList) {
            Long initiatorId = (Long)objectMap.get(INITIATORID);
            if (WfUtils.isNotEmptyForMap(userInfoMaps) && WfUtils.isNotEmpty(initiatorId)) {
                Map<String, Object> userInfo = userInfoMaps.get(initiatorId.toString());
                objectMap.put("userImgUrl", userInfo != null ? userInfo.get("imgUrl") : "");
                objectMap.put("openId", userInfo != null ? userInfo.get("openId") : "");
                objectMap.put(INITIATOR, userInfo != null ? userInfo.get("name").toString() : "");
                continue;
            }
            objectMap.put("userImgUrl", "");
            objectMap.put("openId", "");
        }
    }

    private List<Map<String, Object>> buildHandleResult(DynamicObjectCollection ret) {
        ArrayList<Map<String, Object>> handledTaskList = new ArrayList<Map<String, Object>>();
        Iterator iter = ret.iterator();
        HashSet<Long> user = new HashSet<Long>();
        while (iter.hasNext()) {
            DynamicObject row = (DynamicObject)iter.next();
            HashMap<String, Object> handledTask = new HashMap<String, Object>();
            handledTask.put("taskId", row.get("taskId"));
            handledTask.put(BILLNAME, row.get(BILLNAME));
            handledTask.put("billId", row.get("billId"));
            handledTask.put(INITIATOR, row.get(INITIATOR));
            Long initiatorId = (Long)row.get(INITIATORID);
            if (WfUtils.isNotEmpty(initiatorId)) {
                user.add(initiatorId);
            }
            handledTask.put(INITIATORID, initiatorId);
            handledTask.put("endTime", row.get("endTime"));
            handledTask.put(SUBJECT, row.get(SUBJECT));
            handledTask.put("formId", row.get("processingMobilePage"));
            handledTask.put("text", TaskHelper.getHandledStatusDesc(row.getString("handlestate")));
            handledTask.put("activityname", row.get(PRESENTASSIGNEE));
            if ("coordinate".equals(row.getString("type"))) {
                handledTask.put("text", ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"ProcessAssistantGetHandledTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            if (row.getString(CATEGORY) != null) {
                handledTask.put(CATEGORY, row.getString(CATEGORY));
            }
            if (row.getString("source") != null) {
                handledTask.put("isBizTask", TaskUtils.isBizTask(row.getString("source")));
            }
            handledTaskList.add(handledTask);
        }
        this.getUserImgUrl(handledTaskList, user, null);
        return handledTaskList;
    }

    private List<Map<String, Object>> buildToApplyResult(DynamicObjectCollection ret) {
        Map<String, Object> userInfo = ProcessAssistantUtil.queryUserInfo(this.processDataEntityQueryParams.getUserId(), null);
        StringBuilder proinstIdsSB = new StringBuilder();
        HashSet<Long> userIds = new HashSet<Long>();
        LinkedHashMap proinstMap = new LinkedHashMap();
        HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
        for (DynamicObject row : ret) {
            HashMap<String, Object> applyTask = new HashMap<String, Object>();
            applyTask.put(BILLNAME, row.get("billname"));
            applyTask.put("createDate", row.get("createdate"));
            applyTask.put(PROCINSTID, row.get("processinstanceid"));
            applyTask.put("businessKey", row.get("businesskey"));
            long startUserId = row.getLong("startUserId");
            applyTask.put(INITIATORID, WfUtils.isNotEmpty(startUserId) ? startUserId : 0L);
            applyTask.put(INITIATOR, userInfo.get("name"));
            applyTask.put("userImgUrl", userInfo.get("imgUrl"));
            applyTask.put("openId", userInfo.get("openId"));
            applyTask.put("formId", "wf_approvalpagemobile_bac");
            applyTask.put(SUBJECT, row.get(SUBJECT));
            applyTask.put("suspensionState", row.get("suspensionState"));
            if (ManagementConstants.SUSPENDED.getStateCode().equals(row.get("suspensionState"))) {
                applyTask.put("text", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ProcessAssistantGetApplyTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            } else {
                proinstIdsSB.append(row.get("processinstanceid")).append(",");
            }
            if (WfUtils.isNotEmpty(startUserId)) {
                userIds.add(startUserId);
            }
            proinstMap.put(String.valueOf(row.getLong("processinstanceid")), applyTask);
        }
        if (proinstIdsSB.length() > 0) {
            String inProinstIds = "(" + proinstIdsSB.substring(0, proinstIdsSB.length() - 1) + ")";
            String usernameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "a", "al", "fusername", USERNAME, USERNAME);
            String sqlForUser = "SELECT a.FUSERID userId,b.FPROCINSTID procinstId,b.fcategory category,b.fhandlestate handlestate," + usernameSQL + " from t_wf_task b LEFT JOIN t_wf_participant a ON a.FTASKID = b.FID LEFT JOIN t_wf_participant_l al on a.FID = al.FID WHERE al.FLocaleID = '" + Lang.get().toString() + "' and a.FTYPE = 'participant' and b.FPROCINSTID in " + inProinstIds;
            try (DataSet dataSet = DB.queryDataSet((String)"wf.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sqlForUser, null);){
                for (Row r : dataSet) {
                    long inititor;
                    Long proinst = r.getLong("procinstId");
                    Long userId = r.getLong("userId");
                    String category = r.getString(CATEGORY);
                    if (!WfUtils.isNotEmpty(proinst)) continue;
                    Map applyTask = (Map)proinstMap.get(proinst.toString());
                    applyTask.put(CATEGORY, category);
                    if ("SSCApprove".equals(category)) {
                        applyTask.put("text", String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279%s", (String)"ProcessAssistantGetApplyTasksCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), GraphCodecUtils.getSSCStateName(String.valueOf(r.get("handlestate")))));
                    } else {
                        if (WfUtils.isEmpty(userId)) continue;
                        if (WfUtils.isEmptyString(applyTask.get("text"))) {
                            applyTask.put("text", userId);
                        } else {
                            String text = applyTask.get("text").toString() + "," + userId;
                            applyTask.put("text", text);
                        }
                    }
                    userIds.add(userId);
                    userInfoMap.put(userId, r.getString(USERNAME));
                    if (applyTask == null || (inititor = ((Long)applyTask.get(INITIATORID)).longValue()) <= 0L || inititor == userId) continue;
                    userIds.add(inititor);
                }
            }
        }
        if (!userIds.isEmpty()) {
            Map<String, UserInfo> userInfos = ProcessAssistantUtil.queryUserInfos(userIds, userInfoMap);
            UserInfo user = null;
            for (Map m : proinstMap.values()) {
                String muserIds;
                if (WfUtils.isEmptyString(m.get("text"))) {
                    m.put("text", ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"ProcessAssistantGetApplyTasksCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                    continue;
                }
                String suffix = ResManager.loadKDString((String)"\u5904\u7406", (String)"ProcessAssistantGetApplyTasksCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
                if (m.get(CATEGORY) != null && BpmnModelUtil.instanceofAuditTask(m.get(CATEGORY).toString())) {
                    suffix = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"ProcessAssistantGetApplyTasksCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                }
                if ((muserIds = m.get("text").toString()).contains(",")) {
                    String[] idsStr = muserIds.split(",");
                    HashSet<String> ids = new HashSet<String>(idsStr.length);
                    for (int i = 0; i < idsStr.length; ++i) {
                        ids.add(idsStr[i]);
                    }
                    StringBuilder sb = new StringBuilder();
                    int j = 0;
                    String text = "";
                    for (String id : ids) {
                        if (j > 2) {
                            text = String.format(ResManager.loadKDString((String)"\u7b49\u5f85%1$s\uff1a%2$s\u7b49", (String)"ProcessAssistantGetApplyTasksCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), suffix, sb.substring(0, sb.length() - 1));
                            break;
                        }
                        user = userInfos.get(id);
                        if (!WfUtils.isNotEmpty(id) || user == null || !WfUtils.isNotEmpty(user.getName())) continue;
                        ++j;
                        sb.append(user.getName()).append(",");
                    }
                    if (WfUtils.isEmpty(text) && sb.length() > 0) {
                        text = String.format(ResManager.loadKDString((String)"\u7b49\u5f85%1$s\uff1a%2$s", (String)"GetProcessAssistantDataListCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), suffix, sb.substring(0, sb.length() - 1));
                    }
                    m.put("text", text);
                } else {
                    user = userInfos.get(muserIds);
                    if (user != null && WfUtils.isNotEmpty(user.getName())) {
                        m.put("text", String.format(ResManager.loadKDString((String)"\u7b49\u5f85%1$s\uff1a%2$s", (String)"GetProcessAssistantDataListCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), suffix, user.getName()));
                    }
                }
                if ((user = userInfos.get(m.get(INITIATORID) + "")) == null) continue;
                m.put(INITIATOR, user.getName());
                m.put("userImgUrl", user.getImgUrl());
            }
        }
        return new ArrayList<Map<String, Object>>(proinstMap.values());
    }

    @Override
    protected List<Map<String, Object>> buildQueryResult(DynamicObjectCollection dynamicObjects) {
        switch (this.processDataEntityQueryParams.getQueryType()) {
            case "toHandle": {
                return this.buildToHandleResult(dynamicObjects);
            }
            case "handled": {
                return this.buildHandleResult(dynamicObjects);
            }
            case "toApply": {
                return this.buildToApplyResult(dynamicObjects);
            }
            case "applyed": {
                return this.buildApplyedResult(dynamicObjects);
            }
        }
        return null;
    }

    private List<Map<String, Object>> buildApplyedResult(DynamicObjectCollection ret) {
        ArrayList<Map<String, Object>> applyedInstances = new ArrayList<Map<String, Object>>();
        HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
        HashSet<Long> userIds = new HashSet<Long>();
        String startName = null;
        for (DynamicObject row : ret) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Long startUserId = row.getLong("startUserId");
            startName = row.getString(STARTNAME);
            if (WfUtils.isNotEmpty(startUserId)) {
                userInfoMap.put(startUserId, startName);
                userIds.add(startUserId);
                hashMap.put(INITIATORID, startUserId);
            } else {
                hashMap.put(INITIATORID, this.processDataEntityQueryParams.getUserId());
            }
            hashMap.put(BILLNAME, row.get(BILLNAME));
            hashMap.put("endTime", row.get("endTime"));
            hashMap.put(PROCINSTID, row.get(PROCINSTID));
            hashMap.put("businessKey", row.getString("businesskey"));
            hashMap.put("formId", "wf_approvalmobileview_bac");
            hashMap.put("billNo", row.getString("billNo"));
            hashMap.put(SUBJECT, row.get(SUBJECT));
            hashMap.put("text", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ProcessAssistantApplyedTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            String url = MessageServiceUtil.buildWebPageUrlForMyApplyed((Long)row.get(PROCINSTID));
            hashMap.put("url", url);
            applyedInstances.add(hashMap);
        }
        Map<String, UserInfo> userInfos = ProcessAssistantUtil.queryUserInfos(userIds, userInfoMap);
        for (Map map : applyedInstances) {
            String initiatorId = String.valueOf(map.get(INITIATORID));
            UserInfo userInfo = userInfos.get(initiatorId);
            if (userInfo == null) continue;
            map.put(INITIATOR, userInfo.getName());
            map.put("userImgUrl", userInfo.getImgUrl());
            map.put("openId", userInfo.getOpenId());
        }
        return applyedInstances;
    }
}

