/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.delegatesetting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class GetDelegateTransferRecordsData
implements Command<List<TaskHandleLogEntity>>,
Serializable {
    private Long taskId;
    private Long userId;
    private boolean coordinate;

    public GetDelegateTransferRecordsData(Long taskId, Long userId, boolean coordinate) {
        this.taskId = taskId;
        this.userId = userId;
        this.coordinate = coordinate;
    }

    @Override
    public List<TaskHandleLogEntity> execute(CommandContext commandContext) {
        ArrayList<TaskHandleLogEntity> taskHandleLogs = new ArrayList<TaskHandleLogEntity>();
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId, "processInstanceId");
        if (task == null) {
            return taskHandleLogs;
        }
        Long procInstId = task.getProcessInstanceId();
        List<HistoricIdentityLinkEntity> participants = commandContext.getHistoricIdentityLinkEntityManager().findParticipantsByTaskIdAndOwnerId(procInstId, this.taskId, this.userId, "", "");
        ArrayList<Long> delegateIds = new ArrayList<Long>(10);
        for (HistoricIdentityLinkEntity participant : participants) {
            delegateIds.add(participant.getDelegateId());
        }
        List<TaskHandleLogEntity> allTaskHandleLogs = commandContext.getTaskHandleLogEntityManager().findEntitiesByTaskIdAndType(this.taskId, "transfer");
        for (TaskHandleLogEntity allTaskHandleLog : allTaskHandleLogs) {
            if (delegateIds == null || delegateIds.isEmpty() || !delegateIds.contains(allTaskHandleLog.getDelegateId())) continue;
            taskHandleLogs.add(allTaskHandleLog);
        }
        return taskHandleLogs;
    }
}

