/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.nocodeflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class NoCodeFlowApprovalRecords
implements Command<DynamicObjectCollection> {
    private String businessKey;
    private String entityNumber;

    public NoCodeFlowApprovalRecords(String businessKey, String entityNumber) {
        this.businessKey = businessKey;
        this.entityNumber = entityNumber;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        StringBuilder filterSql = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>();
        if (WfUtils.isNotEmpty(this.businessKey)) {
            filterSql.append(" and a.fbusinesskey = ? ");
            paramsList.add(this.businessKey);
        }
        if (WfUtils.isNotEmpty(this.entityNumber)) {
            filterSql.append(" and a.fentitynumber = ? ");
            paramsList.add(this.entityNumber);
        }
        DynamicObjectCollection results = commandContext.getDetailLogEntityManager().getDetailLogList(filterSql.toString(), paramsList, "a.fcreatedate desc ");
        this.queryCurrentInfo(commandContext, results);
        return results;
    }

    private void queryCurrentInfo(CommandContext commandContext, DynamicObjectCollection results) {
        QFilter f1 = new QFilter("businessKey", "=", (Object)this.businessKey);
        QFilter f2 = new QFilter("entitynumber", "=", (Object)this.entityNumber);
        QFilter f3 = new QFilter("endTime", "is null", null);
        QFilter f4 = new QFilter("taskId", "!=", (Object)0L);
        DynamicObjectCollection cl = QueryServiceHelper.query((String)EntityNumberConstant.getHiActInstEntityNumber(SeparateStorageType.NOCODE.getKey()), (String)"id,taskid taskId,processinstanceid procinstId,processdefinitionid procdefId,activityid activityId,activityname activityName,entitynumber entityNumber,businesskey businessKey,createdate createDate,'' processName,'' assigneeId,'' assigneeAvatar,'' assignee,'' handleState,'' category,'' opinion,'' errorMessage,'' channel,'' messageId,'' nodeBusinessKey,'' nodeEntityNumber ", (QFilter[])new QFilter[]{f1, f2, f3, f4}, (String)"createdate desc");
        if (WfUtils.isNotEmptyForCollection((Collection)cl)) {
            HashSet<Long> taskIds = new HashSet<Long>(cl.size());
            HashSet<Long> procdefIds = new HashSet<Long>(cl.size());
            HashSet<Long> procInstIds = new HashSet<Long>(cl.size());
            for (DynamicObject obj : cl) {
                taskIds.add(obj.getLong("taskId"));
                procdefIds.add(obj.getLong("procdefId"));
                procInstIds.add(obj.getLong("procinstId"));
            }
            Map<Long, String> opMap = NoCodeFlowApprovalRecords.packageOperationType(procInstIds);
            Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procdefIds);
            HashMap<Long, TaskEntity> taskMap = new HashMap<Long, TaskEntity>(taskIds.size());
            if (CollectionUtil.isNotEmpty(taskIds)) {
                ArrayList<Long> ids = new ArrayList<Long>(taskIds);
                ids.addAll(taskIds);
                List<TaskEntity> taskEntities = commandContext.getTaskEntityManager().findByTaskIds(ids);
                for (TaskEntity entity : taskEntities) {
                    taskMap.put(entity.getId(), entity);
                }
            }
            for (DynamicObject obj : cl) {
                TaskEntity entity;
                Long taskId = obj.getLong("taskId");
                if (WfUtils.isNotEmptyForMap(taskMap) && (entity = (TaskEntity)taskMap.get(taskId)) != null) {
                    obj.set("handleState", (Object)entity.getHandleState());
                    obj.set("category", (Object)entity.getCategory());
                    if ("UserTask".equalsIgnoreCase(entity.getCategory())) {
                        obj.set("nodeBusinessKey", (Object)entity.getBusinessKey());
                        obj.set("nodeEntityNumber", (Object)entity.getEntityNumber());
                    }
                }
                obj.set("channel", (Object)opMap.get(obj.getLong("procinstId")));
                obj.set("processName", (Object)procdefMap.get(obj.getLong("procdefId")));
                NoCodeFlowApprovalRecords.packageCurrentParticipantInfo(commandContext, obj);
            }
            results.addAll((Collection)cl);
        }
    }

    private static Map<Long, String> packageOperationType(Set<Long> procInstIds) {
        HashMap<Long, String> opMap = new HashMap<Long, String>(procInstIds.size());
        QFilter q1 = new QFilter("processInstanceId", "in", procInstIds);
        QFilter q2 = new QFilter("name", "=", (Object)"_operation_");
        DynamicObjectCollection cl = QueryServiceHelper.query((String)EntityNumberConstant.getHiVariableInstEntityNumber(SeparateStorageType.NOCODE.getKey()), (String)"processInstanceId,textValue", (QFilter[])new QFilter[]{q1, q2});
        if (WfUtils.isEmptyForCollection((Collection)cl)) {
            return opMap;
        }
        for (DynamicObject obj : cl) {
            opMap.put(obj.getLong("processInstanceId"), obj.getString("textValue"));
        }
        return opMap;
    }

    private static void packageCurrentParticipantInfo(CommandContext commandContext, DynamicObject obj) {
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskId(obj.getLong("taskId"));
        StringBuilder assigneeIdSb = new StringBuilder();
        StringBuilder assigneeSb = new StringBuilder();
        StringBuilder assigneeAvatarSb = new StringBuilder();
        for (IdentityLinkEntity identityLink : identityLinks) {
            assigneeIdSb.append(identityLink.getUserId()).append(",");
            assigneeSb.append(identityLink.getUserName()).append(",");
            Map<String, Object> map = ProcessAssistantUtil.queryUserInfo(identityLink.getUserId());
            if (!WfUtils.isNotEmptyForMap(map)) continue;
            assigneeAvatarSb.append(map.get("imgUrl")).append(",");
        }
        obj.set("assigneeId", (Object)NoCodeFlowApprovalRecords.removeCommas(assigneeIdSb));
        obj.set("assignee", (Object)NoCodeFlowApprovalRecords.removeCommas(assigneeSb));
        obj.set("assigneeAvatar", (Object)NoCodeFlowApprovalRecords.removeCommas(assigneeAvatarSb));
    }

    private static String removeCommas(StringBuilder sb) {
        String str = "";
        if (WfUtils.isNotEmptyString(sb)) {
            str = sb.toString();
            str = str.length() != 0 ? str.substring(0, str.length() - 1) : "";
        }
        return str;
    }
}

