/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.nocodeflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.SuspensionState;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class NoCodeFlowGetBizProcessStatusCmd
implements Command<Map<String, List<BizProcessStatus>>>,
Serializable {
    private String[] businessKeys = null;

    public NoCodeFlowGetBizProcessStatusCmd(String[] businessKeys) {
        this.businessKeys = (String[])businessKeys.clone();
    }

    @Override
    public Map<String, List<BizProcessStatus>> execute(CommandContext commandContext) {
        HashMap<String, List<BizProcessStatus>> resultMap = new HashMap<String, List<BizProcessStatus>>();
        this.getInProcessApplyProcessStatus(resultMap);
        this.getApplyedProcessStatus(resultMap);
        return resultMap;
    }

    private void getInProcessApplyProcessStatus(Map<String, List<BizProcessStatus>> map) {
        QFilter q1 = new QFilter("businessKey", "in", (Object)this.businessKeys);
        QFilter q2 = new QFilter("active", "=", (Object)Boolean.TRUE);
        QFilter q3 = new QFilter("parentId", "=", (Object)0L);
        QFilter q4 = new QFilter("processtype", "=", (Object)ModelType.NoCodeFlow.name());
        DynamicObjectCollection cl = QueryServiceHelper.query((String)"wf_execution", (String)"businesskey, suspensionstate, processinstanceid", (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"createdate desc");
        if (WfUtils.isEmptyForCollection((Collection)cl)) {
            return;
        }
        for (DynamicObject obj : cl) {
            String businessKey = obj.getString("businessKey");
            List<BizProcessStatus> list = map.get(businessKey);
            if (CollectionUtil.isEmpty(list)) {
                list = new ArrayList<BizProcessStatus>(map.size());
            }
            String processStatus = obj.getString("suspensionstate");
            String processStatusName = SuspensionState.SuspensionStateUtil.getStateCaption(processStatus);
            Long processInstanceId = obj.getLong("processinstanceid");
            list.add(new BizProcessStatus(processStatus, processStatusName, processInstanceId));
            map.put(obj.getString("businesskey"), list);
        }
    }

    private void getApplyedProcessStatus(Map<String, List<BizProcessStatus>> map) {
        QFilter q1 = new QFilter("businessKey", "in", (Object)this.businessKeys);
        QFilter q2 = new QFilter("processtype", "=", (Object)ModelType.NoCodeFlow.name());
        DynamicObjectCollection cl = QueryServiceHelper.query((String)EntityNumberConstant.getHiProcInstEntityNumber(SeparateStorageType.NOCODE.getKey()), (String)"id, businesskey, endtype", (QFilter[])new QFilter[]{q1, q2}, (String)"createdate desc");
        if (WfUtils.isEmptyForCollection((Collection)cl)) {
            return;
        }
        for (DynamicObject obj : cl) {
            Long processInstanceId;
            String businessKey = obj.getString("businessKey");
            List<BizProcessStatus> list = map.get(businessKey);
            if (CollectionUtil.isEmpty(list)) {
                list = new ArrayList<BizProcessStatus>(map.size());
            }
            if (!this.isAdd(list, processInstanceId = Long.valueOf(obj.getLong("id")))) continue;
            String processStatus = obj.getString("endtype");
            list.add(new BizProcessStatus(processStatus, NoCodeFlowGetBizProcessStatusCmd.getProcessName(processStatus), processInstanceId));
            map.put(obj.getString("businesskey"), list);
        }
    }

    private boolean isAdd(List<BizProcessStatus> bizProcesses, Long processInstanceId) {
        boolean isAdd = Boolean.TRUE;
        for (BizProcessStatus status : bizProcesses) {
            if (!status.getProcessInstanceId().equals(processInstanceId)) continue;
            isAdd = Boolean.FALSE;
            break;
        }
        return isAdd;
    }

    private static String getProcessName(String endType) {
        String processName = "";
        switch (endType) {
            case "10": {
                processName = ResManager.loadKDString((String)"\u6b63\u5e38\u7ed3\u675f", (String)"GetBizProcessStatusCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "20": {
                processName = ResManager.loadKDString((String)"\u63d0\u4ea4\u64a4\u56de\u7ed3\u675f", (String)"GetBizProcessStatusCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "30": {
                processName = ResManager.loadKDString((String)"\u5ba1\u6279\u7ec8\u6b62", (String)"GetBizProcessStatusCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "40": {
                processName = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5f3a\u5236\u7ec8\u6b62", (String)"GetBizProcessStatusCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "50": {
                processName = ResManager.loadKDString((String)"\u4f8b\u5916\u7ec8\u6b62", (String)"GetBizProcessStatusCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "60": {
                processName = ResManager.loadKDString((String)"\u6574\u5355\u64a4\u56de\u7ec8\u6b62", (String)"GetBizProcessStatusCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "25": {
                processName = ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"GetBizProcessStatusCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "70": {
                processName = ResManager.loadKDString((String)"\u7236\u6d41\u7a0b\u8df3\u8f6c\u7ed3\u675f", (String)"GetBizProcessStatusCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "80": {
                processName = ResManager.loadKDString((String)"\u7236\u6d41\u7a0b\u7ec8\u6b62\u7ed3\u675f", (String)"GetBizProcessStatusCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
            case "90": {
                processName = ResManager.loadKDString((String)"\u7236\u6d41\u7a0b\u6574\u5355\u64a4\u56de\u7ed3\u675f", (String)"GetBizProcessStatusCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
                break;
            }
        }
        return processName;
    }
}

