/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.nocodeflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class NoCodeFlowGetProcessInstanceCount
implements Command<Long> {
    private String processCode;

    public NoCodeFlowGetProcessInstanceCount(String processCode) {
        this.processCode = processCode;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        long count = 0L;
        Map<Long, String> processDefinitionMap = NoCodeFlowUtil.getProcessDefinitionInfoByProcessCode(this.processCode);
        if (processDefinitionMap.isEmpty()) {
            return count;
        }
        String processDefinitionIdsSql = " c.fprocdefid in (?) ";
        List processDefinitionIds = processDefinitionMap.keySet().stream().collect(Collectors.toList());
        processDefinitionIdsSql = processDefinitionIdsSql.replaceAll("\\?", WfUtils.getQuestionMarkList(processDefinitionIds.size()));
        String sql = "select count(1) count from " + TableNameConstant.getHiProcInstTableName(SeparateStorageType.NOCODE.getKey()) + " c where " + processDefinitionIdsSql + " and c.fendtype <> ? and c.fprocesstype = ? ";
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.addAll(processDefinitionIds);
        params.add("20");
        params.add(ModelType.NoCodeFlow.name());
        try (DataSet ds = DB.queryDataSet((String)WfUtils.createAlgoKey("NoCodeFlowGetProcessInstanceCount"), (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Iterator iterator = ds.iterator();
            if (iterator.hasNext()) {
                count = ((Row)iterator.next()).getLong("count");
            }
        }
        return count;
    }
}

