/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.nocodeflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class NoCodeFlowGetProcessInstanceInfo
implements Command<DynamicObjectCollection> {
    private int start;
    private int limit;
    private String processCode;

    public NoCodeFlowGetProcessInstanceInfo(Integer start, Integer limit, String processCode) {
        this.start = start;
        this.limit = limit;
        this.processCode = processCode;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        Map<Long, String> processDefinitionMap = NoCodeFlowUtil.getProcessDefinitionInfoByProcessCode(this.processCode);
        if (processDefinitionMap.isEmpty()) {
            return null;
        }
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = EntityNumberConstant.getHiProcInstEntityNumber(SeparateStorageType.NOCODE.getKey());
        String processDefinitionIdsSql = " a.fprocdefid in (?) ";
        List processDefinitionIds = processDefinitionMap.keySet().stream().collect(Collectors.toList());
        processDefinitionIdsSql = processDefinitionIdsSql.replaceAll("\\?", WfUtils.getQuestionMarkList(processDefinitionIds.size()));
        String startNameSql = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fstartname", "startUserName", "startname");
        String entityNameSql = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fentrabillname", "entityName", "entrabillname");
        String sql = "SELECT top " + (this.start + this.limit) + " a.fid procInstId, a.fprocdefid procDefId,\ta.fentitynumber entityNumber,\ta.fbusinesskey businessKey, a.fcreatedate createDate, a.fendtype endType, a.fdeletereason errorMessage, a.fstartuserid startUserId, '' startUserAvatar,\t'' processName, '' activityId, '' activityName, '' category, '' isEnd, '' presentassignee, a.fendtime endTime, a.fbillno billNo, '' handletime," + entityNameSql + "," + startNameSql + " from " + TableNameConstant.getHiProcInstTableName(SeparateStorageType.NOCODE.getKey()) + " a LEFT JOIN " + TableNameConstant.getHiProcInstTableName(SeparateStorageType.NOCODE.getKey()) + "_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE " + processDefinitionIdsSql + " AND a.fendtype <> ?  AND a.fprocesstype = ? order by a.fcreatedate desc; ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(RequestContext.get().getLang().toString());
        params.addAll(processDefinitionIds);
        params.add("20");
        params.add(ModelType.NoCodeFlow.name());
        DynamicObjectCollection ret = null;
        try (DataSet ds = DB.queryDataSet((String)WfUtils.createAlgoKey("NoCodeFlowGetProcessInstanceInfo"), (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start, this.limit);
            this.handleData(ret, processDefinitionMap);
        }
        return ret;
    }

    private void handleData(DynamicObjectCollection ret, Map<Long, String> processDefinitionMap) {
        HashSet<Long> userIds = new HashSet<Long>(ret.size());
        HashSet<Long> procInstIds = new HashSet<Long>(ret.size());
        for (DynamicObject dyObject : ret) {
            userIds.add(dyObject.getLong("startUserId"));
            procInstIds.add(dyObject.getLong("procInstId"));
        }
        Map<Long, String> assignMap = ProcessAssistantUtil.getPresentAssignee(procInstIds);
        Map<Object, Object> userInfoMap = userIds.isEmpty() ? new HashMap(ret.size()) : ProcessAssistantUtil.queryUserInfos(userIds);
        for (DynamicObject dyObject : ret) {
            Long startUserId;
            Date date = dyObject.getDate("createdate");
            Date endDate = dyObject.getDate("endTime");
            if (date != null) {
                long totalDuration = endDate != null ? endDate.getTime() - date.getTime() : WfUtils.now().getTime() - date.getTime();
                dyObject.set("handletime", (Object)WfUtils.formatTime(totalDuration));
            }
            if (WfUtils.isNotEmpty(startUserId = Long.valueOf(dyObject.getLong("startUserId")))) {
                UserInfo userInfo = (UserInfo)userInfoMap.get(startUserId.toString());
                dyObject.set("startUserAvatar", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
            }
            dyObject.set("processName", (Object)processDefinitionMap.get(dyObject.getLong("procDefId")));
            if (WfUtils.isEmptyString(dyObject.get("endTime"))) {
                dyObject.set("isEnd", (Object)Boolean.FALSE);
                this.packageActivityInfo(dyObject);
                if (!WfUtils.isNotEmptyForMap(assignMap)) continue;
                dyObject.set("presentassignee", (Object)assignMap.get(dyObject.getLong("procInstId")));
                continue;
            }
            dyObject.set("isEnd", (Object)Boolean.TRUE);
        }
    }

    private void packageActivityInfo(DynamicObject dyObject) {
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isNullObject(commandContext)) {
            return;
        }
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        long procInstId = dyObject.getLong("procInstId");
        ExecutionEntity byRootProcessInstanceId = executionMgr.findByRootProcessInstanceId(procInstId);
        dyObject.set("activityId", (Object)byRootProcessInstanceId.getActivityId());
        dyObject.set("activityName", (Object)byRootProcessInstanceId.getActivityName().getLocaleValue());
    }

    private String removeCommas(StringBuilder sb) {
        String str = "";
        if (WfUtils.isNotEmptyString(sb)) {
            str = sb.toString();
            str = str.length() != 0 ? str.substring(0, str.length() - 1) : "";
        }
        return str;
    }
}

