/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.nocodeflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageType;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class NoCodeFlowProcessGetAssistantApplyedTasksCmd
implements Command<DynamicObjectCollection>,
Serializable {
    private static final long serialVersionUID = -6763502634294991131L;
    private Long userId;
    private Integer start;
    private Integer limit;
    private String timeFilter;
    private String starterOrSubjectFilter;
    private String entityFilter;
    private String beginDate;
    private String endDate;
    private String entityName;
    private static final String PROCINSTID = "procinstid";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String PROCDEFID = "procDefId";
    private static final String PROCDEFNAME = "procDefName";
    private static final String USERID = "userid";
    private static final String STARTUSERID = "startUserId";
    private static final String STARTNAME = "startName";
    private static final String STARTUSERIMGURL = "startUserImgUrl";
    private static final String ACTIVITYID = "activityId";
    private static final String ACTIVITYNAME = "activityName";
    private static final String ACTIVITYUSERID = "activityUserId";
    private static final String ACTIVITYUSERNAME = "activityUserName";
    private static final String ACTIVITYUSERIMGURL = "activityUserImgUrl";
    private static final String CATEGORY = "category";
    private static final String HANDLESTATE = "handlestate";

    public NoCodeFlowProcessGetAssistantApplyedTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, String beginDate, String endDate, String entityName) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.entityName = entityName;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = EntityNumberConstant.getHiProcInstEntityNumber(SeparateStorageType.NOCODE.getKey());
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FENTRABILLNAME", "entityName", "entrabillname");
        String noCodeFlow = ThreadLocalVariables.get();
        String sql = "SELECT top " + (this.start + this.limit) + " a.FID procInstId, a.fbusinesskey businessKey,\ta.fstartuserid startUserId,\t'' startName,\t'' startUserImgUrl," + billNameSQL + ", a.fentitynumber entityNumber, a.fprocdefid procDefId, '' procDefName, a.fcreatedate createdate, a.fendtime endTime, a.fbillno billNo, a.fendtype endType, a.fdeletereason deleteReason, '' initiatorId, '' initiator, '' userImgUrl, '' handleState, '' activityUserId, '' activityUserName, '' activityUserImgUrl, '' activityId, '' activityName, '' handletime, '' category from " + TableNameConstant.getHiProcInstTableName(SeparateStorageType.NOCODE.getKey()) + " a LEFT JOIN " + TableNameConstant.getHiProcInstTableName(SeparateStorageType.NOCODE.getKey()) + "_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE a.fcreatorid =? AND a.FENDTIME is not NULL AND a.FENDTYPE <> ? " + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ");
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(lang);
        paramList.add(this.userId);
        paramList.add("20");
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            paramList.add(noCodeFlow);
        }
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and ( b.fsubject like ? )";
            paramList.add("%" + this.starterOrSubjectFilter + "%");
        }
        if (WfUtils.isNotEmpty(this.entityName)) {
            sql = sql + " and ( b.fentrabillname like ? )";
            paramList.add(this.entityName + "%");
        }
        sql = sql + " order by a.FcreateDate desc ";
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_nc_hiprocinst.queryGridData", (DBRoute)WfUtils.WFS, (String)sql, (Object[])paramList.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start.intValue(), this.limit.intValue());
            LinkedHashMap<Long, DynamicObject> proinstMap = new LinkedHashMap<Long, DynamicObject>();
            HashSet<Long> userIds = new HashSet<Long>(ret.size());
            HashSet<Long> procdefIds = new HashSet<Long>(ret.size());
            ArrayList<Long> procInstIds = new ArrayList<Long>(ret.size());
            for (DynamicObject dyObject : ret) {
                procInstIds.add(dyObject.getLong(PROCINSTID));
                userIds.add(dyObject.getLong(STARTUSERID));
                procdefIds.add(dyObject.getLong(PROCDEFID));
            }
            QFilter qFilter = new QFilter(PROCESSINSTANCEID, "in", procInstIds);
            DynamicObjectCollection cl = QueryServiceHelper.query((String)EntityNumberConstant.getHiCommentEntityNumber(SeparateStorageType.NOCODE.getKey()), (String)"processinstanceid,handlestate,userid,activityid,activityname,category,time", (QFilter[])new QFilter[]{qFilter}, (String)"time desc");
            if (WfUtils.isNotEmptyForCollection((Collection)cl)) {
                for (DynamicObject obj : cl) {
                    Long procInstId = obj.getLong(PROCESSINSTANCEID);
                    DynamicObject dynamicObject = (DynamicObject)proinstMap.get(procInstId);
                    if (dynamicObject == null || obj.getDate("time").after(dynamicObject.getDate("time"))) {
                        proinstMap.put(obj.getLong(PROCESSINSTANCEID), obj);
                    }
                    userIds.add(obj.getLong(USERID));
                }
            }
            Map<Long, String> procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procdefIds);
            Map<Object, Object> userInfoMap = new HashMap(ret.size());
            if (!userIds.isEmpty()) {
                userInfoMap = ProcessAssistantUtil.queryUserInfos(userIds);
            }
            for (DynamicObject dyObject : ret) {
                DynamicObject obj;
                Long startUserId;
                Date date = dyObject.getDate("createdate");
                Date endDate = dyObject.getDate("endtime");
                if (date != null) {
                    long totalDuration = endDate != null ? endDate.getTime() - date.getTime() : WfUtils.now().getTime() - date.getTime();
                    dyObject.set("handletime", (Object)WfUtils.formatTime(totalDuration));
                }
                if (WfUtils.isNotEmpty(startUserId = Long.valueOf(dyObject.getLong(STARTUSERID)))) {
                    UserInfo userInfo = (UserInfo)userInfoMap.get(startUserId.toString());
                    dyObject.set(STARTUSERIMGURL, (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                    dyObject.set(STARTNAME, userInfo != null ? userInfo.getName() : "");
                }
                if (WfUtils.isNotEmptyForMap(procdefMap)) {
                    dyObject.set(PROCDEFNAME, (Object)procdefMap.get(dyObject.getLong(PROCDEFID)));
                }
                if ((obj = (DynamicObject)proinstMap.get(dyObject.getLong(PROCINSTID))) == null) continue;
                dyObject.set(CATEGORY, (Object)obj.getString(CATEGORY));
                dyObject.set(HANDLESTATE, (Object)obj.getString(HANDLESTATE));
                dyObject.set(ACTIVITYID, (Object)obj.getString(ACTIVITYID));
                dyObject.set(ACTIVITYNAME, (Object)obj.getString(ACTIVITYNAME));
                Long activityUserId = obj.getLong(USERID);
                if (!WfUtils.isNotEmpty(activityUserId)) continue;
                UserInfo userInfo = (UserInfo)userInfoMap.get(activityUserId.toString());
                dyObject.set(ACTIVITYUSERID, (Object)activityUserId);
                dyObject.set(ACTIVITYUSERIMGURL, (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                dyObject.set(ACTIVITYUSERNAME, userInfo != null ? userInfo.getName() : "");
            }
            Iterator iterator = ret;
            return iterator;
        }
    }
}

