/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.nocodeflow;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntityImpl;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class NoCodeFlowSaveBillSubjectModelCmd
implements Command<Void> {
    private String entityNumber;
    private ILocaleString billSubjectName;
    private ILocaleString billSubjectMobName;

    public NoCodeFlowSaveBillSubjectModelCmd(String entityNumber, ILocaleString billSubjectName, ILocaleString billSubjectMobName) {
        this.entityNumber = entityNumber;
        this.billSubjectName = billSubjectName;
        this.billSubjectMobName = billSubjectMobName;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "=", (Object)this.entityNumber)};
        boolean exists = QueryServiceHelper.exists((String)"wf_billsubjectmodel", (QFilter[])filters);
        if (exists) {
            return null;
        }
        BillSubjectModelEntityImpl entity = new BillSubjectModelEntityImpl();
        String billId = MetadataDao.getIdByNumber((String)this.entityNumber, (MetaCategory)MetaCategory.Entity);
        entity.setBillId(billId);
        entity.setEntityNumber(this.entityNumber);
        entity.setBillName((ILocaleString)WfUtils.getEntityName(this.entityNumber, billId));
        entity.setBillSubjectName(this.billSubjectName);
        entity.setBillSubject(this.packageData(this.billSubjectName));
        entity.setBillSubjectMobName(this.billSubjectMobName);
        entity.setBillSubjectMob(this.packageData(this.billSubjectMobName));
        ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().saveBillSubject(entity);
        return null;
    }

    private ILocaleString packageData(ILocaleString str) {
        JSONArray array = new JSONArray();
        HashMap<String, String> billSubjectMap = new HashMap<String, String>();
        billSubjectMap.put("sv_rule", "");
        billSubjectMap.put("customSubject", WfMultiLangUtils.getValueFromLocalString(str, RequestContext.get().getLang().toString()));
        billSubjectMap.put("rule", "");
        billSubjectMap.put("type", "expression");
        billSubjectMap.put("scene", "task");
        array.add(billSubjectMap);
        return WfMultiLangUtils.getMultiLangValue(array.toJSONString());
    }
}

