/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.msg.MessageServiceUtil;

public class ProcessAssistantApplyedTasksCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = -6763502634294991131L;
    private Long userId;
    private Integer start;
    private Integer limit;
    private String timeFilter;
    private String starterOrSubjectFilter;
    private String entityFilter;
    private String beginDate;
    private String endDate;
    private String entityName;
    private static final String BILLNAME = "billName";
    private static final String SUBJECT = "subject";
    private static final String STARTNAME = "startname";
    private static final String INITIATORID = "initiatorId";
    private static final String PROCINSTID = "procinstid";

    public ProcessAssistantApplyedTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, String beginDate, String endDate, String entityName) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.entityName = entityName;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
        ArrayList<Map<String, Object>> applyedInstances = new ArrayList<Map<String, Object>>();
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_hiprocinst";
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FENTRABILLNAME", BILLNAME, "entrabillname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", SUBJECT, SUBJECT);
        String startnameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fstartname", STARTNAME, STARTNAME);
        String sql = "SELECT top " + (this.start + this.limit - 1) + " a.FID procinstid, a.FENDTIME endTime," + billNameSQL + "," + subjectSQL + ", a.FBUSINESSKEY businesskey,\ta.FSTARTUSERID startUserId, a.FENTITYNUMBER formId, a.FBILLNO billNo," + startnameSQL + " from t_wf_hiprocinst a LEFT JOIN t_wf_hiprocinst_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE a.fcreatorid =? AND a.FENDTIME is not NULL AND a.FENDTYPE <> ? ";
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(lang);
        paramList.add(this.userId);
        paramList.add("20");
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and ( b.fsubject like ? )";
            paramList.add("%" + this.starterOrSubjectFilter + "%");
        }
        if (WfUtils.isNotEmpty(this.entityName)) {
            sql = sql + " and ( b.fentrabillname like ? )";
            paramList.add(this.entityName + "%");
        }
        sql = sql + " order by a.FcreateDate desc ";
        HashSet<Long> userIds = new HashSet<Long>();
        userIds.add(this.userId);
        DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_hiprocinst.queryGridData", (DBRoute)WfUtils.WFS, (String)sql, (Object[])paramList.toArray());
        Object object = null;
        try {
            Object var16_16 = null;
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start - 1, this.limit.intValue());
            Iterator iter = ret.iterator();
            while (iter.hasNext()) {
                HashMap<String, Object> instance = new HashMap<String, Object>();
                DynamicObject row = (DynamicObject)iter.next();
                Long startUserId = row.getLong("startUserId");
                String string = row.getString(STARTNAME);
                if (WfUtils.isNotEmpty(startUserId)) {
                    userInfoMap.put(startUserId, string);
                    userIds.add(startUserId);
                    instance.put(INITIATORID, startUserId);
                } else {
                    instance.put(INITIATORID, this.userId);
                }
                instance.put(BILLNAME, row.get(BILLNAME));
                instance.put("endTime", row.get("endTime"));
                instance.put(PROCINSTID, row.get(PROCINSTID));
                instance.put("businessKey", row.getString("businesskey"));
                instance.put("formId", "wf_approvalmobileview_bac");
                instance.put("billNo", row.getString("billNo"));
                instance.put(SUBJECT, row.get(SUBJECT));
                instance.put("text", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ProcessAssistantApplyedTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                String url = MessageServiceUtil.buildWebPageUrlForMyApplyed((Long)row.get(PROCINSTID));
                instance.put("url", url);
                applyedInstances.add(instance);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map<String, UserInfo> userInfos = ProcessAssistantUtil.queryUserInfos(userIds, userInfoMap);
        for (Map map : applyedInstances) {
            String initiatorId = String.valueOf(map.get(INITIATORID));
            UserInfo userInfo = userInfos.get(initiatorId);
            if (userInfo == null) continue;
            map.put("initiator", userInfo.getName());
            map.put("userImgUrl", userInfo.getImgUrl());
            map.put("openId", userInfo.getOpenId());
        }
        return applyedInstances;
    }
}

