/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class ProcessAssistantGetApplyTasksCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = -5787880624231193278L;
    private Long userId;
    private Integer start;
    private Integer limit;
    private String timeFilter;
    private String starterOrSubjectFilter;
    private String entityFilter;
    private String beginDate;
    private String endDate;
    private static final String SUBJECT = "subject";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String INITIATORID = "initiatorId";
    private static final String SUSPENSIONSTATE = "suspensionState";
    private static final String USERNAME = "username";
    private static final String CATEGORY = "category";
    private static final String PROCESSASSISTANTGETAPPLYTASKSCMD_6 = "ProcessAssistantGetApplyTasksCmd_6";

    public ProcessAssistantGetApplyTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, String beginDate, String endDate) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        Object[] params;
        LinkedHashMap proinstMap = new LinkedHashMap();
        HashSet<Long> userIds = new HashSet<Long>();
        HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_execution";
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FENTRABILLNAME", "billname", "entrabillname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", SUBJECT, SUBJECT);
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FACTIVITYNAME", "activityname", "activityname");
        StringBuilder proinstIdsSB = new StringBuilder();
        String sql = "SELECT DISTINCT top " + (this.start + this.limit - 1) + " " + billNameSQL + "," + subjectSQL + "," + activityNameSQL + ",a.FBUSINESSKEY businesskey,a.FcreateDate createdate,a.FACTID actid,a.FPROCDEFID processdefinitionid,a.FPROCINSTID processinstanceid,a.FSUSPENSIONSTATE suspensionState,a.FENTITYNUMBER entiynumber, a.FSTARTUSERID startUserId  FROM t_wf_execution a  LEFT JOIN t_wf_execution_l b ON a.FID = b.FID AND b.FLOCALEID = ?  WHERE a.fcreatorid = ? AND a.FISSCOPE = '1' AND a.FSUPEREXEC = 0 ";
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and ( b.fsubject like ? )";
            params = new Object[]{lang, this.userId, "%" + this.starterOrSubjectFilter + "%"};
        } else {
            params = new Object[]{lang, this.userId};
        }
        sql = sql + " order by a.FcreateDate desc ";
        try (DataSet ds = DB.queryDataSet((String)"ProcessAssistant.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start - 1, this.limit.intValue());
            Map<String, Object> userInfo = ProcessAssistantUtil.queryUserInfo(this.userId, null);
            for (DynamicObject row : ret) {
                HashMap<String, Object> applyTask = new HashMap<String, Object>();
                applyTask.put("billName", row.get("billname"));
                applyTask.put("createDate", row.get("createdate"));
                applyTask.put("procinstid", row.get(PROCESSINSTANCEID));
                applyTask.put("businessKey", row.get("businesskey"));
                long startUserId = row.getLong("startUserId");
                applyTask.put(INITIATORID, WfUtils.isNotEmpty(startUserId) ? startUserId : 0L);
                applyTask.put("initiator", userInfo.get("name"));
                applyTask.put("userImgUrl", userInfo.get("imgUrl"));
                applyTask.put("openId", userInfo.get("openId"));
                applyTask.put("formId", "wf_approvalpagemobile_bac");
                applyTask.put(SUBJECT, row.get(SUBJECT));
                applyTask.put(SUSPENSIONSTATE, row.get(SUSPENSIONSTATE));
                if (ManagementConstants.SUSPENDED.getStateCode().equals(row.get(SUSPENSIONSTATE))) {
                    applyTask.put("text", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ProcessAssistantGetApplyTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                } else {
                    proinstIdsSB.append(row.get(PROCESSINSTANCEID)).append(",");
                }
                if (WfUtils.isNotEmpty(startUserId)) {
                    userIds.add(startUserId);
                }
                proinstMap.put(String.valueOf(row.getLong(PROCESSINSTANCEID)), applyTask);
            }
        }
        if (proinstIdsSB.length() > 0) {
            String inProinstIds = "(" + proinstIdsSB.substring(0, proinstIdsSB.length() - 1) + ")";
            String usernameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "a", "al", "fusername", USERNAME, USERNAME);
            String sqlForUser = "SELECT a.FUSERID userId,b.FPROCINSTID procinstId,b.fcategory category,b.fhandlestate handlestate," + usernameSQL + " from t_wf_task b LEFT JOIN t_wf_participant a ON a.FTASKID = b.FID LEFT JOIN t_wf_participant_l al on a.FID = al.FID WHERE al.FLocaleID = '" + Lang.get().toString() + "' and a.FTYPE = 'participant' and b.FPROCINSTID in " + inProinstIds;
            DataSet dataSet = DB.queryDataSet((String)"wf.wf_task.queryGridData", (DBRoute)DBRoute.workflow, (String)sqlForUser, null);
            Object iter = null;
            try {
                for (Row r : dataSet) {
                    long inititor;
                    Long proinst = r.getLong("procinstId");
                    Long userId = r.getLong("userId");
                    String category = r.getString(CATEGORY);
                    if (!WfUtils.isNotEmpty(proinst)) continue;
                    Map applyTask = (Map)proinstMap.get(proinst.toString());
                    applyTask.put(CATEGORY, category);
                    if ("SSCApprove".equals(category)) {
                        applyTask.put("text", String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279%s", (String)"ProcessAssistantGetApplyTasksCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), GraphCodecUtils.getSSCStateName(String.valueOf(r.get("handlestate")))));
                    } else {
                        if (WfUtils.isEmpty(userId)) continue;
                        if (WfUtils.isEmptyString(applyTask.get("text"))) {
                            applyTask.put("text", userId);
                        } else {
                            String text = applyTask.get("text").toString() + "," + userId;
                            applyTask.put("text", text);
                        }
                    }
                    userIds.add(userId);
                    userInfoMap.put(userId, r.getString(USERNAME));
                    if (applyTask == null || (inititor = ((Long)applyTask.get(INITIATORID)).longValue()) <= 0L || inititor == userId) continue;
                    userIds.add(inititor);
                }
            }
            catch (Throwable iter2) {
                iter = iter2;
                throw iter2;
            }
            finally {
                if (dataSet != null) {
                    if (iter != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable iter2) {
                            ((Throwable)iter).addSuppressed(iter2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        if (!userIds.isEmpty()) {
            Map<String, UserInfo> userInfo = ProcessAssistantUtil.queryUserInfos(userIds, userInfoMap);
            UserInfo user = null;
            for (Map m : proinstMap.values()) {
                String muserIds;
                if (WfUtils.isEmptyString(m.get("text"))) {
                    m.put("text", ResManager.loadKDString((String)"\u6b63\u5728\u8fd0\u884c", (String)"ProcessAssistantGetApplyTasksCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                    continue;
                }
                String suffix = ResManager.loadKDString((String)"\u5904\u7406", (String)"ProcessAssistantGetApplyTasksCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
                if (m.get(CATEGORY) != null && BpmnModelUtil.instanceofAuditTask(m.get(CATEGORY).toString())) {
                    suffix = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"ProcessAssistantGetApplyTasksCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                }
                if ((muserIds = m.get("text").toString()).contains(",")) {
                    String[] idsStr = muserIds.split(",");
                    HashSet<String> ids = new HashSet<String>(idsStr.length);
                    for (int i = 0; i < idsStr.length; ++i) {
                        ids.add(idsStr[i]);
                    }
                    StringBuilder sb = new StringBuilder();
                    int j = 0;
                    String text = "";
                    for (String id : ids) {
                        if (j > 2) {
                            text = String.format(ResManager.loadKDString((String)"\u7b49\u5f85%1$s\uff1a%2$s\u7b49", (String)"ProcessAssistantGetApplyTasksCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), suffix, sb.substring(0, sb.length() - 1));
                            break;
                        }
                        user = userInfo.get(id);
                        if (!WfUtils.isNotEmpty(id) || user == null || !WfUtils.isNotEmpty(user.getName())) continue;
                        ++j;
                        sb.append(user.getName()).append(",");
                    }
                    if (WfUtils.isEmpty(text) && sb.length() > 0) {
                        text = String.format(ResManager.loadKDString((String)"\u7b49\u5f85%1$s\uff1a%2$s", (String)PROCESSASSISTANTGETAPPLYTASKSCMD_6, (String)"bos-wf-engine", (Object[])new Object[0]), suffix, sb.substring(0, sb.length() - 1));
                    }
                    m.put("text", text);
                } else {
                    user = userInfo.get(muserIds);
                    if (user != null && WfUtils.isNotEmpty(user.getName())) {
                        m.put("text", String.format(ResManager.loadKDString((String)"\u7b49\u5f85%1$s\uff1a%2$s", (String)PROCESSASSISTANTGETAPPLYTASKSCMD_6, (String)"bos-wf-engine", (Object[])new Object[0]), suffix, user.getName()));
                    }
                }
                if ((user = userInfo.get(m.get(INITIATORID) + "")) == null) continue;
                m.put("initiator", user.getName());
                m.put("userImgUrl", user.getImgUrl());
            }
        }
        return new ArrayList<Map<String, Object>>(proinstMap.values());
    }
}

