/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class ProcessAssistantGetCountCmd
implements Command<Map<String, Integer>>,
Serializable {
    private static final long serialVersionUID = 5376675933931358412L;
    public static final String TODOCOUNT = "todoCount";
    public static final String DONECOUNT = "doneCount";
    public static final String MYTODOCOUNT = "myTodoCount";
    public static final String MYDONECOUNT = "myDoneCount";
    protected String userId;

    public ProcessAssistantGetCountCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Map<String, Integer> execute(CommandContext commandContext) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        countMap.put(TODOCOUNT, this.getTodoTaskCount(commandContext));
        countMap.put(DONECOUNT, this.getDoneTaskCount(commandContext));
        countMap.put(MYTODOCOUNT, this.getApplyTaskCount(commandContext));
        countMap.put(MYDONECOUNT, this.getApplyedTaskCount(commandContext));
        return countMap;
    }

    protected Integer getTodoTaskCount(CommandContext commandContext) {
        String sql = "select  count(1) count from t_wf_task a INNER JOIN t_wf_participant b on a.fid=b.ftaskid  where a.FISDISPLAY = ? and b.FISDISPLAY = '1' and b.ftaskid>0 and b.fuserid = ? and b.fcompositetaskid = 0  AND a.fendtype != 'pc' ";
        return this.executeSql(sql, new Object[]{"1", Long.valueOf(this.userId)}, "TodoTaskCount");
    }

    protected Integer getDoneTaskCount(CommandContext commandContext) {
        String sql = WfConfigurationUtil.isHiTaskSingleTableQuery() != false && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete() != false ? "SELECT count(1) count from t_wf_hicomment a where a.fuserid=? and a.FISDISPLAY = ? AND a.fendtype != 'pc' " : "SELECT count(1) count from t_wf_hitaskinst a where a.FASSIGNEEID=? and a.FENDTIME is not null and a.FISDISPLAY = ? AND a.fendtype != 'pc' ";
        return this.executeSql(sql, new Object[]{Long.valueOf(this.userId), "1"}, "doneTaskCount");
    }

    protected Integer getApplyTaskCount(CommandContext commandContext) {
        String sql = "SELECT count(1) count from t_wf_execution a WHERE a.FPARENTID=0 AND a.fcreatorid =?";
        return this.executeSql(sql, new Object[]{Long.valueOf(this.userId)}, "ApplyTaskCount");
    }

    protected Integer getApplyedTaskCount(CommandContext commandContext) {
        String sql = "SELECT count(1) count from t_wf_hiprocinst a WHERE a.fcreatorid =? AND a.FENDTIME is not NULL AND a.FENDTYPE <> '20' ";
        return this.executeSql(sql, new Object[]{Long.valueOf(this.userId)}, "TodoTaskCount");
    }

    private Integer executeSql(String sql, Object[] params, String queryKey) {
        Long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)queryKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("count");
            }
        }
        return count.intValue();
    }
}

