/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.TaskUtils;

public class ProcessAssistantGetHandledTasksCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 7689957569521600593L;
    private Long userId;
    private Integer start;
    private Integer limit;
    private String timeFilter;
    private String starterOrSubjectFilter;
    private String entityFilter;
    private String beginDate;
    private String endDate;
    private static final String BILLNAME = "billName";
    private static final String INITIATOR = "initiator";
    private static final String SUBJECT = "subject";
    private static final String PRESENTASSIGNEE = "presentassignee";
    private static final String CURRENTSUBJECT = "currentsubject";

    public ProcessAssistantGetHandledTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, String beginDate, String endDate) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        Object[] params;
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            return this.getHandledTasksBySingleRelationQuery(commandContext);
        }
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_hitaskinst";
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fentityname", BILLNAME, "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", INITIATOR, "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", SUBJECT, SUBJECT);
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fpresentassignee", PRESENTASSIGNEE, PRESENTASSIGNEE);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", "d", "e", "fcurrentsubject", CURRENTSUBJECT, CURRENTSUBJECT);
        ArrayList<Map<String, Object>> handledTaskList = new ArrayList<Map<String, Object>>();
        String sql = "SELECT top " + (this.start + this.limit - 1) + " a.FID taskId," + billNameSQL + ",a.FBUSINESSKEY billId," + startNameSQL + ",a.FSTARTERID initiatorId,a.fhandlestate handlestate," + subjectSQL + "," + presentAssigneeSQL + "," + currentSubjectSQL + ",a.FPROCESSINGMOBILEPAGE processingMobilePage,a.fcategory category,a.fsource source,d.ftype type, d.FTIME endTime FROM t_wf_hicomment d LEFT JOIN t_wf_hicomment_l e on d.fid = e.fid and e.FLOCALEID = ? and d.FUSERID =? and d.ftype != 'suggestion' INNER JOIN t_wf_hitaskinst a ON a.fid = d.FTASKID INNER JOIN t_wf_hitaskinst_l b ON a.FID = b.FID AND b.FLOCALEID = ? where d.FUSERID =? and d.ftype != 'suggestion' and a.FEXECUTIONTYPE != ? and a.FISDISPLAY = ? AND a.fendtype != 'pc'";
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and ( b.fsubject like ? or e.fcurrentsubject like ?)";
            params = new Object[]{lang, this.userId, lang, this.userId, "byAuto", "1", "%" + this.starterOrSubjectFilter + "%", "%" + this.starterOrSubjectFilter + "%"};
        } else {
            params = new Object[]{lang, this.userId, lang, this.userId, "byAuto", "1"};
        }
        sql = sql + " order by d.FTIME desc ";
        try (DataSet ds = DB.queryDataSet((String)"ProcessAssistant.wf_hitask.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start - 1, this.limit.intValue());
            Iterator iter = ret.iterator();
            HashSet<Long> user = new HashSet<Long>();
            while (iter.hasNext()) {
                DynamicObject row = (DynamicObject)iter.next();
                HashMap<String, Object> handledTask = new HashMap<String, Object>();
                handledTask.put("taskId", row.get("taskId"));
                handledTask.put(BILLNAME, row.get(BILLNAME));
                handledTask.put("billId", row.get("billId"));
                handledTask.put(INITIATOR, row.get(INITIATOR));
                Long initiatorId = (Long)row.get("initiatorId");
                handledTask.put("initiatorId", initiatorId);
                if (WfUtils.isNotEmpty(initiatorId)) {
                    user.add(initiatorId);
                }
                handledTask.put("endTime", row.get("endTime"));
                if (StringUtils.isNotBlank((Object)row.get(CURRENTSUBJECT))) {
                    handledTask.put(SUBJECT, row.get(CURRENTSUBJECT));
                } else {
                    handledTask.put(SUBJECT, row.get(SUBJECT));
                }
                handledTask.put("formId", row.get("processingMobilePage"));
                handledTask.put("text", TaskHelper.getHandledStatusDesc(row.getString("handlestate")));
                handledTask.put("activityname", row.get(PRESENTASSIGNEE));
                String type = row.getString("type");
                if ("coordinate".equals(type)) {
                    handledTask.put("text", ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"ProcessAssistantGetHandledTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                } else if ("forceReject".equals(type)) {
                    handledTask.put("text", ResManager.loadKDString((String)"\u5df2\u5f3a\u5236\u9a73\u56de", (String)"ProcessAssistantGetHandledTasksCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                handledTask.put("category", row.getString("category"));
                handledTask.put("isBizTask", TaskUtils.isBizTask(row.getString("source")));
                handledTaskList.add(handledTask);
            }
            this.getUserImgUrl(handledTaskList, user);
        }
        return handledTaskList;
    }

    private List<Map<String, Object>> getHandledTasksBySingleRelationQuery(CommandContext commandContext) {
        Object[] params;
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fentityname", BILLNAME, "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "FSTARTNAME", INITIATOR, "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fcurrentsubject", SUBJECT, CURRENTSUBJECT);
        String presentAssigneeSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fpresentassignee", PRESENTASSIGNEE, PRESENTASSIGNEE);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_hicomment", masterTableAlias, multiLangTableAlias, "fcurrentsubject", CURRENTSUBJECT, CURRENTSUBJECT);
        ArrayList<Map<String, Object>> handledTaskList = new ArrayList<Map<String, Object>>();
        StringBuilder sb = new StringBuilder();
        String sql = sb.append("SELECT top ").append(this.start + this.limit - 1).append(" a.ftaskid taskId,a.FBUSINESSKEY billId,a.FSTARTERID initiatorId,a.fhandlestate handlestate,").append("a.FPROCESSINGMOBILEPAGE processingMobilePage,a.ftype type,a.FTIME endTime,a.fcategory category,a.fsource source,").append(billNameSQL).append(",").append(startNameSQL).append(",").append(subjectSQL).append(",").append(presentAssigneeSQL).append(",").append(currentSubjectSQL).append(" FROM t_wf_hicomment a").append(" LEFT JOIN t_wf_hicomment_l b on a.fid = b.fid and b.FLOCALEID = ?").append(" where a.FUSERID =? ").append("and a.ftype in ('message','comment','coordinate', 'converted', 'event') ").append("and a.fexecutiontype in ('byHand','byExpireAuto','skip','jump','enterBoundary','frozen','abandon','cancel','addSignBefore','compensation', ' ') ").append("and a.FISDISPLAY = ? AND a.fendtype != 'pc'").toString();
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and (b.fcurrentsubject like ?)";
            params = new Object[]{lang, this.userId, "1", "%" + this.starterOrSubjectFilter + "%"};
        } else {
            params = new Object[]{lang, this.userId, "1"};
        }
        sql = sql + " order by a.FTIME desc ";
        try (DataSet ds = DB.queryDataSet((String)"ProcessAssistant.wf_hitask.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start - 1, this.limit.intValue());
            Iterator iter = ret.iterator();
            HashSet<Long> user = new HashSet<Long>();
            while (iter.hasNext()) {
                DynamicObject row = (DynamicObject)iter.next();
                HashMap<String, Object> handledTask = new HashMap<String, Object>();
                handledTask.put("taskId", row.get("taskId"));
                handledTask.put(BILLNAME, row.get(BILLNAME));
                handledTask.put("billId", row.get("billId"));
                handledTask.put(INITIATOR, row.get(INITIATOR));
                Long initiatorId = (Long)row.get("initiatorId");
                if (WfUtils.isNotEmpty(initiatorId)) {
                    user.add(initiatorId);
                }
                handledTask.put("initiatorId", initiatorId);
                handledTask.put("endTime", row.get("endTime"));
                handledTask.put(SUBJECT, row.get(SUBJECT));
                handledTask.put("formId", row.get("processingMobilePage"));
                handledTask.put("text", TaskHelper.getHandledStatusDesc(row.getString("handlestate")));
                handledTask.put("activityname", row.get(PRESENTASSIGNEE));
                if ("coordinate".equals(row.getString("type"))) {
                    handledTask.put("text", ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"ProcessAssistantGetHandledTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                handledTask.put("category", row.getString("category"));
                handledTask.put("isBizTask", TaskUtils.isBizTask(row.getString("source")));
                handledTaskList.add(handledTask);
            }
            this.getUserImgUrl(handledTaskList, user);
        }
        return handledTaskList;
    }

    private void getUserImgUrl(List<Map<String, Object>> handledTaskList, Set<Long> user) {
        Map<String, Map<String, Object>> userInfoMap = ProcessAssistantUtil.queryUserInfo(user, null);
        for (Map<String, Object> objectMap : handledTaskList) {
            Long initiatorId = (Long)objectMap.get("initiatorId");
            if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(initiatorId)) {
                Map<String, Object> userInfo = userInfoMap.get(initiatorId.toString());
                objectMap.put("userImgUrl", userInfo != null ? userInfo.get("imgUrl") : "");
                objectMap.put("openId", userInfo != null ? userInfo.get("openId") : "");
                continue;
            }
            objectMap.put("userImgUrl", "");
            objectMap.put("openId", "");
        }
    }
}

