/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.task.TaskUtils;

public class ProcessAssistantGetTasksCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 5073134357679291310L;
    private Long userId;
    private Integer start;
    private Integer limit;
    private String timeFilter;
    private String starterOrSubjectFilter;
    private String entityFilter;
    private boolean withoutUserTask;
    private String beginDate;
    private String endDate;
    private String priorityFilter;
    private Map<String, String> stateMap = new HashMap<String, String>();
    private static final String BILLNAME = "billName";
    private static final String INITIATOR = "initiator";
    private static final String SUBJECT = "subject";
    private static final String CURRENTSUBJECT = "currentsubject";
    protected Log logger = LogFactory.getLog(this.getClass());

    public ProcessAssistantGetTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, boolean withoutUserTask, String beginDate, String endDate) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.stateMap.put("dismissed", ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ProcessAssistantGetTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("willApproval", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"ProcessAssistantGetTasksCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("freeze", ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ProcessAssistantGetTasksCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("willHandled", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ProcessAssistantGetTasksCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("manualSuspended", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ProcessAssistantGetTasksCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
    }

    public ProcessAssistantGetTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, boolean withoutUserTask, String beginDate, String endDate, String priorityFilter) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.priorityFilter = priorityFilter;
        this.stateMap.put("dismissed", ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ProcessAssistantGetTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("willApproval", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"ProcessAssistantGetTasksCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("freeze", ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ProcessAssistantGetTasksCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("willHandled", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ProcessAssistantGetTasksCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("manualSuspended", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ProcessAssistantGetTasksCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        Object[] params;
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_task";
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fentityName", BILLNAME, "entityname");
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FSTARTNAME", INITIATOR, "startname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fsubject", SUBJECT, SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fname", "name", "name");
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "c", "d", "fcurrentsubject", CURRENTSUBJECT, CURRENTSUBJECT);
        ArrayList<Map<String, Object>> taskList = new ArrayList<Map<String, Object>>();
        String sql = "select DISTINCT top " + (this.start + this.limit - 1) + " a.fid taskId," + billNameSQL + "," + startNameSQL + ",a.FSTARTERID initiatorId," + subjectSQL + "," + currentSubjectSQL + ",a.FBUSINESSKEY billId,a.FHANDLESTATE state,a.FSUSPENSIONSTATE suspensionstate,a.FPROCESSINGMOBILEPAGE processingMobilePage," + nameSQL + ",c.ftype type,c.FPRIORITY priority,c.FCREATEDATE createDate,a.fcategory category, a.fsource source from t_wf_task a left JOIN t_wf_task_l b on a.fid=b.fid AND b.FLOCALEID = ? INNER JOIN t_wf_participant c on a.fid=c.ftaskid LEFT JOIN t_wf_participant_l d on c.fid = d.fid and d.FLOCALEID = ?where c.ftaskid>0 and c.fuserid = ? and c.fcompositetaskid = 0 and a.FISDISPLAY = ? and c.FISDISPLAY = '1' AND a.fendtype != 'pc' " + (this.withoutUserTask ? "AND a.FCATEGORY != 'UserTask' " : "");
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        this.logger.debug("ProcessAssistantGetTasksCmd before timeFilter: " + this.timeFilter + "beginDate: " + this.beginDate + " endData:" + this.endDate);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        this.logger.debug("ProcessAssistantGetTasksCmd after beginDate: " + this.beginDate + " endData:" + this.endDate);
        sql = ProcessAssistantUtil.sqlAddPriorityFilter(sql, this.priorityFilter);
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and ( b.fsubject like ? or d.fcurrentsubject like ?)";
            params = new Object[]{lang, lang, this.userId, "1", "%" + this.starterOrSubjectFilter + "%", "%" + this.starterOrSubjectFilter + "%"};
        } else {
            params = new Object[]{lang, lang, this.userId, "1"};
        }
        sql = sql + " order by c.FPRIORITY desc, c.FcreateDate desc ";
        try (DataSet ds = DB.queryDataSet((String)"ProcessAssistantGetTasksCmd", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start - 1, this.limit.intValue());
            StringBuilder markSql = new StringBuilder();
            markSql.append("select a.ftaskid taskid, b.fvalue value from t_wf_taskmark b inner join t_wf_rtrelation a on b.fid = a.fmarkid ").append("where a.fuserid = ? and a.fruletype != 'folder';");
            HashMap markMap = new HashMap();
            try (DataSet markDs = DB.queryDataSet((String)"ProcessAssistantGetTasksCmd.wf_taskmark.queryGridData", (DBRoute)DBRoute.workflow, (String)markSql.toString(), (Object[])new Object[]{this.userId});){
                for (Row row : markDs) {
                    Long taskid = row.getLong("taskid");
                    String value = row.getString("value");
                    if (!WfUtils.isNotEmpty(value)) continue;
                    if (markMap.containsKey(taskid)) {
                        Set set = (Set)markMap.get(taskid);
                        set.add(value);
                        continue;
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(value);
                    markMap.put(taskid, hashSet);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            Iterator iter = ret.iterator();
            String initiatorName = null;
            HashSet<Long> user = new HashSet<Long>();
            HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
            while (iter.hasNext()) {
                DynamicObject row = (DynamicObject)iter.next();
                HashMap<String, Object> task = new HashMap<String, Object>(14);
                Long l = (Long)row.get("initiatorId");
                initiatorName = row.getString(INITIATOR);
                if (WfUtils.isNotEmpty(l)) {
                    user.add(l);
                    userInfoMap.put(l, initiatorName);
                }
                Long taskId = row.getLong("taskId");
                task.put("taskId", taskId);
                if (markMap.get(taskId) != null) {
                    Set set = (Set)markMap.get(taskId);
                    set.remove("100");
                    set.remove("60");
                    set.add(String.valueOf(row.get("priority")));
                    Iterator it = set.iterator();
                    StringBuilder str = new StringBuilder();
                    while (it.hasNext()) {
                        str.append(String.valueOf(it.next())).append(",");
                    }
                    String value = str.toString();
                    value = value.length() != 0 ? value.substring(0, value.length() - 1) : "";
                    task.put("priority", value);
                } else {
                    task.put("priority", row.get("priority"));
                }
                String starter = ResManager.loadKDString((String)"\u53d1\u8d77\u7684", (String)"ProcessAssistantGetTasksCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
                String billName = row.get(INITIATOR) + starter + row.get(BILLNAME);
                if (lang.equals(Lang.en_US.toString())) {
                    billName = row.get(INITIATOR) + " " + starter + " " + row.get(BILLNAME);
                }
                task.put(BILLNAME, billName);
                task.put("billId", row.get("billId"));
                task.put(INITIATOR, initiatorName);
                task.put("initiatorId", l);
                if (StringUtils.isNotBlank((Object)row.get(CURRENTSUBJECT))) {
                    task.put(SUBJECT, row.get(CURRENTSUBJECT));
                } else {
                    task.put(SUBJECT, row.get(SUBJECT));
                }
                task.put("formId", row.get("processingMobilePage"));
                task.put("type", row.get("type"));
                task.put("createDate", row.get("createDate"));
                String state = row.getString("state");
                String suspensionstate = row.getString("suspensionstate");
                if (ManagementConstants.SUSPENDED.getStateCode().equals(suspensionstate)) {
                    state = "manualSuspended";
                }
                if ("coordinate".equals(row.getString("type"))) {
                    state = "willHandled";
                }
                if (WfUtils.isNotEmpty(state) && WfUtils.isNotEmpty(this.stateMap.get(state))) {
                    task.put("text", this.stateMap.get(state));
                } else {
                    task.put("text", "");
                }
                task.put("name", row.get("name"));
                task.put("category", row.get("category"));
                task.put("isBizTask", TaskUtils.isBizTask(row.getString("source")));
                taskList.add(task);
            }
            Map<String, Map<String, Object>> userInfoMaps = ProcessAssistantUtil.queryUserInfo(user, userInfoMap);
            for (Map map : taskList) {
                Long initiatorId = (Long)map.get("initiatorId");
                if (WfUtils.isNotEmptyForMap(userInfoMaps) && WfUtils.isNotEmpty(initiatorId)) {
                    Map<String, Object> userInfo = userInfoMaps.get(initiatorId.toString());
                    map.put("userImgUrl", userInfo != null ? userInfo.get("imgUrl") : "");
                    map.put("openId", userInfo != null ? userInfo.get("openId") : "");
                    map.put(INITIATOR, userInfo != null ? userInfo.get("name").toString() : "");
                    continue;
                }
                map.put("userImgUrl", "");
                map.put("openId", "");
            }
        }
        return taskList;
    }
}

